/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.Memory;
import Sav.Processor.NonRecognizableNumberException;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.TParser.Fielder;
import Sav.Z.Combination;
import Sav.Z.Copula;
import Sav.Z.DataBase;
import Sav.Z.Error;
import Sav.Z.Failure;
import Sav.Z.Lexis;
import Sav.Z.Procedure;
import Sav.Z.Session;
import Sav.Z.Statement;
import Sav.Z.ZException;
import java.io.File;
import java.io.IOException;

class Expression
implements Lexis {
    Statement stm;
    int index;
    String text;
    int begin;
    int end;
    Copula copula;
    PList list = new PList();
    String type;
    File file;
    Expression eContext;
    int feature;
    Association ass;
    Concept cnc;
    String string;
    boolean designated;

    void affect(Expression expression) {
        this.stm = expression.stm;
        this.index = expression.index;
        this.text = expression.text;
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = expression.copula;
        this.list = expression.list;
        this.type = expression.type;
        this.file = expression.file;
        this.eContext = expression.eContext;
        this.feature = expression.feature;
        this.ass = expression.ass;
        this.cnc = expression.cnc;
        this.string = expression.string;
    }

    Expression() {
    }

    Expression(Statement statement) throws ZException {
        this.stm = statement;
        this.text = statement.text;
        try {
            this.equip();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Error(exception, statement, this.begin);
            throw new ZException(exception.toString());
        }
    }

    void equip() {
        int n2;
        char c2 = '\u0000';
        int n3 = this.stm.end;
        this.begin = this.stm.pos;
        this.begin = Fielder.passSpace(this.stm.text, this.begin, n3);
        if (this.begin != this.stm.pos) {
            this.stm.pos = this.begin;
        }
        this.end = this.begin;
        this.index = -10;
        if (this.begin == n3) {
            return;
        }
        c2 = this.text.charAt(this.begin);
        if (c2 == '#' || c2 == '$') {
            n2 = this.recognizeNumber(this.end, n3);
            if (n2 == 2) {
                this.compose(2, c2);
                return;
            }
        } else if (c2 >= '0' && c2 <= '9' && (this.stm.copula == null || this.stm.copula.index != 6) && (n2 = this.recognizeNumber(this.end, n3)) == 2) {
            this.compose(2, '\u0000');
            return;
        }
        if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
            n2 = 5;
        } else {
            n2 = "$*#\"'' {[(}])^:/\\| ~= ,;<>".indexOf(c2);
            if (n2 < 0) {
                n2 = 5;
            }
        }
        if (n2 > 6) {
            if ((n2 == 13 || n2 == 14 || n2 == 17 && c2 == '|') && this.stm.copula != null && this.stm.copula.look == c2) {
                this.warnErr1(String.valueOf(String.valueOf(new StringBuffer("Redundant or duplicate ").append(c2).append(" symbol"))));
                this.stm.pos = ++this.begin;
                this.equip();
            }
            return;
        }
        ++this.end;
        switch (n2) {
            case 0: {
                char c3;
                int n4 = this.end;
                while (this.end < n3) {
                    c3 = this.text.charAt(this.end);
                    int n5 = "$*#\"'' {[(}])^:/\\| ~= ,;<>".indexOf(c3);
                    if (c3 == '\"' || c3 == '\'') {
                        this.end = Fielder.passQuote(this.text, this.end, c3);
                        break;
                    }
                    if (c3 <= '\u001f' || n5 >= 0 && (c3 != ' ' || this.end == n4)) break;
                    ++this.end;
                }
                if (this.end == n4) {
                    this.warnErr0("Unrecognized '$' specification");
                    this.stm.pos = ++this.begin;
                    this.equip();
                    return;
                }
                if (this.end < n3 && (c3 = this.text.charAt(this.end)) == '*') {
                    ++this.end;
                }
                this.compose(0, '$');
                return;
            }
            case 5: {
                while (this.end < n3) {
                    char c4 = this.text.charAt(this.end);
                    int n6 = "$*#\"'' {[(}])^:/\\| ~= ,;<>".indexOf(c4);
                    if (c4 <= '\u001f' || n6 >= 0) break;
                    ++this.end;
                }
                this.compose(5, '\u0000');
                return;
            }
            case 1: 
            case 2: {
                this.compose(n2, c2);
                return;
            }
            case 3: 
            case 4: {
                this.end = Fielder.passQuote(this.text, this.begin, c2);
                if (this.end == n3 && this.text.charAt(this.end - 1) != c2) {
                    this.warnErr0(String.valueOf(String.valueOf(new StringBuffer("Unclosed ").append(c2).append(" left quote"))));
                    this.stm.pos = ++this.begin;
                    this.equip();
                    return;
                }
                this.compose(n2, c2);
                return;
            }
        }
    }

    int recognizeNumber(int n2, int n3) {
        int n4;
        int n5 = 0;
        char c2 = this.text.charAt(n2);
        if (c2 == '#') {
            ++n2;
        } else if (c2 == '$' && ++n2 == n3) {
            return 5;
        }
        for (n4 = n2; n4 < n3; ++n4) {
            char c3 = this.text.charAt(n4);
            if (c3 >= '0' && c3 <= '9' || c3 == '.' && (c2 == '#' || c2 == '$' || n4 != n2 && ++n5 == 1)) continue;
            if (c2 == '#') break;
            if (c2 == '$') {
                if (n4 > n2) break;
                return 5;
            }
            int n6 = Fielder.passSpace(this.text, n4, n3);
            c3 = this.text.charAt(n6);
            int n7 = "$*#\"'' {[(}])^:/\\| ~= ,;<>".indexOf(c3);
            if (n7 < 0) {
                return 5;
            }
            if (c3 != ' ' && c3 != '*') break;
            return 5;
        }
        this.end = n4;
        return 2;
    }

    void compose(int n2, char c2) {
        this.index = n2;
        this.copula = new Copula(this.stm.text, this.begin, n2, c2);
        this.stm.pos = this.end;
        this.string = this.text.substring(this.begin, this.end);
    }

    Expression(Statement statement, int n2, int n3) {
        this.stm = statement;
        this.text = statement.text;
        this.begin = n3;
        this.end = n3;
        this.index = n2;
        this.string = this.text.substring(this.begin, this.end);
    }

    Expression(Statement statement, int n2, int n3, int n4) {
        this.stm = statement;
        this.text = statement.text;
        this.begin = n3;
        this.end = n4;
        this.index = n2;
        this.string = this.text.substring(n3, n4);
    }

    Expression(Statement statement, Copula copula, Expression expression) {
        this.stm = statement;
        this.text = statement.text;
        this.add(copula, expression);
    }

    Expression(Statement statement, Expression expression, Copula copula, Expression expression2) {
        this.stm = statement;
        this.text = statement.text;
        this.add(expression, copula, expression2);
    }

    void add(Copula copula, Expression expression) {
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(copula.look, (Object)expression);
        this.string = this.text.substring(this.begin, this.end);
    }

    void add(Expression expression, Copula copula, Expression expression2) {
        this.begin = expression.begin;
        this.end = expression2.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(expression);
        this.list.add(copula.look, (Object)expression2);
        this.string = this.text.substring(this.begin, this.end);
    }

    void insert(Expression expression) {
        this.begin = expression.begin;
        this.list.getFirst();
        this.list.insert(expression);
        this.string = this.text.substring(this.begin, this.end);
    }

    void construe(Expression expression, int n2) throws ZException {
        try {
            this.construe1(expression, n2);
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Error(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    void construe1(Expression expression, int n2) throws IOException {
        switch (this.index) {
            case -10: {
                this.eContext = expression;
                this.feature = n2;
                break;
            }
            case 0: {
                this.construeSpecific(expression, n2);
                break;
            }
            case 6: {
                this.construeSpace(expression, n2);
                break;
            }
            case 7: {
                this.construeBrace(expression, n2);
                break;
            }
            case 8: {
                this.construeBracket(expression, n2);
                break;
            }
            case 9: {
                this.construeParenthesis(expression, n2);
                break;
            }
            case 12: {
                this.construeParenthesisTerm(expression, n2);
                break;
            }
            case 13: {
                this.construeRange(expression, n2);
                break;
            }
            case 14: {
                this.construeColon(expression, n2);
                break;
            }
            case 15: {
                this.construeDivide(expression, n2);
                break;
            }
            case 16: {
                this.construeLeftSlash(expression, n2);
                break;
            }
            case 17: {
                this.construeRightSlash(expression, n2);
                break;
            }
            case 18: {
                this.construeExtraction(expression, n2);
                break;
            }
            case 21: {
                this.construeDeclaration(expression, n2);
                break;
            }
            case 19: 
            case 20: {
                if ((n2 & 0x80) == 0) {
                    this.construeEquality(expression, n2);
                    break;
                }
                this.construeAssignement(expression, n2);
                break;
            }
            case 22: {
                this.construeComma(expression, n2);
            }
        }
        if (this.list.hasOne() && (this.index > 12 || this.index == 6)) {
            Expression expression2 = (Expression)this.list.getFirst();
            if (expression2.index == -10) {
                this.index = -10;
            } else {
                this.affect(expression2);
            }
        } else if (this.list.isEmpty()) {
            if (this.index == -4) {
                this.copula.look = (char)40;
                this.list.add(new Expression(this.stm, -10, this.end));
                this.stm.proc = new Procedure(this);
                this.stm.proc.construe();
            } else if (this.index >= 6) {
                this.index = -10;
            }
        }
    }

    void construeSpecific(Expression expression, int n2) {
        Concept concept;
        Concept concept2;
        boolean bl2;
        int n3;
        int n4;
        String string;
        int n5;
        this.eContext = expression;
        this.feature = n2;
        int n6 = this.begin + 1;
        if (this.text.charAt(n6) != '\"' && this.text.charAt(n6) != '\'') {
            for (n5 = n6; n5 < this.end && this.text.charAt(n5) != '\"' && this.text.charAt(n5) != '\'' && this.text.charAt(n5) != ' ' && this.text.charAt(n5) != '*'; ++n5) {
            }
            string = this.text.substring(n6, n5);
        } else {
            string = "";
            n5 = n6;
        }
        Integer n7 = (Integer)Session.hTypes.get(string);
        if (n7 != null) {
            this.index = n7;
            while (n5 < this.end && this.text.charAt(n5) == ' ') {
                ++n5;
            }
            n4 = n5;
        } else {
            n4 = n6;
        }
        if (this.text.charAt(this.end - 1) == '*') {
            n3 = this.end - 1;
            bl2 = true;
        } else {
            n3 = this.end;
            bl2 = false;
        }
        if (this.text.charAt(n3 - 1) == '\"' || this.text.charAt(n3 - 1) == '\'') {
            --n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n5 = n4; n5 < n3; ++n5) {
            char c2 = this.text.charAt(n5);
            if (c2 != '\"' && c2 != '\'' && c2 != ' ') {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == ' ') {
                ++n5;
                while (n5 < n3 && (c2 = this.text.charAt(n5)) == ' ') {
                    ++n5;
                }
                if (n5 == n3) break;
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(' ');
            }
            if (c2 == '\"' || c2 == '\'') {
                ++n5;
                while (n5 < n3) {
                    stringBuffer.append(this.text.charAt(n5));
                    ++n5;
                }
                break;
            }
            stringBuffer.append(this.text.charAt(n5));
        }
        String string2 = stringBuffer.toString();
        if (this.index < 0) {
            concept2 = new Concept(-this.index);
            this.type = Session.types[-this.index];
        } else {
            concept2 = null;
        }
        this.cnc = concept = new Concept(string2);
        Concept concept3 = null;
        Concept concept4 = null;
        try {
            if (bl2) {
                if (concept2 == null) {
                    this.stm.ss.spec.con(61);
                    this.stm.ss.spec.see(concept);
                    concept3 = this.stm.ss.spec.getFirst(56);
                    if (concept3 != null) {
                        if (this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Ambiguous specific name ").append(string2).append("*"))), n4);
                            this.cnc = concept3;
                        }
                        this.stm.ss.spec.con(concept3).con(61);
                        concept4 = this.stm.ss.spec.getFirst(56);
                        if (this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr("Ambiguous specific type", this.begin + 1);
                            this.type = Session.types[concept4.toInteger()];
                        }
                    }
                } else {
                    this.stm.ss.spec.con(57).con(concept2);
                    if (this.stm.ss.spec.hasConnect(57)) {
                        concept4 = concept2;
                        this.stm.ss.spec.con(57);
                        this.stm.ss.spec.see(concept);
                        concept3 = this.stm.ss.spec.getFirst(56);
                        if (concept3 != null && this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Ambiguous specific name ").append(string2).append("*"))), n4);
                            this.cnc = concept3;
                        }
                    }
                }
                this.stm.ss.spec.regain();
            } else {
                if (concept2 == null) {
                    this.stm.ss.spec.con(61).con(concept);
                    if (this.stm.ss.spec.hasConnect(61)) {
                        concept3 = concept;
                        this.stm.ss.spec.con(61);
                        concept4 = this.stm.ss.spec.getFirst(56);
                        if (this.stm.ss.spec.getNext(56) != null) {
                            this.warnErr("Ambiguous specific type", this.begin + 1);
                            this.type = Session.types[concept4.toInteger()];
                        }
                    }
                } else {
                    this.stm.ss.spec.con(57).con(concept2);
                    if (this.stm.ss.spec.hasConnect(57)) {
                        concept4 = concept2;
                        this.stm.ss.spec.con(57);
                        concept3 = this.stm.ss.spec.get(concept);
                    }
                }
                this.stm.ss.spec.regain();
            }
            if (concept3 == null) {
                if (bl2) {
                    this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Unrecognized specific name ").append(string2).append("*"))), n4);
                    this.index = -10;
                    return;
                }
            } else if (bl2) {
                this.cnc = concept3;
                concept = concept3;
                string2 = concept3.toString();
            }
            if (concept4 == null) {
                if (concept2 == null) {
                    this.index = -3;
                    concept2 = new Concept(-this.index);
                    this.type = "mul";
                }
            } else if (concept2 == null) {
                this.index = -concept4.toInteger();
                concept2 = concept4;
            }
            switch (this.index) {
                case -5: {
                    this.index = 5;
                    this.cnc = new Concept("$".concat(String.valueOf(String.valueOf(string2))));
                    return;
                }
                case -4: {
                    if (n2 != 128) {
                        this.warnErr0("Unexpected procedure");
                        this.index = -10;
                    } else if (concept3 == null) {
                        this.warnErr("Unrecognized procedure name", n4);
                        this.index = -10;
                    }
                    return;
                }
                case -3: {
                    break;
                }
                case -2: {
                    if ((n2 & 8) == 0) {
                        this.warnErr0("Unexpected file specification");
                        this.index = -10;
                        return;
                    }
                    if ((string2 = string2.trim()).equals("")) {
                        this.warnErr0("Indefined file name");
                        this.index = -10;
                        return;
                    }
                    this.file = new File(string2);
                    break;
                }
                case -1: {
                    if ((n2 & 0xFFFFFF7B) != 0) {
                        this.warnErr0("Unexpected base specification");
                        this.index = -10;
                        return;
                    }
                    if ((string2 = string2.trim()).length() != 0 && string2.indexOf(46) < 0) {
                        string2 = String.valueOf(String.valueOf(string2)).concat(".ass");
                    }
                    this.stm.sNewBase = string2;
                    this.stm.ss.spec.con(57).con(concept2);
                    this.stm.ss.spec.con(57).con(concept);
                    if (n2 == 128) {
                        this.stm.ss.scr_modify = !this.stm.ss.spec.hasConnect(59);
                    } else if ((n2 & 4) != 0) {
                        this.stm.ss.spec.clearConnect(59);
                        this.stm.ss.scr_modify = true;
                    } else {
                        this.stm.ss.spec.setConnect(59, new Concept());
                        this.stm.ss.scr_modify = false;
                    }
                    this.stm.ss.spec.regain();
                }
            }
            if (concept4 == null || concept3 == null) {
                this.stm.ss.spec.con(61).con(concept);
                this.stm.ss.spec.setConnect(61, concept2);
                this.stm.ss.spec.regain();
                this.stm.ss.spec.con(57).con(concept2);
                this.stm.ss.spec.setConnect(57, concept);
                this.stm.ss.spec.regain();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void construeSpace(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        if ((n2 & 0x80) != 0) {
            this.stm.modify = true;
        }
        int n3 = 0;
        int n4 = 0;
        Expression expression2 = (Expression)this.list.getFirst();
        block6: while (expression2 != null) {
            int n5 = expression2.end - expression2.begin;
            if ((n3 += n5) > PN.MAX_NAME_LENGTH) {
                expression2.warnErr0(String.valueOf(String.valueOf(new StringBuffer("Name length > PN.MAX_NAME_LENGTH(").append(PN.MAX_NAME_LENGTH).append(")"))));
                break;
            }
            expression2.eContext = expression;
            expression2.feature = n2;
            switch (expression2.index) {
                case 5: {
                    expression2.construeWord();
                    if (expression2.index == -10) {
                        this.list.remove();
                        break;
                    }
                    if (n4 == 4) {
                        expression2.warnErr0("Unexpected word after '...'* quote");
                        break block6;
                    }
                    if (n4 == 3) {
                        expression2.warnErr0("Unexpected word after \"...\"* string");
                        break block6;
                    }
                    if (n4 != 2) break;
                    expression2.warnErr0("Unexpected word after #n* number");
                    break block6;
                }
                case 2: {
                    expression2.construeNumber();
                    String string = expression2.index == 5 ? "word" : "number";
                    if (expression2.index == -10) {
                        this.list.remove();
                        break;
                    }
                    if (n4 == 4) {
                        expression2.warnErr0(String.valueOf(String.valueOf(new StringBuffer("Unexpected ").append(string).append(" after '...'* quote"))));
                        break block6;
                    }
                    if (n4 == 3) {
                        expression2.warnErr0(String.valueOf(String.valueOf(new StringBuffer("Unexpected ").append(string).append(" after \"...\"* string"))));
                        break block6;
                    }
                    if (n4 == 2) {
                        expression2.warnErr0(String.valueOf(String.valueOf(new StringBuffer("Unexpected ").append(string).append(" after #n* number"))));
                        break block6;
                    }
                    if (expression2.index != 2) break;
                    n4 = 2;
                    break;
                }
                case 3: {
                    expression2.construeString();
                    if (expression2.index == -10) {
                        this.list.remove();
                        break;
                    }
                    if (n4 == 4) {
                        expression2.warnErr0("Unexpected string after '...'* quote");
                        break block6;
                    }
                    if (n4 == 2) {
                        expression2.warnErr0("Unexpected string after #n* number");
                        break block6;
                    }
                    n4 = 3;
                    break;
                }
                case 4: {
                    expression2.construeQuote();
                    if (expression2.index == -10) {
                        this.list.remove();
                        break;
                    }
                    if (n4 == 3) {
                        expression2.warnErr0("Unexpected quote after \"...\"* string");
                        break block6;
                    }
                    if (n4 == 2) {
                        expression2.warnErr0("Unexpected quote after #n* number");
                        break block6;
                    }
                    n4 = 4;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
        while (expression2 != null) {
            this.list.remove();
            expression2 = (Expression)this.list.getNext();
        }
        expression2 = (Expression)this.list.getFirst();
        if (expression2 == null) {
            return;
        }
        if (!this.list.hasNext()) {
            this.cnc = expression2.cnc;
        }
    }

    void construeWord() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void construeNumber() {
        char c2 = this.text.charAt(this.begin);
        if (this.end - this.begin == 1 && c2 == '#') {
            return;
        }
        String string = this.text.substring(this.begin, this.end);
        try {
            this.cnc = new Concept(string, true);
        }
        catch (NonRecognizableNumberException nonRecognizableNumberException) {
            if (c2 != '#' && c2 != '$') {
                this.index = 5;
                this.cnc = new Concept(this.text.substring(this.begin, this.end));
            } else {
                this.warnErr0(nonRecognizableNumberException.getMessage());
                this.index = -10;
            }
            return;
        }
    }

    void construeString() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void construeQuote() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void construeBrace(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        if ((n2 & 0x80) != 0) {
            this.stm.modify = true;
        }
        n2 = n2 & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        this.end = expression2.end + 1;
        this.list = expression2.list;
        Expression expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            expression3.construe(expression, n2);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeBracket(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 = n2 & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        this.end = expression2.end + 1;
        this.list = expression2.list;
        Expression expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            expression3.construe(null, n2);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeParenthesis(Expression expression, int n2) throws IOException {
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index != -10) {
            this.construeProcedure(expression, n2);
            if (expression2.index != -3) {
                return;
            }
        }
        this.eContext = expression;
        this.feature = n2;
        n2 = n2 & 0x80 | 0x40;
        Expression expression3 = (Expression)this.list.getLast();
        this.end = expression3.end + 1;
        if (expression2.index == -3) {
            this.index = 12;
            expression3.construeComma(expression, n2);
            if (expression3.index == -10) {
                this.list.remove();
            } else {
                expression3.index = 9;
            }
            return;
        }
        this.list = expression3.list;
        int n3 = 0;
        expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(null, n2);
            if (expression2.index == -10 && ++n3 > 1) {
                if (expression2.copula == null) {
                    expression2.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeProcedure(Expression expression, int n2) throws IOException {
        this.eContext = expression;
        this.feature = n2;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construeSpecific(expression, n2);
        if (expression2.index == -10) {
            this.index = -10;
            return;
        }
        if (expression2.index == -3) {
            return;
        }
        if (expression2.index != -4) {
            expression2.warnErr("Unrecognized procedure name", expression2.begin + 1);
            this.index = -10;
            return;
        }
        if (this.stm.root != null) {
            this.warnErr0("Unexpected procedure");
            this.index = -10;
            return;
        }
        this.begin = expression2.begin;
        this.index = -4;
        this.cnc = expression2.cnc;
        Expression expression3 = (Expression)this.list.getNext();
        Expression expression4 = (Expression)expression3.list.getLast();
        this.end = expression4.index == -10 ? expression4.begin + 1 : expression3.end + 1;
        this.list = expression3.list;
        this.stm.proc = new Procedure(this);
        this.stm.proc.construe();
    }

    void construeParenthesisTerm(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n2);
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            expression2.construe(expression, n2);
            if (expression2.index == -10) {
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeRange(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 = n2 & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        expression2.construe(expression, n2);
        Expression expression3 = (Expression)this.list.getFirst();
        expression3.construe(expression, n2);
        Expression expression4 = expression3;
        Expression expression5 = (Expression)this.list.getNext();
        while (expression5 != expression2) {
            expression4.warnErr1("Surplus '^' range");
            expression4 = expression5;
            this.list.remove();
            expression5 = (Expression)this.list.getNext();
        }
        if (expression3.index == -10 && expression2.index == -10) {
            this.warnErr0("Unexpected '^' range");
            this.list.remove();
        }
    }

    /*
     * Unable to fully structure code
     */
    void construeColon(Expression var1_1, int var2_2) {
        var3_3 = null;
        this.eContext = var1_1;
        this.feature = var2_2;
        var2_2 = var2_2 & 128 | 64;
        var4_4 = (Expression)this.list.getFirst();
        while (var4_4 != null) {
            var4_4.construe(var1_1, var2_2);
            if (var4_4.index != -10) ** GOTO lbl-1000
            if (!this.list.hasNext()) {
                return;
            }
            if (var3_3 != null) {
                if (var4_4.copula == null) {
                    var4_4.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            } else lbl-1000:
            // 2 sources

            {
                if (var3_3 == null) {
                    var3_3 = var4_4;
                }
                var1_1 = var4_4;
            }
            var4_4 = (Expression)this.list.getNext();
        }
    }

    void construeDivide(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 &= 0xFFFFFF7F;
        n2 = n2 & 0x80 | 0x40;
        int n3 = 0;
        boolean bl2 = false;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n2);
            if (expression2.index == -10 && expression2.copula != null) {
                this.list.remove();
                break;
            }
            if (expression2.index == -10 && bl2) {
                expression2.warnErr0("Unexpected indefinitude");
                this.list.remove();
                break;
            }
            if (++n3 == 3) break;
            bl2 = expression2.index == -10;
            expression = expression2;
            expression2 = (Expression)this.list.getNext();
        }
        if (n3 == 3 && this.list.hasNext()) {
            expression2.warnErr1("Redundant '/' divider");
        }
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            this.list.remove();
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeLeftSlash(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 = n2 & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getLast();
        expression2.construe(expression, n2);
        if (expression2.index == -10) {
            this.index = -10;
            if (expression2.copula == null) {
                expression2.warnErr0("Unexpected indefinitude");
            }
        }
    }

    void construeRightSlash(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 = n2 & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n2);
        if (expression2.index == -10) {
            this.index = -10;
        }
        Expression expression3 = (Expression)this.list.getNext();
        expression3.construe(null, n2);
        Expression expression4 = (Expression)this.list.getNext();
        while (expression4 != null) {
            expression4.construe(null, n2);
            if (expression4.index == -10 && expression4.copula != null) {
                this.list.remove();
            }
            expression4 = (Expression)this.list.getNext();
        }
    }

    void construeExtraction(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        Expression expression2 = (Expression)this.list.getLast();
        if (this.copula.look == '~') {
            expression2.construe(expression, n2 &= 0xFFFFFF7F);
            if (expression2.index != -1 && n2 != 128) {
                this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Unexpected '").append(this.copula.look).append("' symbol"))), this.copula.position);
                this.index = -10;
            }
            return;
        }
        if ((n2 & 4) != 0) {
            this.warnErr(String.valueOf(String.valueOf(new StringBuffer("Unexpected '").append(this.copula.look).append("' symbol"))), this.copula.position);
            this.list.getFirst();
            this.list.remove();
            expression2.construe(expression, n2);
            return;
        }
        expression2.construe(expression, n2 &= 0);
        if (expression2.index == -10) {
            if (expression2.copula == null) {
                expression2.warnErr0("Unexpected indefinitude");
            }
            this.index = -10;
            return;
        }
        if (expression2.index == -1) {
            this.stm.ss.scr_modify = false;
            ++this.stm.scr.modifyCount;
        }
    }

    void construeDeclaration(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        if ((n2 &= 0x80) != 128) {
            n2 |= 0x40;
        }
        n2 = this.copula.look == '~' ? (n2 &= 0xFFFFFF7F) : (n2 |= 0x80);
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n2 |= 4);
        if (expression2.index == -10) {
            if (expression2.copula == null) {
                expression2.warnErr0("Unexpected indefinitude");
            }
            this.index = -10;
            return;
        }
        if (expression2.index == -1) {
            this.stm.ss.scr_modify = true;
            ++this.stm.scr.modifyCount;
        } else if ((n2 & 0x80) != 0) {
            this.stm.modify = true;
        }
    }

    void construeAssignement(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 = this.index == 19 ? n2 & 0x80 & 0xFFFFFF7F : n2 & 0x80 | 0x80;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n2 |= 0x40);
        Expression expression3 = (Expression)this.list.getNext();
        while (expression3 != null) {
            expression3.construe(expression, n2);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
        if (expression2.index == -10) {
            this.index = -10;
        }
    }

    void construeEquality(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        n2 = n2 & 0x80 | 0x40;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n2);
        Expression expression3 = (Expression)this.list.getNext();
        while (expression3 != null) {
            expression3.construe(expression, n2);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeComma(Expression expression, int n2) {
        this.eContext = expression;
        this.feature = n2;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n2);
            if (expression2.index == -10) {
                if (expression2.copula == null) {
                    expression2.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void executeStatement() {
        this.executeStatement(null);
    }

    void executeStatement(Association association) {
        try {
            if (this.index < 22) {
                this.executeStatement1(association);
            } else {
                Long1 long1 = Memory.init();
                Expression expression = (Expression)this.list.getFirst();
                while (expression != null) {
                    if (expression.executeStatement1(association)) {
                        if (this.ass == null) {
                            this.ass = expression.ass;
                        } else {
                            this.ass.set(expression.ass);
                        }
                        expression.ass = null;
                    }
                    this.controlMemory(long1, this.list);
                    expression = (Expression)this.list.getNext();
                }
            }
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.freeInnerExpression();
            new Error(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    boolean executeStatement1(Association association) {
        Procedure procedure;
        if (this.needLogin()) {
            procedure = new Procedure("login", this);
            procedure.execute();
        }
        if (this.index == 18 && this.feature == 128) {
            Expression expression = (Expression)this.list.getLast();
            if (expression.index != -1) {
                this.feature = 8;
                procedure = new Procedure("printEquality", this);
                procedure.equality = true;
                procedure.execute();
                return false;
            }
        }
        return this.execute(association);
    }

    boolean needLogin() {
        if (this.stm.ss.access == 1) {
            return false;
        }
        if (this.index == -4 && this.stm.proc.index == 13) {
            return false;
        }
        Expression expression = this.index == 18 ? (Expression)this.list.getLast() : (this.index == 21 ? (Expression)this.list.getFirst() : this);
        return expression.index != -1;
    }

    boolean execute() {
        return this.execute(null);
    }

    boolean execute(Association association) {
        try {
            boolean bl2 = this.execute1(association);
            return bl2;
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.freeInnerExpression();
            new Failure(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    Association association() {
        return this.ass;
    }

    boolean execute1(Association association) throws IOException {
        switch (this.index) {
            case -10: {
                return this.executeNone(association);
            }
            case -1: {
                this.stm.ss.openModify(this.stm.sNewBase);
                return false;
            }
            case -4: {
                return this.stm.proc.execute();
            }
            case -3: {
                return this.executeMultitude(association);
            }
            case 1: {
                return this.executeEllipsis(association);
            }
            case 2: 
            case 3: {
                return this.executeDesignation(association);
            }
            case 4: {
                return this.executeQuote(association);
            }
            case 5: {
                return this.executeWord(association);
            }
            case 6: {
                return this.executeSpace(association);
            }
            case 7: {
                return this.executeBrace(association);
            }
            case 8: {
                return this.executeBracket(association);
            }
            case 12: {
                return this.executeParenthesisTerm(association);
            }
            case 13: {
                return this.executeRange(association);
            }
            case 14: {
                return this.executeColon(association);
            }
            case 15: {
                return this.executeDivide(association);
            }
            case 16: {
                return this.executeLeftSlash(association);
            }
            case 17: {
                return this.executeRightSlash(association);
            }
            case 18: {
                return this.executeExtraction(association);
            }
            case 21: {
                return this.executeDeclaration(association);
            }
            case 19: {
                if ((this.feature & 0x80) == 0) {
                    return this.executeInEquality(association);
                }
                return this.executeSubtruction(association);
            }
            case 20: {
                if ((this.feature & 0x80) == 0) {
                    return this.executeEquality(association);
                }
                return this.executeAssignement(association);
            }
            case 22: {
                return this.executeComma(association);
            }
        }
        return false;
    }

    boolean executeNone(Association association) throws IOException {
        if ((this.feature & 0x80) == 0) {
            return this.requestNone(association);
        }
        return this.describeNone(association);
    }

    boolean requestNone(Association association) throws IOException {
        this.ass = association;
        return this.yields1();
    }

    boolean describeNone(Association association) throws IOException {
        this.ass = this.stm.ss.db.insertDesObject(association, null);
        return this.yields1();
    }

    boolean executeMultitude(Association association) throws IOException {
        this.ass = this.mul(this.cnc.toString());
        if (!this.yields()) {
            return false;
        }
        if (association == null || this.designated) {
            this.ass = this.ass.get();
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectClass(association, this.ass) : this.stm.ss.db.insertClass(association, this.ass);
        return this.yields1();
    }

    Association mul(String string) {
        Association association = (Association)this.stm.ss.mh.h.get(string);
        if (association == null) {
            association = new Association();
            association.setComplete(true);
            this.stm.ss.mh.h.put(string, association);
        }
        return association;
    }

    boolean executeEllipsis(Association association) throws IOException {
        this.ass = this.stm.ss.db.selectAllObjects(association);
        return this.yields1();
    }

    boolean executeDesignation(Association association) throws IOException {
        if (this.cnc != null && (association == null || this.designated)) {
            this.ass = new Association();
            this.ass.set(this.cnc);
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectDesObject(association, this.cnc) : this.stm.ss.db.insertDesObject(association, this.cnc);
        return this.yields1();
    }

    boolean executeQuote(Association association) throws IOException {
        if (this.cnc != null && this.designated) {
            this.ass = new Association();
            this.ass.set(this.cnc);
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectDenObject(association, this.cnc) : this.stm.ss.db.insertDenObject(association, this.cnc);
        return this.yields1();
    }

    boolean executeWord(Association association) throws IOException {
        if (this.cnc != null && this.designated) {
            this.ass = new Association();
            this.ass.set(this.cnc);
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectDenObject(association, this.cnc) : this.stm.ss.db.insertDenObject(association, this.cnc);
        return this.yields1();
    }

    boolean executeSpace(Association association) throws IOException {
        Combination combination = new Combination(association, this.list);
        combination.designated = this.designated;
        this.ass = (this.feature & 0x80) == 0 ? combination.request(this.stm.ss.db) : combination.describe(this.stm.ss.db);
        return this.yields1();
    }

    boolean executeBrace(Association association) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            expression.designated = this.designated;
            if (expression.execute(association)) {
                if (this.ass == null) {
                    this.ass = expression.ass;
                } else {
                    if (this.ass.getSense1() != expression.ass.getSense1()) {
                        this.deriveCValue();
                        expression.deriveCValue();
                    }
                    if (this.ass.getResolution() <= expression.ass.getResolution()) {
                        this.ass.set(expression.ass, 57, 64, expression.ass.getResolution());
                    } else {
                        expression.ass.set(this.ass, 57, 64, this.ass.getResolution());
                        this.ass = expression.ass;
                    }
                }
                expression.ass = null;
                this.controlMemory(long1, association);
            }
            expression = (Expression)this.list.getNext();
        }
        if (this.ass != null) {
            this.ass.setComplete(true);
        }
        return this.ass != null;
    }

    boolean deriveCName() throws IOException {
        if (this.ass.getSense0() == 64) {
            return true;
        }
        PList pList = new PList();
        pList.add(57, null);
        Association association = this.stm.ss.db.base.getBy(this.ass, 57, 64, 0, pList);
        association.setSense(this.ass.getSense());
        association.setResolution(this.ass.getResolution());
        this.ass = association;
        return this.yields1();
    }

    boolean deriveCValue() throws IOException {
        return this.deriveCValue(false);
    }

    boolean deriveCValue(boolean bl2) throws IOException {
        this.ass.setComplete(true);
        if (this.ass.getSense1() != 57) {
            return this.ass.has();
        }
        int n2 = this.ass.getResolution();
        this.ass = this.stm.ss.db.base.get(this.ass);
        this.ass.setResolution(n2);
        if (bl2) {
            return this.yields1();
        }
        if (this.ass.has()) {
            return true;
        }
        if (this.feature != 128) {
            this.warnFail(this.eContext, "");
        }
        return false;
    }

    boolean executeBracket(Association association) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.execute(null)) {
                if (this.ass == null) {
                    this.ass = expression.ass;
                } else {
                    if (this.ass.getSense1() != expression.ass.getSense1()) {
                        this.deriveCValue();
                        expression.deriveCValue();
                    }
                    if (this.ass.getResolution() <= expression.ass.getResolution()) {
                        this.ass.set(expression.ass, 57, 64, expression.ass.getResolution());
                    } else {
                        expression.ass.set(this.ass, 57, 64, this.ass.getResolution());
                        this.ass = expression.ass;
                    }
                }
                expression.ass = null;
                this.controlMemory(long1, association);
            }
            expression = (Expression)this.list.getNext();
        }
        if (this.ass == null) {
            return false;
        }
        this.deriveCValue();
        this.ass = (this.feature & 0x80) == 0 ? this.stm.ss.db.selectClass(association, this.ass) : this.stm.ss.db.insertClass(association, this.ass);
        return this.yields1();
    }

    boolean executeParenthesisTerm(Association association) throws IOException {
        if ((this.feature & 0x80) == 0) {
            return this.requestParenthesisTerm(association);
        }
        return this.describeParenthesisTerm(association);
    }

    boolean requestParenthesisTerm(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (expression.index == -10 && (association == null || association == PN.aNull)) {
            this.ass = new Association();
        } else {
            if (!expression.execute(association)) {
                return false;
            }
            this.ass = expression.ass;
            expression.ass = null;
        }
        PList pList = new PList();
        PList pList2 = new PList();
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            PList pList3 = expression2.list;
            expression2 = (Expression)pList3.getFirst();
            while (expression2 != null) {
                if (expression2.index == -10) {
                    pList.add(59, null);
                    break;
                }
                if (!expression2.execute(null)) {
                    this.ass = null;
                    return false;
                }
                pList.add(59, (Object)expression2.ass);
                expression2.ass = null;
                pList2.add(expression2);
                Memory.control(long1, this.ass, pList);
                expression2 = (Expression)pList3.getNext();
            }
            expression2 = (Expression)this.list.getNext();
        }
        pList = this.stm.ss.db.selectSchema(this.ass, pList, pList2);
        if (!pList2.isEmpty() || pList == null) {
            expression.warnFail("", pList2, "Non-existent schema");
            this.ass = null;
            return false;
        }
        this.ass = this.stm.ss.db.selectRelation(this.ass, pList);
        return this.yields1();
    }

    boolean describeParenthesisTerm(Association association) throws IOException {
        PList pList;
        Expression expression;
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index == -10) {
            expression = (Expression)this.list.getNext();
            if (!this.executeKeyParenthesisTerm(association, expression2, expression)) {
                return false;
            }
            if (!this.list.hasNext()) {
                return true;
            }
        } else {
            if (!expression2.execute(association)) {
                return false;
            }
            this.ass = expression2.ass;
            expression2.ass = null;
        }
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        expression = (Expression)this.list.getNext();
        while (expression != null) {
            pList = expression.list;
            expression = (Expression)pList.getFirst();
            while (expression != null) {
                if (expression.index == -10) {
                    pList2.add(59, null);
                    break;
                }
                if (expression.execute(null)) {
                    pList2.add(59, (Object)expression.ass);
                    expression.ass = null;
                    pList3.add(expression);
                    Memory.control(long1, this.ass, pList2);
                }
                expression = (Expression)pList.getNext();
            }
            expression = (Expression)this.list.getNext();
        }
        pList = this.stm.ss.db.insertSchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            expression2.warnFail("", pList3, "Non-describable schema");
        }
        if (pList != null) {
            this.stm.ss.db.insertContent0(this.ass, pList);
            this.stm.ss.db.insertRelation(this.ass, pList);
        }
        return this.yields1();
    }

    boolean executeKeyParenthesisTerm(Association association, Expression expression, Expression expression2) throws IOException {
        PList pList = expression2.list;
        Expression expression3 = (Expression)pList.getFirst();
        if (expression3.index == -10) {
            this.ass = this.stm.ss.db.insertDesObject(association, null);
            return true;
        }
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        while (expression3 != null) {
            if (!expression3.execute(null)) {
                return false;
            }
            pList2.add(59, (Object)expression3.ass);
            expression3.ass = null;
            pList3.add(expression3);
            Memory.control(long1, this.stm.ss.db.base, pList2);
            expression3 = (Expression)pList.getNext();
        }
        if (association == null || association == PN.aNull) {
            this.stm.ss.db.base.see(37);
            this.ass = this.stm.ss.db.base.getBy(56, pList2);
            this.stm.ss.db.base.see();
        } else {
            this.ass = this.stm.ss.db.base.getBy(association, pList2);
        }
        if (this.ass.has()) {
            return true;
        }
        this.ass = this.stm.ss.db.insertDesObject(association, null);
        PList pList4 = this.stm.ss.db.insertSchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            this.warnFail("", pList3, "Non-describable schema");
            this.stm.ss.db.base.clear(this.ass);
            this.ass = null;
            return false;
        }
        if (pList4 != null) {
            this.stm.ss.db.insertContent0(this.ass, pList4);
            this.stm.ss.db.insertRelation(this.ass, pList4);
        }
        return this.yields1();
    }

    boolean executeRange(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        if (expression.index == -10 && expression2.index == -10) {
            if (association == null || association == PN.aNull) {
                this.ass = this.stm.ss.db.base.get();
            } else {
                this.ass = association.get();
                this.ass.setSense(57);
            }
            return this.yields1();
        }
        if (!(expression.cnc == null && expression.index != -10 || expression2.cnc == null && expression2.index != -10 || association != null && association == PN.aNull)) {
            this.ass = this.stm.ss.db.selectLevelInterval(association, expression.cnc, expression2.cnc);
        } else {
            if (expression.index != -10 && !expression.execute(association) && !expression.deriveCValue()) {
                return false;
            }
            if (expression2.index != -10 && !expression2.execute(association) && !expression2.deriveCValue()) {
                return false;
            }
            this.ass = this.stm.ss.db.selectInterval(association, expression.ass, expression2.ass);
        }
        expression.ass = null;
        expression2.ass = null;
        return this.yields1();
    }

    boolean executeColon(Association association) throws IOException {
        Expression expression = null;
        int n2 = 0;
        Long1 long1 = Memory.init();
        if (association != null) {
            n2 = association.getSense();
        }
        this.ass = association;
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index == -10) {
            if (this.ass == null) {
                this.ass = PN.aNull;
            }
            expression = expression2;
            expression2 = (Expression)this.list.getNext();
        }
        boolean bl2 = false;
        while (expression2 != null) {
            if (this.ass != null && this.ass != PN.aNull) {
                if (expression != null && expression.unaided()) {
                    this.ass.setSense(121);
                    bl2 = true;
                } else {
                    this.ass.setSense(57);
                }
            }
            if (expression2.index == -10) {
                if (!this.list.hasNext()) break;
            } else {
                expression = expression2;
                if (expression2.index == 1 && (this.ass == null || this.ass == PN.aNull)) {
                    expression2 = (Expression)this.list.getNext();
                    if (this.ass == null) {
                        if (expression2.index == -10) {
                            this.ass = this.stm.ss.db.selectAllObjects(null, PN.aNull);
                            break;
                        }
                    } else if (this.ass == PN.aNull) {
                        if (expression2 == null) {
                            this.ass = this.stm.ss.db.selectAllObjects(PN.aNull, null);
                            break;
                        }
                        if (expression2.index == -10) {
                            this.ass = this.stm.ss.db.selectAllObjects(PN.aNull, PN.aNull);
                            break;
                        }
                    }
                    expression2 = (Expression)this.list.getBack();
                }
                if (!expression2.execute(this.ass)) {
                    if (bl2) {
                        this.ass.setSense(64);
                        break;
                    }
                    this.ass = null;
                    break;
                }
                this.ass = expression2.ass;
                expression2.ass = null;
                this.controlMemory(long1);
            }
            expression2 = (Expression)this.list.getNext();
        }
        if (association != null) {
            association.setSense(n2);
        }
        if (this.ass == null) {
            return false;
        }
        return this.yields1();
    }

    boolean unaided() {
        if (this.index != 12) {
            return false;
        }
        this.list.getFirst();
        Expression expression = (Expression)this.list.getNext();
        while (expression != null) {
            Expression expression2 = (Expression)expression.list.getFirst();
            if (expression2.index == -10) {
                return true;
            }
            expression = (Expression)this.list.getNext();
        }
        return false;
    }

    boolean executeDivide(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        Expression expression3 = (Expression)this.list.getNext();
        DataBase dataBase = this.stm.ss.db;
        Association association2 = new Association();
        boolean bl2 = false;
        if (expression3 == null) {
            if (expression2.index == -10) {
                bl2 = expression.execute(association);
                if (bl2) {
                    bl2 = expression.deriveCValue();
                }
                Association association3 = expression.ass;
                expression.ass = null;
                if (!bl2) {
                    return false;
                }
                this.ass = dataBase.selectCValue(association3);
            } else if (expression.index == -10) {
                dataBase.def = association2;
                bl2 = this.executeColon(association);
                if (bl2 && (bl2 = this.deriveCValue())) {
                    bl2 = this.deriveCName();
                }
                dataBase.def = null;
                if (!bl2) {
                    return false;
                }
                if (association2.has()) {
                    this.ass = this.ass.get(association2, 57, 64, 64, -1, 0);
                }
            } else {
                if (!this.executeColon(association)) {
                    return false;
                }
                bl2 = expression.execute(association);
                if (bl2) {
                    bl2 = expression.deriveCValue();
                }
                Association association4 = expression.ass;
                expression.ass = null;
                this.ass = bl2 ? this.ass.getValue(association4) : null;
            }
            return this.yields1();
        }
        if (expression.index == -10 && expression3.index == -10) {
            this.list.remove();
            dataBase.def = association2;
            bl2 = this.executeColon(association);
            if (bl2 && (bl2 = this.deriveCValue())) {
                bl2 = this.deriveCName();
            }
            dataBase.def = null;
            if (!bl2) {
                this.list.add(this.copula.look, (Object)expression3);
                return false;
            }
            if (association2.has()) {
                this.ass = this.ass.get(association2, 57, 64, 64, -1, 0);
            }
            if (!this.ass.has()) {
                this.yields1();
                this.list.add(this.copula.look, (Object)expression3);
                return false;
            }
            this.list.add(this.copula.look, (Object)expression3);
            this.ass = dataBase.selectCValue(this.ass);
            return this.yields1();
        }
        bl2 = expression.execute(association);
        if (bl2) {
            bl2 = expression.deriveCValue();
        }
        if (!bl2) {
            return false;
        }
        Association association5 = expression.ass;
        association5.setSense(57);
        expression.ass = null;
        dataBase.def = association2;
        bl2 = expression3.execute(association5);
        if (bl2) {
            bl2 = expression3.deriveCValue();
        }
        dataBase.def = null;
        if (!bl2) {
            return false;
        }
        if (association2.has()) {
            this.ass = expression3.ass.get(association2, 57, 64, 64, -1, 0);
        }
        expression3.ass = null;
        if (!this.ass.has()) {
            this.list.getFirst();
            this.list.remove();
            this.yields1();
            this.list.getFirst();
            this.list.insert(expression);
            return false;
        }
        this.ass = this.ass.getValue(association5);
        return this.yields1();
    }

    boolean executeLeftSlash(Association association) throws IOException {
        char c2 = '\u0000';
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            c2 = (char)this.list.getType();
            if (!this.list.hasNext()) break;
            expression2 = (Expression)this.list.getNext();
        }
        if (!expression2.execute(association)) {
            return false;
        }
        this.ass = expression2.ass;
        expression2.ass = null;
        if (expression.index == -10) {
            if (c2 == '\\') {
                this.ass.setResolution(-1);
            } else if (c2 == '|') {
                this.ass.setResolution(1);
            }
        } else if (c2 == '\\') {
            this.ass = this.ass.getName();
        } else if (c2 == '|') {
            if (!this.deriveCValue(true)) {
                return false;
            }
            this.ass = this.ass.getMean();
        }
        return this.yields1();
    }

    boolean executeRightSlash(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association) || !expression.deriveCValue()) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            char c2 = (char)this.list.getType();
            if (c2 == '|') {
                this.ass = this.ass.getValues();
            } else if (c2 == '\\') {
                this.ass = this.ass.getNames();
            }
            if (!this.ass.has()) break;
            if (expression2.index != -10) {
                if (expression2.index == 1) {
                    this.ass = this.ass.get(56);
                } else {
                    if (c2 == '|') {
                        expression2.designated = true;
                        if (!expression2.execute(null)) {
                            this.ass = null;
                            return false;
                        }
                        expression2.ass = expression2.ass.getValues();
                        this.ass = this.ass.get(expression2.ass);
                    } else if (c2 == '\\') {
                        if (!expression2.execute(association)) {
                            this.ass = null;
                            break;
                        }
                        this.ass = this.ass.get(expression2.ass);
                    }
                    expression2.ass = null;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
        return this.yields1();
    }

    boolean executeExtraction(Association association) throws IOException {
        Expression expression = (Expression)this.list.getLast();
        if (expression.index == -1) {
            if (this.copula.look == '~') {
                this.stm.ss.closeBase(this.stm.sNewBase);
            } else {
                this.stm.ss.openUse(this.stm.sNewBase);
            }
            return false;
        }
        if (!expression.execute(association)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        return true;
    }

    boolean executeDeclaration(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (expression.index == -1) {
            if (this.copula.look == '~') {
                this.stm.ss.openNew(this.stm.sNewBase);
            } else {
                this.stm.ss.openModify(this.stm.sNewBase);
            }
            return false;
        }
        if (association == null && expression.index == -3) {
            if (this.copula.look == '~') {
                expression.ass = this.mul(expression.cnc.toString());
                expression.ass.clear();
            }
            return this.yields();
        }
        if (!expression.execute(association)) {
            return false;
        }
        if (this.copula.look == '~') {
            this.stm.ss.db.deleteClass(expression.ass);
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        return true;
    }

    boolean executeSubtruction(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (association == null && expression.index == -3) {
            expression.ass = this.mul(expression.cnc.toString());
        } else if (!expression.execute(association)) {
            return false;
        }
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3 != null && expression3.index == -10 && expression2.index == 12) {
                expression.subtructionOfRelation(expression2);
            } else if (expression3 != null && expression3.index == -10 && expression2.index == 14) {
                expression.subtructionOfClass(expression2);
            } else if (association == null && expression.index == -3) {
                expression.subtructionFromMultitude(expression2);
            } else {
                expression.subtructionFromConception(association, expression2);
            }
            expression2.ass = null;
            if (!expression.ass.has()) break;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        this.ass = association == null && expression.index == -3 ? expression.ass.get() : expression.ass;
        expression.ass = null;
        if (this.feature != 128) {
            return this.yields1();
        }
        return this.ass.has();
    }

    boolean executeAssignement(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (association == null && expression.index == -3) {
            expression.ass = this.mul(expression.cnc.toString());
        } else if (!expression.execute(association)) {
            return false;
        }
        Long1 long1 = Memory.init();
        this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3 != null && expression3.index == -10 && expression2.index == 12) {
                expression.assignementOfRelation(expression2);
            } else if (expression3 != null && expression3.index == -10 && expression2.index == 14) {
                expression.assignementOfClass(expression2);
            } else if (association == null && expression.index == -3) {
                expression.assignementToMultitude(expression2);
            } else {
                expression.assignementToConception(association, expression2);
            }
            expression2.ass = null;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        this.ass = association == null && expression.index == -3 ? expression.ass.get() : expression.ass;
        expression.ass = null;
        if (this.feature != 128) {
            return this.yields1();
        }
        return this.ass.has();
    }

    void subtructionOfRelation(Expression expression) throws IOException {
        PList pList = expression.list;
        pList.getFirst();
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        expression = (Expression)pList.getNext();
        while (expression != null) {
            PList pList4 = expression.list;
            expression = (Expression)pList4.getFirst();
            while (expression != null) {
                if (expression.index == -10) {
                    this.stm.ss.db.deleteRelation(this.ass);
                    return;
                }
                if (expression.execute(null)) {
                    pList2.add(59, (Object)expression.ass);
                    expression.ass = null;
                    pList3.add(expression);
                    Memory.control(long1, this.ass, pList2);
                }
                expression = (Expression)pList4.getNext();
            }
            expression = (Expression)pList.getNext();
        }
        pList2 = this.stm.ss.db.selectPropertySchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            this.warnFail(" ~ ", pList3, "Non-existent schema");
        }
        if (pList2 != null) {
            this.stm.ss.db.deleteRelation(this.ass, pList2);
        }
    }

    void assignementOfRelation(Expression expression) throws IOException {
        PList pList = expression.list;
        pList.getFirst();
        PList pList2 = new PList();
        PList pList3 = new PList();
        Long1 long1 = Memory.init();
        expression = (Expression)pList.getNext();
        while (expression != null) {
            PList pList4 = expression.list;
            expression = (Expression)pList4.getFirst();
            while (expression != null) {
                if (expression.index == -10) {
                    pList2.add(59, null);
                    pList3.add(expression);
                    break;
                }
                if (expression.execute(null)) {
                    pList2.add(59, (Object)expression.ass);
                    expression.ass = null;
                    pList3.add(expression);
                    Memory.control(long1, this.ass, pList2);
                }
                expression = (Expression)pList4.getNext();
            }
            expression = (Expression)pList.getNext();
        }
        pList2 = this.stm.ss.db.insertSchema(this.ass, pList2, pList3);
        if (!pList3.isEmpty()) {
            this.warnFail(" = ", pList3, "Non-describable schema");
        }
        if (pList2 != null) {
            this.stm.ss.db.insertRelation(this.ass, pList2);
        }
    }

    void subtructionOfClass(Expression expression) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)expression.list.getFirst();
        expression.list.remove();
        if (expression.execute(null) && expression.deriveCValue(true)) {
            int n2 = this.ass.getSense();
            this.ass.setSense(57);
            this.stm.ss.db.deleteClass(this.ass, expression.ass);
            this.ass.setSense(n2);
            expression.ass = null;
        }
        expression.list.getFirst();
        expression.list.insert(expression2);
    }

    void assignementOfClass(Expression expression) throws IOException {
        Long1 long1 = Memory.init();
        Expression expression2 = (Expression)expression.list.getFirst();
        expression.list.remove();
        if (expression.execute(null) && expression.deriveCValue(true)) {
            int n2 = this.ass.getSense();
            this.ass.setSense(57);
            this.stm.ss.db.insertClass(this.ass, expression.ass);
            this.ass.setSense(n2);
            expression.ass = null;
        }
        expression.list.getFirst();
        expression.list.insert(expression2);
    }

    void subtructionFromMultitude(Expression expression) throws IOException {
        if (expression.execute(null) && expression.deriveCValue(true)) {
            this.ass.clear(expression.ass);
        }
    }

    void assignementToMultitude(Expression expression) throws IOException {
        if (expression.execute(null) && expression.deriveCValue(true)) {
            this.ass.set(expression.ass);
        }
    }

    void subtructionFromConception(Association association, Expression expression) throws IOException {
        if (!expression.execute(association)) {
            return;
        }
        PList pList = this.stm.ss.db.selectSchema(this.ass, expression.ass);
        if (pList == null) {
            this.warnFail('~', expression, "Unknown schema");
        } else {
            this.stm.ss.db.deleteIdentity(this.ass, expression.ass);
        }
    }

    void assignementToConception(Association association, Expression expression) throws IOException {
        if (!expression.execute(association)) {
            return;
        }
        PList pList = this.stm.ss.db.insertSchema(this.ass, expression.ass);
        if (pList == null) {
            this.warnFail('=', expression, "Conflicting schema");
        } else if (!pList.isEmpty()) {
            this.stm.ss.db.insertContentByIdentity(this.ass, expression.ass);
            this.stm.ss.db.insertIdentity(this.ass, expression.ass);
        }
    }

    boolean executeInEquality(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association) || !expression.deriveCValue(true)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Long1 long1 = Memory.init();
        expression = (Expression)this.list.getNext();
        while (expression != null) {
            if (expression.execute(association)) {
                this.ass.clear(expression.ass);
                expression.ass = null;
                if (!this.yields1()) {
                    return false;
                }
                this.controlMemory(long1);
            }
            expression = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean executeEquality(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Long1 long1 = Memory.init();
        expression = (Expression)this.list.getNext();
        while (expression != null) {
            if (!expression.execute(association)) {
                this.ass = null;
                return false;
            }
            Association association2 = expression.ass.get(this.ass);
            int n2 = this.ass.getSense();
            int n3 = expression.ass.getSense();
            if (n2 != 64 && n3 != 64) {
                if (n2 != 121 && n3 != 121) {
                    association2.setSense(57);
                } else {
                    association2.setSense(121);
                }
            }
            this.ass = association2;
            expression.ass = null;
            if (!this.yields1()) {
                return false;
            }
            this.controlMemory(long1);
            expression = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean executeComma(Association association) throws IOException {
        return this.executeBrace(association);
    }

    void warnErr0(String string) {
        new Error(this.stm, this.begin, string);
    }

    void warnErr1(String string) {
        new Error(this.stm, this.end, string);
    }

    void warnErr(String string, int n2) {
        new Error(this.stm, n2, string);
    }

    void warnFail0(String string) {
        new Failure(this.stm, this.begin, string);
    }

    void warnFail1(String string) {
        new Failure(this.stm, this.end, string);
    }

    void warnFail(String string, int n2) {
        new Failure(this.stm, n2, string);
    }

    void warnFail(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(char c2, Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(" ").append(c2).append(" "))));
        expression.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(String string, PList pList, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("(");
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            expression.toStringBuffer(stringBuffer, false);
            if (pList.hasNext()) {
                stringBuffer.append(", ");
            }
            expression = (Expression)pList.getNext();
        }
        stringBuffer.append(") ");
        if (string2.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string2);
        }
        new Failure(this.stm, this.begin, stringBuffer.toString());
    }

    void contextToStringBuffer(StringBuffer stringBuffer) {
        PList pList = new PList();
        while (this.eContext != null) {
            pList.insert(this.eContext);
            this.eContext = this.eContext.eContext;
        }
        boolean bl2 = true;
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            block6: {
                block5: {
                    block4: {
                        if (!bl2) break block4;
                        bl2 = false;
                        break block5;
                    }
                    if (expression.index == -10) break block6;
                }
                expression.toStringBuffer(stringBuffer);
                stringBuffer.append(":");
            }
            expression = (Expression)pList.getNext();
        }
    }

    boolean yields() throws IOException {
        if (this.ass != null && this.ass.has()) {
            return true;
        }
        this.ass = null;
        if (this.feature != 128) {
            this.warnFail("");
        }
        return false;
    }

    boolean yields1() throws IOException {
        if (this.ass != null && this.ass.has()) {
            return true;
        }
        this.ass = null;
        if (this.feature != 128) {
            this.warnFail(this.eContext, "");
        }
        return false;
    }

    void controlMemory(Long1 long1) throws IOException {
        Memory.control(long1, this.stm.ss.db.base, this.ass);
    }

    void controlMemory(Long1 long1, Association association) throws IOException {
        Memory.control(long1, this.stm.ss.db.base, this.ass, association);
    }

    void controlMemory(Long1 long1, PList pList) throws IOException {
        if (!Memory.filled(long1)) {
            return;
        }
        this.stm.ss.db.store();
        if (this.ass != null) {
            this.ass.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        Memory.optimize(long1);
    }

    void controlMemory(Long1 long1, Association association, PList pList) throws IOException {
        if (!Memory.filled(long1)) {
            return;
        }
        this.stm.ss.db.store();
        if (this.ass != null) {
            this.ass.store();
        }
        if (association != null) {
            association.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        Memory.optimize(long1);
    }

    void controlMemory(Long1 long1, Association association, Association association2, PList pList) throws IOException {
        if (!Memory.filled(long1)) {
            return;
        }
        this.stm.ss.db.store();
        if (this.ass != null) {
            this.ass.store();
        }
        if (association != null) {
            association.store();
        }
        if (association2 != null) {
            association2.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        Memory.optimize(long1);
    }

    void freeInnerExpression() {
        this.ass = null;
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            expression.freeInnerExpression();
            expression = (Expression)this.list.getNext();
        }
    }

    void toStringBuffer(StringBuffer stringBuffer) {
        this.toStringBuffer(stringBuffer, true);
    }

    void toStringBuffer(StringBuffer stringBuffer, boolean bl2) {
        String string;
        if (bl2) {
            bl2 = false;
        }
        if (this.index == -10) {
            return;
        }
        if (this.list.isEmpty()) {
            if (this.index <= 0) {
                stringBuffer.append('$');
                if (this.type != null) {
                    stringBuffer.append(this.type).append(" ");
                }
                if (this.text.charAt(this.end - 1) == '\"' || this.text.charAt(this.end - 1) == '\'') {
                    stringBuffer.append('\'');
                    if (this.cnc != null) {
                        stringBuffer.append(this.cnc.toString());
                    }
                    stringBuffer.append('\'');
                } else if (this.cnc != null) {
                    stringBuffer.append(this.cnc.toString());
                }
                return;
            }
            stringBuffer.append(this.text.substring(this.begin, this.end));
            return;
        }
        if (this.index == -4) {
            stringBuffer.append('$');
            if (this.type != null) {
                stringBuffer.append(this.type).append(" ");
            }
            stringBuffer.append(this.cnc.toString());
            stringBuffer.append(this.copula.look);
            string = ", ";
        } else if (this.index == 7 || this.index == 8 || this.index == 9) {
            stringBuffer.append(this.copula.look);
            string = ", ";
        } else if (this.index == 22) {
            string = ", ";
            string = ", ";
        } else {
            string = null;
        }
        Expression expression = (Expression)this.list.getFirst();
        if (expression != null) {
            expression.toStringBuffer(stringBuffer, bl2);
        }
        while (this.list.hasNext()) {
            expression = (Expression)this.list.getNext();
            char c2 = (char)this.list.getType();
            if (string != null) {
                stringBuffer.append(string);
            } else if (this.index == 6) {
                if (expression.index != 1) {
                    stringBuffer.append(" ");
                }
            } else if (this.index == 12) {
                stringBuffer.append(" ");
            } else if ((this.index == 20 || this.index == 19) && (this.feature & 0x80) != 0) {
                stringBuffer.append(" ").append(c2).append(" ");
            } else {
                stringBuffer.append(c2);
            }
            expression.toStringBuffer(stringBuffer, bl2);
        }
        if (this.copula.look == '{') {
            stringBuffer.append("}");
        } else if (this.copula.look == '[') {
            stringBuffer.append(']');
        } else if (this.copula.look == '(') {
            stringBuffer.append(')');
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer, true);
        return stringBuffer.toString();
    }

    String string() {
        return this.text.substring(this.begin, this.end);
    }

    int position(String string) {
        return this.text.indexOf(string, this.begin);
    }
}

