/*
 * Decompiled with CFR 0.152.
 */
import dialog.DCSize;
import dialog.DCanvas;
import dialog.DColor;
import dialog.DFColor;
import dialog.DFSize;
import dialog.DGradient;
import dialog.DText;
import dialog.DThreed;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import painter.FontShape;
import painter.NightSky;
import painter.PText;
import painter.PThreeD;
import setter.SGradient;
import setter.SImage;
import setter.STexture;
import tools.FontFile;

public class Editor
extends JPanel
implements Cloneable {
    JFont JF;
    private int w = 0;
    private int h = 0;
    private int[] dim = new int[]{this.w, this.h};
    private String BGType = "Color";
    private String BGGradient = "";
    private Color BGColor = Color.white;
    private String rtype = "Fill";
    private String[] request = new String[]{"Init", "", ""};
    private float sx;
    private float sy;
    private Paint paint = Color.white;
    private Color[] c = new Color[]{Color.white, Color.white};
    private Rectangle[] diar = new Rectangle[]{null, null, null, null};
    private Paint[] diap = new Paint[]{Color.blue, Color.red, Color.blue, Color.red};
    private String str = "";
    private String fname = "Arial";
    private int fsize = 8;
    private int fstyle = 0;
    private Color fc = Color.black;
    private Shape shape;
    private Image img;
    private String sizetype = "Justification";
    private int[] farg = new int[]{this.fsize, this.fstyle};
    private Object[] fargs = new Object[]{this.dim, this.str, this.fname, this.sizetype, this.farg};
    private Color fill_c = Color.black;
    private Color draw_c = Color.black;
    private Color color_A;
    private Color color_B;
    private Stroke stroke = new BasicStroke(2.5f);
    private int xdescent = -10;
    private int ydescent = 10;
    private int alpha = 200;
    private Color CrossSide = new Color(255, 255, 255, this.alpha);
    private Color[] tdc = new Color[]{Color.blue, Color.cyan};
    private int[] descents = new int[]{this.xdescent, this.ydescent, this.alpha};
    private Object[] TDargs = new Object[]{this.dim, this.str, this.fname, this.sizetype, this.farg, this.tdc, this.descents};

    public Editor() {
        this.JF = this.JF;
        this.setBorder(new SoftBevelBorder(1));
        DCSize dCSize = new DCSize();
        int[] nArray = dCSize.getSizeArg();
        this.w = this.dim[0] = nArray[0];
        this.h = this.dim[1] = nArray[1];
        Dimension dimension = new Dimension(this.w, this.h);
        this.setSize(dimension);
        this.setVisible(true);
    }

    public Editor(String string) {
        this.JF = this.JF;
        this.setBorder(new SoftBevelBorder(1));
        new FontFile().isAvailableFontFile();
        DCSize dCSize = new DCSize("Warning");
        int[] nArray = dCSize.getSizeArg("Warning");
        this.w = nArray[0];
        this.h = nArray[1];
        Dimension dimension = new Dimension(this.w, this.h);
        this.setSize(dimension);
        this.setVisible(true);
    }

    private void BGPaint(Graphics2D graphics2D) {
        if (this.BGType.equals("Color")) {
            graphics2D.setColor(this.BGColor);
            graphics2D.fillRect(0, 0, this.w, this.h);
        } else if (this.BGType.equals("Texture")) {
            graphics2D.setPaint(this.paint);
            graphics2D.fill(new Rectangle(this.w, this.h));
        } else if (this.BGType.equals("Image")) {
            graphics2D.drawImage(this.img, 0, 0, this.w, this.h, this);
        } else if (this.BGType.equals("Gradient")) {
            if (this.BGGradient.equals("Diamond_Gradient")) {
                Object[] objectArray = (Object[])new SGradient(this).DiamondGradient(this.c);
                Rectangle[] rectangleArray = (Rectangle[])objectArray[0];
                Paint[] paintArray = (Paint[])objectArray[1];
                int n = 0;
                while (n < 4) {
                    this.diar[n] = rectangleArray[n];
                    this.diap[n] = paintArray[n];
                    graphics2D.setPaint(this.diap[n]);
                    graphics2D.fill(this.diar[n]);
                    ++n;
                }
            } else {
                this.paint = new SGradient(this).setGradient(this.BGGradient, this.c);
                graphics2D.setPaint(this.paint);
                graphics2D.fill(new Rectangle(this.w, this.h));
            }
        } else if (this.BGType.equals("NightSky")) {
            new NightSky(graphics2D, this.w, this.h);
        }
    }

    public void EditText() {
        DText dText = new DText();
        String[] stringArray = dText.getTextArgs(this.str);
        if (stringArray.length == 0) {
            return;
        }
        this.str = stringArray[0];
        this.fargs[1] = this.str;
        this.fname = stringArray[1];
        this.fargs[2] = this.fname;
        JFont.frame.repaint();
        this.rtype = dText.getRenderingType();
        this.farg[0] = this.fsize = new DFSize().getJustifySize(this, this.str);
        if (this.rtype.equals("Gradient") || this.rtype.equals("3DStyle")) {
            this.setRendering();
        }
        this.request[2] = "Edit";
        JFont.frame.repaint();
    }

    public void RenderChange() {
        DText dText = new DText();
        this.rtype = dText.getRenderingType();
        this.setRendering();
        this.request[2] = "Edit";
    }

    private void TextPaint(Graphics2D graphics2D) {
        this.shape = new FontShape(this.fargs).getShape(graphics2D);
        graphics2D = this.getG2Translate(graphics2D, this.shape);
        if (this.rtype.equals("Fill")) {
            PText pText = new PText(this, this.w, this.h);
            pText.fillFontShape(graphics2D, this.shape, this.fill_c);
        } else if (this.rtype.equals("Draw")) {
            PText pText = new PText(this, this.w, this.h);
            pText.drawFontShape(graphics2D, this.shape, this.draw_c);
        } else if (this.rtype.equals("FillAndDraw")) {
            PText pText = new PText(this, this.w, this.h);
            pText.fillAndDraw(graphics2D, this.shape, this.fill_c, this.draw_c, this.stroke);
        } else if (this.rtype.equals("Texture")) {
            PText pText = new PText(this, this.w, this.h);
            pText.fillTextureShape(graphics2D, this.shape, this.paint, this.stroke, this.draw_c);
        } else if (this.rtype.equals("Image")) {
            PText pText = new PText(this, this.w, this.h);
            pText.fillFontWithImage(graphics2D, this.shape, this.img, this.draw_c);
        } else if (this.rtype.equals("Gradient")) {
            PText pText = new PText(this, this.w, this.h);
            pText.gradientPaint(graphics2D, this.shape, this.color_A, this.color_B);
        } else if (this.rtype.equals("3DStyle")) {
            PThreeD pThreeD = new PThreeD(this.TDargs);
            pThreeD.ThreeDPaint(graphics2D, this.shape);
        }
    }

    private Graphics2D g2init(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clearRect(0, 0, this.w, this.h);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return graphics2D;
    }

    public void getFontColor() {
        this.setRendering();
        this.request[2] = "Edit";
    }

    public void getFontSize() {
        DFSize dFSize = new DFSize();
        this.sizetype = dFSize.getSizeType();
        if (this.sizetype.equals("Option")) {
            this.fsize = this.farg[0] = dFSize.getFontSize(this.fsize);
        } else if (this.sizetype.equals("Justification")) {
            this.fsize = this.farg[0] = dFSize.getJustifySize(this, this.str);
        } else if (this.sizetype.equals("Maximum")) {
            this.fsize = this.farg[0] = dFSize.getMaximumSize(this, this.str, this.fname, this.fstyle, this.fsize);
        }
        this.request[2] = "Edit";
    }

    public void getFontStyle() {
        DText dText = new DText();
        this.fstyle = this.farg[1] = dText.getFontStyle();
        this.fargs[4] = this.farg;
        this.request[2] = "FontStyle";
    }

    private Graphics2D getG2Translate(Graphics2D graphics2D, Shape shape) {
        graphics2D.translate(0, 0);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        Rectangle rectangle = shape.getBounds();
        graphics2D.translate((double)this.w * 0.5 - (double)rectangle.width * 0.5, (double)this.h * 0.5 + (double)rectangle.height * 0.5);
        return graphics2D;
    }

    public void paint(Graphics graphics) {
        this.resetArgs();
        Graphics2D graphics2D = this.g2init(graphics);
        if (this.request[0].equals("Init")) {
            graphics.setColor(this.BGColor);
            graphics.fillRect(0, 0, this.w, this.h);
        }
        if (this.request[1].equals("Background")) {
            this.BGPaint(graphics2D);
        }
        if (this.request[2].equals("Edit")) {
            this.BGPaint(graphics2D);
            this.TextPaint(graphics2D);
        } else if (this.request[2].equals("FontStyle")) {
            this.BGPaint(graphics2D);
            Font font = new Font(this.fname, 0, 0);
            graphics.setFont(font);
            graphics.drawString("", this.w, this.h);
            this.TextPaint(graphics2D);
        }
    }

    private void resetArgs() {
        Dimension dimension = this.getSize();
        this.dim[0] = this.w = dimension.width;
        this.dim[1] = this.h = dimension.height;
        this.fargs[0] = this.dim;
        this.farg[0] = this.fsize;
        this.farg[1] = this.fstyle;
        this.fargs[4] = this.farg;
    }

    public void setBackground() {
        DCanvas dCanvas = new DCanvas();
        this.BGType = dCanvas.getBGArg();
        if (this.BGType.equals("Color")) {
            this.BGColor = new DColor().getColor();
            this.setBackground(this.BGColor);
        } else if (this.BGType.equals("Texture")) {
            this.paint = new STexture(this).setTexture();
            if (this.paint == null) {
                return;
            }
        } else if (this.BGType.equals("Image")) {
            this.img = new SImage(this).setImage();
            if (this.img == null) {
                return;
            }
        } else if (this.BGType.equals("Gradient")) {
            DGradient dGradient = new DGradient();
            this.BGGradient = dGradient.getGradientTypeArg();
            this.c = dGradient.getColor();
        } else {
            this.BGType.equals("3DStyle");
        }
        this.request[1] = "Background";
    }

    public void setRendering() {
        if (this.rtype.equals("Fill")) {
            DColor dColor = new DColor();
            this.fill_c = dColor.getColor();
        } else if (this.rtype.equals("Draw")) {
            DColor dColor = new DColor();
            this.draw_c = dColor.getColor();
        } else if (this.rtype.equals("FillAndDraw")) {
            DFColor dFColor = new DFColor();
            Color[] colorArray = dFColor.getColor();
            this.fill_c = colorArray[0];
            this.draw_c = colorArray[1];
        } else if (this.rtype.equals("Texture")) {
            this.paint = new STexture(this).setTexture();
        } else if (this.rtype.equals("Image")) {
            this.img = new SImage(this).setImage();
        } else if (this.rtype.equals("Gradient")) {
            DGradient dGradient = new DGradient();
            Color[] colorArray = dGradient.getColor();
            this.color_A = colorArray[0];
            this.color_B = colorArray[1];
        } else if (this.rtype.equals("3DStyle")) {
            DThreed dThreed = new DThreed();
            this.tdc = dThreed.getColor();
            this.TDargs[5] = this.tdc;
            this.descents = dThreed.getDescents();
            this.TDargs[6] = this.descents;
        }
        JFont.frame.repaint();
    }
}

