/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.persistence.file.CollectionData;
import org.nakedobjects.persistence.file.Data;
import org.nakedobjects.persistence.file.DataManager;
import org.nakedobjects.persistence.file.FileOid;
import org.nakedobjects.persistence.file.ObjectData;
import org.nakedobjects.persistence.file.Reference;
import org.nakedobjects.persistence.file.ReferenceVector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlDataManager
extends DataManager {
    private File directory;

    public XmlDataManager() {
        this("data");
    }

    protected static void clearTestDirectory() {
        File file = new File("tmp/tests");
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        });
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                new File(file, stringArray[n]).delete();
                ++n;
            }
        }
    }

    public XmlDataManager(String string) {
        this.directory = new File(string);
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
    }

    protected long nextId() throws ObjectStoreException {
        NumberHandler numberHandler = new NumberHandler();
        this.parse(numberHandler, "oid");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<number>");
        stringBuffer.append(numberHandler.value + 1L);
        stringBuffer.append("</number>");
        this.writeXml("oid", stringBuffer);
        return numberHandler.value + 1L;
    }

    protected void writeDataFile(long l, Data data) throws ObjectStoreException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = data instanceof ObjectData;
        String string = bl ? "naked-object" : "collection";
        stringBuffer.append("<" + string);
        stringBuffer.append(this.attribute("type", data.getClassName()));
        stringBuffer.append(this.attribute("id", "" + data.getOid().getSerialNo()));
        stringBuffer.append(">\n");
        if (bl) {
            ObjectData objectData = (ObjectData)data;
            Enumeration enumeration = objectData.fields();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string2 = (String)enumeration.nextElement();
                Object object2 = objectData.get(string2);
                if (object2 instanceof Reference) {
                    object = (Reference)object2;
                    stringBuffer.append("  <association field=\"" + string2 + "\" ");
                    stringBuffer.append("type=\"" + ((Reference)object).getType() + "\" ");
                    stringBuffer.append("ref=\"" + ((Reference)object).getOid().getSerialNo() + "\"/>\n");
                    continue;
                }
                if (object2 instanceof String) {
                    stringBuffer.append("  <value field=\"" + string2 + "\" ");
                    stringBuffer.append("value=\"" + object2 + "\"/>\n");
                    continue;
                }
                object = (ReferenceVector)object2;
                stringBuffer.append("  <multiple-association field=\"" + string2 + "\">\n");
                int n = 0;
                while (n < ((ReferenceVector)object).size()) {
                    Reference reference = ((ReferenceVector)object).elementAt(n);
                    stringBuffer.append("    <element type=\"" + reference.getType() + "\" ");
                    stringBuffer.append("ref=\"" + reference.getOid().getSerialNo() + "\"/>\n");
                    ++n;
                }
                stringBuffer.append("  </multiple-association>\n");
            }
        } else {
            CollectionData collectionData = (CollectionData)data;
            Enumeration enumeration = collectionData.references().elements();
            while (enumeration.hasMoreElements()) {
                Reference reference = (Reference)enumeration.nextElement();
                stringBuffer.append("  <element type=\"" + reference.getType() + "\" ");
                stringBuffer.append("ref=\"" + reference.getOid().getSerialNo() + "\"/>\n");
            }
        }
        stringBuffer.append("</" + string + ">\n");
        this.writeXml("d" + l, stringBuffer);
    }

    protected void deleteFile(long l) {
        this.file("d" + l).delete();
    }

    private File file(String string) {
        return new File(this.directory, string + ".xml");
    }

    private boolean parse(ContentHandler contentHandler, String string) throws ObjectStoreException {
        XMLReader xMLReader;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException sAXException2) {
                throw new ObjectStoreException("Couldn't locate a SAX parser");
            }
        }
        try {
            xMLReader.setContentHandler(contentHandler);
            xMLReader.parse(new InputSource(new FileInputStream(this.file(string))));
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw new ObjectStoreException("Error reading XML file", iOException);
        }
        catch (SAXParseException sAXParseException) {
            throw new ObjectStoreException("Parse error: " + sAXParseException.getMessage() + " (" + this.file(string) + ")");
        }
        catch (SAXException sAXException) {
            throw new ObjectStoreException("?? Error parsing XML file " + this.file(string) + " " + sAXException.getClass(), sAXException.getException());
        }
    }

    protected Data readDataFile(long l) throws ObjectNotFoundException, ObjectStoreException {
        DataHandler dataHandler = new DataHandler();
        this.parse(dataHandler, "d" + l);
        if (dataHandler.object != null) {
            return dataHandler.object;
        }
        return dataHandler.collection;
    }

    protected long readSerialNumberFile(String string) throws ObjectStoreException {
        NumberHandler numberHandler = new NumberHandler();
        this.parse(numberHandler, string);
        return numberHandler.value;
    }

    protected void writeSerialNumberFile(String string, long l) throws ObjectStoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<number>");
        stringBuffer.append(l);
        stringBuffer.append("</number>");
        this.writeXml(string, stringBuffer);
    }

    protected Vector readInstanceFile(String string) throws ObjectStoreException {
        InstanceHandler instanceHandler = new InstanceHandler();
        this.parse(instanceHandler, string);
        return instanceHandler.instances;
    }

    protected void writeInstanceFile(String string, Vector vector) throws ObjectStoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<instances>\n");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append("  <instance id=\"" + ((FileOid)vector.elementAt(n)).getSerialNo() + "\"/>\n");
            ++n;
        }
        stringBuffer.append("</instances>");
        this.writeXml(string, stringBuffer);
    }

    private String attribute(String string, String string2) {
        return " " + string + "=\"" + string2 + "\"";
    }

    private void writeXml(String string, StringBuffer stringBuffer) throws ObjectStoreException {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.file(string)));
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println();
            printWriter.println(stringBuffer.toString());
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ObjectStoreException("Problems writing data files", fileNotFoundException);
        }
    }

    private class InstanceHandler
    extends DefaultHandler {
        Vector instances = new Vector();

        private InstanceHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("instance")) {
                long l = Long.valueOf(attributes.getValue("id"));
                this.instances.addElement(new FileOid(l));
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    private class DataHandler
    extends DefaultHandler {
        ObjectData object;
        CollectionData collection;
        String internalCollection;

        private DataHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.object != null) {
                if (string3.equals("value")) {
                    String string4 = attributes.getValue("field");
                    String string5 = attributes.getValue("value");
                    this.object.set(string4, string5);
                } else if (string3.equals("association")) {
                    String string6 = attributes.getValue("field");
                    String string7 = attributes.getValue("type");
                    long l = Long.valueOf(attributes.getValue("ref"));
                    this.object.set(string6, string7, l);
                } else if (string3.equals("element")) {
                    String string8 = attributes.getValue("type");
                    long l = Long.valueOf(attributes.getValue("ref"));
                    this.object.addElement(this.internalCollection, string8, l);
                } else if (string3.equals("multiple-association")) {
                    this.internalCollection = attributes.getValue("field");
                }
            } else if (this.collection != null) {
                if (string3.equals("element")) {
                    String string9 = attributes.getValue("type");
                    long l = Long.valueOf(attributes.getValue("ref"));
                    this.collection.addElement(string9, l);
                }
            } else if (string3.equals("naked-object")) {
                String string10 = attributes.getValue("type");
                long l = Long.valueOf(attributes.getValue("id"));
                this.object = new ObjectData(NakedClass.getNakedClass(string10), new FileOid(l));
            } else if (string3.equals("collection")) {
                String string11 = attributes.getValue("type");
                long l = Long.valueOf(attributes.getValue("id"));
                this.collection = new CollectionData(NakedClass.getNakedClass(string11), new FileOid(l));
            } else {
                throw new SAXException("Invalid data");
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    private class NumberHandler
    extends DefaultHandler {
        long value = 0L;
        boolean captureValue = false;

        private NumberHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.captureValue = string3.equals("number");
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.captureValue) {
                this.value = Long.valueOf(new String(cArray, n, n2));
            }
        }
    }
}

