/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ProxyObjectStore;
import org.nakedobjects.object.distribution.UpdateMessage;
import org.nakedobjects.object.distribution.UpdateMessageException;

class ObjectUpdateMessage
extends UpdateMessage {
    public ObjectUpdateMessage(NakedObject nakedObject) throws UpdateMessageException {
        super(nakedObject.getOid(), UpdateMessage.serializeObject(nakedObject));
    }

    public String toString() {
        return "ObjectUpdateMessage [" + this.getOid() + "]";
    }

    public void update(ProxyObjectStore proxyObjectStore) throws UpdateMessageException {
        Object object = this.getOid();
        if (proxyObjectStore.isObjectCached(object)) {
            try {
                NakedObject nakedObject = proxyObjectStore.getObject(object);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getSerializationData());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                nakedObject.readExternal(objectInputStream);
                objectInputStream.close();
                proxyObjectStore.broadcastObjectUpdate(nakedObject);
            }
            catch (ObjectStoreException objectStoreException) {
                throw new UpdateMessageException(objectStoreException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UpdateMessageException(classNotFoundException);
            }
            catch (IOException iOException) {
                throw new UpdateMessageException(iOException);
            }
        }
    }
}

