/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.control.About;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.reflect.Field;

public class AboutFieldRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;
    private String fieldName;

    public AboutFieldRequest(NakedObject nakedObject, Field field) {
        super(nakedObject);
        this.fieldName = field.getName();
    }

    public About about() throws ObjectStoreException {
        this.sendRequest();
        return (About)this.response;
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            Field field = nakedObject.getNakedClass().getField(this.fieldName);
            this.response = field == null ? null : field.getAbout(nakedObject);
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "About [" + this.fieldName + "]";
    }
}

