/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.basicgui.view.border.LineBorder;
import org.nakedobjects.object.NakedObject;

public class TitleBorder
extends ViewBorder {
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int LEFT = 16;
    public static final int CENTER = 32;
    public static final int RIGHT = 48;
    private int justification;
    private int position;
    private TextStyle style;
    private ViewBorder border;

    public TitleBorder() {
        this(2, 16, TextStyle.getStyle(2), new LineBorder(ViewColor.outlineNormal, 2));
    }

    public TitleBorder(int n, int n2, TextStyle textStyle, ViewBorder viewBorder) {
        this.justification = n2;
        this.position = n;
        this.style = textStyle;
        this.border = viewBorder;
    }

    public TitleBorder(TextStyle textStyle, ViewBorder viewBorder) {
        this(2, 16, textStyle, viewBorder);
    }

    public TitleBorder(ViewBorder viewBorder) {
        this(2, 16, TextStyle.getStyle(2), viewBorder);
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        Insets insets = this.insets(objectViewer.getObject());
        if (this.border == null) {
            return insets;
        }
        Insets insets2 = this.border.getBorderInsets(objectViewer);
        insets2.top += insets.top;
        insets2.bottom += insets.bottom;
        insets2.left += insets.left;
        insets2.right += insets.right;
        return insets2;
    }

    private Insets insets(NakedObject nakedObject) {
        String string = "";
        string = nakedObject.contextualTitle() == null ? "" : nakedObject.contextualTitle();
        Dimension dimension = new Dimension(this.style.getMetrics().stringWidth(string), this.style.getMetrics().getHeight());
        if (this.position >= 4) {
            return new Insets(0, 0, dimension.height + 4, 0);
        }
        return new Insets(dimension.height + 4, 0, 0, 0);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        int n;
        int n2;
        String string = objectViewer.getObject().contextualTitle();
        if (string == null) {
            string = "";
        }
        FontMetrics fontMetrics = this.style.getMetrics();
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        Color color2 = ((Component)((Object)objectViewer.getDisplay())).getBackground();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (this.border != null) {
            Insets insets = new Insets(0, 0, 0, 0);
            switch (this.position) {
                case 1: {
                    insets.top = this.style.getMetrics().getHeight();
                    break;
                }
                case 2: {
                    insets.top = this.style.getMetrics().getAscent() / 2;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    insets.bottom = this.style.getMetrics().getAscent() / 2 + this.style.getMetrics().getDescent();
                    break;
                }
                case 6: {
                    insets.bottom = this.style.getMetrics().getHeight();
                    break;
                }
                default: {
                    insets.bottom = n4 + this.style.getMetrics().getAscent();
                }
            }
            n2 = rectangle.x + insets.left;
            int n7 = rectangle.y + insets.top;
            int n8 = rectangle.width - insets.left - insets.right;
            int n9 = rectangle.height - insets.top - insets.bottom;
            Rectangle rectangle2 = new Rectangle(n2, n7, n8, n9);
            this.border.paint(graphics, rectangle2, objectViewer);
        }
        graphics.setFont(this.style.getFont());
        switch (this.justification) {
            default: {
                n = n3 + 5;
                break;
            }
            case 48: {
                n = n3 + n5 - this.style.getMetrics().stringWidth(string) - 5;
                break;
            }
            case 32: {
                n = n5 / 2 - this.style.getMetrics().stringWidth(string) / 2;
            }
        }
        switch (this.position) {
            case 2: {
                graphics.setColor(color2);
                n2 = n4 + this.style.getMetrics().getAscent() / 2;
                graphics.drawLine(n - 3, n2, this.style.getMetrics().stringWidth(string) + 6, n2);
            }
            case 1: 
            case 3: {
                graphics.setColor(color);
                graphics.drawString(string, n, n4 + this.style.getMetrics().getAscent());
                graphics.setColor(Color.green);
                graphics.drawString(objectViewer.getObject().getOid().toString(), n + this.style.getMetrics().stringWidth(string), n4);
                break;
            }
            case 5: {
                graphics.setColor(color2);
                n2 = n4 + n6 - this.style.getMetrics().getAscent() / 2 - this.style.getMetrics().getDescent() - 1;
                graphics.drawLine(n - 3, n2, this.style.getMetrics().stringWidth(string) + 6, n2);
            }
            case 4: 
            case 6: {
                graphics.setColor(color);
                graphics.drawString(string, n, n4 + n6 - this.style.getMetrics().getDescent() - 1);
                graphics.setColor(Color.green);
                graphics.drawString(objectViewer.getObject().getOid().toString(), n + this.style.getMetrics().stringWidth(string), n4);
            }
        }
    }

    public String toString() {
        return "TitleBorder [style=" + this.style + ",inner=" + this.border + "]";
    }
}

