// GrepView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CGrepView form view
#include "resource.h"

#include "GrepList.h"

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CGrepView : public CFormView
{
protected:
	CGrepView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CGrepView)

	BOOL m_bClosing;

	int _ParseSpecs_(CString strSpecs);

// Form Data
public:
	//{{AFX_DATA(CGrepView)
	enum { IDD = IDD_GREP };
	CButton	m_buttonStart;
	CSpinButtonCtrl	m_spinBefore;
	CSpinButtonCtrl	m_spinAfter;
	CEdit	m_editPattern;
	CEdit	m_editLinesBefore;
	CEdit	m_editLinesAfter;
	CComboBox	m_comboSpecs;
	CGrepList	m_lstctlGrepOutput;
	CListBox	m_listDirectories;
	CComboBox	m_comboGrep;
	CEdit	m_editAddDir;
	CString	m_strAddDir;
	CString	m_strGrep;
	CString	m_strSpecs;
	CString	m_strLinesAfter;
	CString	m_strLinesBefore;
	CString	m_strPattern;
	BOOL	m_bMatchWord;
	BOOL	m_bMatchLine;
	BOOL	m_bOutputByte;
	BOOL	m_bCountMatchesOnly;
	BOOL	m_bNamesOnly;
	BOOL	m_bMatchCase;
	BOOL	m_bNoMatchFiles;
	BOOL	m_bNonMatching;
	BOOL	m_bSuppressErrors;
	BOOL	m_bRecurseDirectories;
	//}}AFX_DATA

// Attributes
public:
BOOL					m_bGrepping, m_bStopGrep, m_bPrinting;
LOGFONT				m_lf;
int						m_nPrintPos;
CStringArray	m_strarrFileSpecs;


// Operations
public:
	void OnSelect(int nRow);

	// Printing support
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo);
	void OnPrint(CDC* pDC, CPrintInfo* pInfo);

	void PrintTop(CDC* pDC, CPrintInfo* pInfo);
	void PrintGrepPage(CDC* pDC, CPrintInfo* pInfo);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGrepView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CGrepView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CGrepView)
	afx_msg void OnGrep();
	afx_msg void OnGrepBrowsedDirs();
	afx_msg void OnGrepClearAll();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnKillFocusAddDir();
	afx_msg int OnVKeyToItem(UINT nKey, CListBox* pListBox, UINT nIndex);
	afx_msg void OnGrepDelDir();
	afx_msg void OnCancel();
	afx_msg void OnCloseGrep();
	afx_msg void OnGrepHelp();
	afx_msg void OnAppExit();
	afx_msg void OnAppAbout();
	afx_msg void OnDestroy();
	afx_msg void OnFilePrint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	void OnAddDir();
};

/////////////////////////////////////////////////////////////////////////////
