/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;

public class DirButton
extends DButtonBase
implements Serializable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    protected Color arrowColor = null;
    protected Color disabledArrowColor = null;
    protected int direction;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;

    public DirButton() {
        this(3);
    }

    public DirButton(int n) {
        this.direction = n;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.setArrowColor(Color.black);
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowColor(Color color) {
        this.arrowColor = color;
        this.disabledArrowColor = Color.lightGray;
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 5, dimension.height + 5);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 3, dimension.height + 3);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Graphics graphics = this.buttonImage.getGraphics();
        Dimension dimension = this.getSize();
        int n = this.bevel + 1;
        if (this.blackBorder) {
            ++n;
        }
        if (this.isEnabled()) {
            graphics.setColor(this.arrowColor);
        } else {
            graphics.setColor(this.disabledArrowColor);
        }
        int n2 = (dimension.width - 1) / 2 + this.pressedAdjustment;
        int n3 = (dimension.height - 1) / 2 + this.pressedAdjustment;
        switch (this.direction) {
            case 2: 
            case 3: {
                int n4 = dimension.width / 3;
                int n5 = dimension.width / 8;
                this.top = n4;
                this.bottom = n4;
                this.left = n5;
                this.right = n5;
                break;
            }
            case 0: 
            case 1: {
                int n6;
                int n7 = dimension.height / 3;
                this.top = n6 = dimension.height / 8;
                this.bottom = n6;
                this.left = n7;
                this.right = n7;
            }
        }
        int n8 = this.top + n - 1 + this.pressedAdjustment;
        int n9 = dimension.height - this.bottom - n + this.pressedAdjustment;
        int n10 = this.left + n - 1 + this.pressedAdjustment;
        int n11 = dimension.width - 1 - this.right - n + this.pressedAdjustment;
        if (OS.isMacintosh()) {
            ++n10;
            ++n8;
        }
        switch (this.direction) {
            case 2: {
                int n12 = n11 - n10;
                if (n12 == n12 / 2 * 2) {
                    --n11;
                }
                this.fillTriangle(graphics, n2, n8, n10, n9, n11, n9);
                break;
            }
            case 3: {
                int n13 = n11 - n10;
                if (n13 == n13 / 2 * 2) {
                    --n11;
                }
                this.fillTriangle(graphics, n2, n9, n10, n8, n11, n8);
                break;
            }
            case 0: {
                int n14 = n9 - n8;
                if (n14 == n14 / 2 * 2) {
                    --n9;
                }
                this.fillTriangle(graphics, n10, n3, n11, n9, n11, n8);
                break;
            }
            case 1: {
                int n15 = n9 - n8;
                if (n15 == n15 / 2 * 2) {
                    --n9;
                }
                this.fillTriangle(graphics, n11, n3, n10, n9, n10, n8);
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    protected void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[]{n, n3, n5, n};
        int[] nArray2 = new int[]{n2, n4, n6, n2};
        graphics.drawPolyline(nArray, nArray2, 4);
    }

    protected boolean isValidBevelSize(int n) {
        Dimension dimension = this.getSize();
        int n2 = n * 2 + 4;
        return n >= 0 && dimension.width >= n2 && dimension.height >= n2;
    }

    protected boolean isValidDirection(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }
}

