/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Archiver;
import common.DBPanel;
import common.DButton;
import common.DCheckbox;
import common.DialogCYN;
import common.DialogMessage;
import common.Directory;
import common.OS;
import common.Path;
import common.Preferences;
import java.awt.AWTEventMulticaster;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

public class ArchivePanel
extends Panel
implements ActionListener,
ItemListener {
    final short ARC_NONE = 0;
    final short ARC_SINGLE = 1;
    final short ARC_TAGGED = (short)2;
    final short ARC_FOLDER = (short)3;
    short ArchiveMode;
    Frame frame;
    TextField fieldPath;
    TextField fieldName;
    DButton buttonMake;
    Label labeltitle;
    Label labelArc;
    Label labelArcName;
    Label labelArcPath;
    DCheckbox checkRecurse;
    DCheckbox checkInclude;
    String[] list = null;
    String srcdir = null;
    String source = null;
    String arcname = null;
    String arcpath = "";
    String message = "";
    final int MESSAGE = 0;
    final int TIP = 1;
    final int MADE = 3;
    ActionListener actionListener = null;

    public ArchivePanel(Frame frame) {
        this.setVisible(false);
        this.setLayout(new GridLayout());
        this.frame = frame;
        int n = 24;
        if (!OS.isWindows()) {
            n = 30;
        }
        DBPanel dBPanel = new DBPanel(2);
        dBPanel.setBounds(0, 0, 450, 320);
        this.add(dBPanel);
        Font font = new Font("Dialog", 1, 16);
        this.labeltitle = new Label();
        this.labeltitle.setBounds(16, 32, 320, 24);
        this.labeltitle.setFont(font);
        dBPanel.add(this.labeltitle);
        this.labelArcPath = new Label();
        this.labelArcPath.setBounds(16, 60, 420, 24);
        this.labelArcPath.setFont(font);
        dBPanel.add(this.labelArcPath);
        this.labelArc = new Label("Path of the archive:");
        this.labelArc.setBounds(16, 103, 378, 20);
        dBPanel.add(this.labelArc);
        this.fieldPath = new TextField();
        this.fieldPath.setBounds(16, 127, 360, n);
        dBPanel.add(this.fieldPath);
        this.labelArcName = new Label("Name of the archive:");
        this.labelArcName.setBounds(16, 160, 158, 20);
        dBPanel.add(this.labelArcName);
        this.fieldName = new TextField();
        this.fieldName.setBounds(16, 184, 256, n);
        dBPanel.add(this.fieldName);
        this.checkRecurse = new DCheckbox("Recurse sub-directories", Preferences.ArcRecurse);
        this.checkRecurse.setBounds(32, 248, 200, 24);
        this.checkRecurse.addItemListener(this);
        dBPanel.add(this.checkRecurse);
        this.checkInclude = new DCheckbox("Include full paths", Preferences.ArcInclude);
        this.checkInclude.setBounds(32, 272, 200, 24);
        this.checkInclude.addItemListener(this);
        dBPanel.add(this.checkInclude);
        this.buttonMake = new DButton("Make", true);
        this.buttonMake.setBounds(200, 320, 120, 40);
        this.buttonMake.setTip("Make the archive with name and path above");
        this.buttonMake.addActionListener(this);
        this.buttonMake.setEnabled(false);
        dBPanel.add(this.buttonMake);
    }

    void setAction(String string) {
        this.labeltitle.setText(string);
    }

    void setSource(String string, String string2) {
        this.setAction(string);
        this.labelArcPath.setText(string2);
        this.source = string2;
    }

    void setPath(String string) {
        this.fieldPath.setText(string);
    }

    void setArchive(String string) {
        this.fieldName.setText(string);
    }

    void setList(String[] stringArray) {
        this.list = stringArray;
    }

    void setButtonEnabled(boolean bl) {
        this.buttonMake.setEnabled(bl);
    }

    public String getPath() {
        return this.fieldPath.getText();
    }

    public String getArchive() {
        return this.fieldName.getText();
    }

    public String getSource() {
        return this.source;
    }

    public String[] getList() {
        return this.list;
    }

    public void init(String string, String[] stringArray, String string2) {
        String string3 = null;
        String string4 = null;
        this.srcdir = string;
        int n = stringArray.length;
        this.ArchiveMode = 0;
        if (this.arcname == null) {
            this.arcname = "";
        }
        if (n == 1) {
            String string5 = stringArray[0];
            string4 = Path.merge(string, string5);
            File file = new File(string, string5);
            this.ArchiveMode = file.isDirectory() ? (short)3 : (short)1;
        } else if (n > 1) {
            this.ArchiveMode = (short)2;
        }
        boolean bl = false;
        switch (this.ArchiveMode) {
            default: {
                string3 = "ARCHIVER";
                string4 = "Select files or directories to archive";
                string2 = "";
                break;
            }
            case 1: {
                string3 = "Archiving a file";
                bl = true;
                break;
            }
            case 3: {
                string3 = "Archiving a directory";
                bl = true;
                break;
            }
            case 2: {
                string3 = "Archiving a list of files";
                string4 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separator).append("[TAGGED LIST]")));
                bl = true;
            }
        }
        this.setButtonEnabled(bl);
        this.setSource(string3, string4);
        this.setPath(string2);
        this.setArchive(this.arcname);
        this.setList(stringArray);
    }

    void archive() {
        this.arcpath = this.getPath();
        String string = this.getArchive();
        String string2 = this.getSource();
        Archiver.setMessage("Error");
        if (this.ArchiveMode == 0) {
            this.dispTip("Nothing to do! Select files/dir in first panel, please...");
            return;
        }
        if (string == null || string.length() == 0) {
            this.dispTip("Give a name to the archive, please!");
            return;
        }
        if (Path.hasExtension(string)) {
            if (Directory.isGZip(string) && this.ArchiveMode != 1) {
                this.dispTip("GZip require a single file");
                return;
            }
            if (!Directory.isArchive(string)) {
                this.dispTip("Give a valid archive extension or none (default is zip)");
                return;
            }
        } else {
            string = String.valueOf(String.valueOf(string)).concat(".zip");
        }
        this.setArchive(string);
        String string3 = Path.merge(this.arcpath, string);
        boolean bl = new File(this.arcpath, string).exists();
        if (bl) {
            DialogCYN dialogCYN = new DialogCYN(this.frame, String.valueOf(String.valueOf(new StringBuffer("Erasing the current ").append(string.toUpperCase()).append(" archive, continue?"))));
            dialogCYN.setVisible(true);
            if (dialogCYN.answer != 1) {
                return;
            }
        }
        boolean bl2 = false;
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this.ArchiveMode == 1) {
            this.Message(String.valueOf(String.valueOf(new StringBuffer("Archiving ").append(string2).append(" into ").append(string3))));
            bl2 = Archiver.archiveAnyFile(string2, string3);
            if (bl2) {
                this.Message("Archive completed");
            } else {
                this.Message(Archiver.getMessage());
            }
            this.setCursor(cursor);
            return;
        }
        String[] stringArray = this.getList();
        String string4 = null;
        if (this.ArchiveMode == 3) {
            String string5 = stringArray[0];
            this.Message(String.valueOf(String.valueOf(new StringBuffer("Archiving ").append(string5).append("'s content into ").append(string3))));
            if (Preferences.ArcInclude) {
                string4 = this.srcdir;
            } else {
                string4 = Path.merge(this.srcdir, string5);
                stringArray = new File(string4).list();
            }
        }
        if (this.ArchiveMode == 2) {
            this.Message(String.valueOf(String.valueOf(new StringBuffer("Archiving ").append(string2).append(" into ").append(string3))));
            string4 = this.srcdir;
        }
        if (stringArray.length > 0) {
            int n = Archiver.archive(string4, stringArray, string3);
            this.Message(String.valueOf(String.valueOf(new StringBuffer("Archived ").append(n).append(" files"))));
            if (Archiver.error) {
                new DialogMessage(this.frame, "Error in archiving").setVisible(true);
            }
        } else {
            this.dispTip("Nothing to do");
        }
        this.setCursor(cursor);
    }

    void Message(String string) {
        this.message = string;
        this.sourceActionEvent(0);
    }

    void dispTip(String string) {
        this.message = string;
        this.sourceActionEvent(1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonMake) {
            this.archive();
            this.sourceActionEvent(3);
        }
    }

    protected void sourceActionEvent(int n) {
        if (this.actionListener == null) {
            return;
        }
        String string = new Integer(n).toString();
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkRecurse) {
            Preferences.ArcRecurse = this.checkRecurse.getState();
        } else if (object == this.checkInclude) {
            Preferences.ArcInclude = this.checkInclude.getState();
        }
    }
}

