/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Timer
implements Runnable {
    protected int eventType;
    protected boolean repeat;
    protected boolean repeating;
    protected boolean execute;
    protected boolean live;
    protected int delay;
    protected String actionCommand;
    protected ActionListener actionListener = null;
    protected transient Thread thread;

    public Timer() {
        this(1000, false);
    }

    public Timer(int n) {
        this(n, false);
    }

    public Timer(boolean bl) {
        this(1000, bl);
    }

    public Timer(int n, boolean bl) {
        this.delay = n;
        this.repeat = bl;
        this.execute = false;
        this.thread = new Thread(this);
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void pause() {
        this.execute = false;
    }

    public void start() {
        this.execute = true;
        this.live = true;
        if (this.thread.isAlive()) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void start(int n) {
        this.setDelay(n);
        this.start();
    }

    public void start(boolean bl) {
        this.setRepeat(bl);
        this.start();
    }

    public void start(int n, boolean bl) {
        this.setDelay(n);
        this.setRepeat(bl);
        this.start();
    }

    public void stop() {
        this.execute = false;
        this.repeating = false;
        this.live = false;
        this.thread.interrupt();
    }

    public void run() {
        if (!this.execute) {
            this.thread.interrupt();
        }
        try {
            while (this.live) {
                do {
                    this.repeating = this.repeat;
                    Thread.sleep(this.delay);
                    if (!this.execute) continue;
                    this.sourceActionEvent();
                } while (this.repeating && this.live);
                if ((this.execute || !this.live) && this.repeating) continue;
                this.thread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public static void Delay(int n) {
        Thread thread = new Thread();
        thread.start();
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread.destroy();
    }
}

