/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DirButton;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SpinButtonPanel
extends Panel
implements ActionListener {
    protected double widthHeightRatio = 1.25;
    protected DirButton incButton = new DirButton(2);
    protected DirButton decButton = new DirButton(3);
    protected ActionListener actionListener = null;

    public SpinButtonPanel() {
        this.incButton.setBevelHeight(1);
        this.incButton.setShowFocus(false);
        this.decButton.setBevelHeight(1);
        this.decButton.setShowFocus(false);
        this.add(this.incButton);
        this.add(this.decButton);
        this.setDelay(250);
        this.setNotifyWhilePressed(true);
        this.incButton.addActionListener(this);
        this.decButton.addActionListener(this);
    }

    public void setNotifyWhilePressed(boolean bl) {
        this.incButton.setNotifyWhilePressed(bl);
        this.decButton.setNotifyWhilePressed(bl);
    }

    public boolean isNotifyWhilePressed() {
        return this.incButton.isNotifyWhilePressed();
    }

    public void setDelay(int n) {
        this.incButton.setNotifyDelay(n);
        this.decButton.setNotifyDelay(n);
    }

    public int getDelay() {
        return this.incButton.getNotifyDelay();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            super.setEnabled(bl);
            this.incButton.setEnabled(bl);
            this.decButton.setEnabled(bl);
        }
    }

    public synchronized void setUpButtonEnabled(boolean bl) {
        this.incButton.setEnabled(bl);
    }

    public boolean isUpButtonEnabled() {
        return this.incButton.isEnabled();
    }

    public synchronized void setDownButtonEnabled(boolean bl) {
        this.decButton.setEnabled(bl);
    }

    public boolean isDownButtonEnabled() {
        return this.decButton.isEnabled();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = n4 / 2;
        int n6 = (int)((double)n5 * this.widthHeightRatio);
        this.incButton.setBounds(0, 0, n6, n5);
        this.decButton.setBounds(0, n5, n6, n5);
        super.setBounds(n, n2, n3, n4);
    }

    public Dimension getPreferredSize() {
        int n = this.getSize().height;
        return new Dimension((int)((double)(n / 2) * this.widthHeightRatio), n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.incButton) {
            this.sourceActionEvent("Increment");
        } else if (object == this.decButton) {
            this.sourceActionEvent("Decrement");
        }
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }
}

