/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos = 0;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.pos = n;
        this.count = Math.min(n + n2, cArray.length);
        this.markedPos = n;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.pos >= this.count) {
                int n = -1;
                return n;
            }
            char c = this.buf[this.pos++];
            return c;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                int n3 = 0;
                return n3;
            }
            if (this.pos >= this.count) {
                int n4 = -1;
                return n4;
            }
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            if (n2 <= 0) {
                int n5 = 0;
                return n5;
            }
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            int n6 = n2;
            return n6;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if ((long)this.pos + l > (long)this.count) {
                l = this.count - this.pos;
            }
            if (l < 0L) {
                long l2 = 0L;
                return l2;
            }
            this.pos = (int)((long)this.pos + l);
            long l3 = l;
            return l3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = this.count - this.pos > 0;
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.markedPos = this.pos;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.pos = this.markedPos;
        }
    }

    public void close() {
        this.buf = null;
    }
}

