/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.PKCS7;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertImpl(byArray);
            }
            return new X509CertImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return this.parseX509orPKCS7Cert(new ByteArrayInputStream(byArray));
            }
            return this.parseX509orPKCS7Cert(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CRLImpl(byArray);
            }
            return new X509CRLImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return this.parseX509orPKCS7CRL(new ByteArrayInputStream(byArray));
            }
            return this.parseX509orPKCS7CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    private Collection parseX509orPKCS7Cert(InputStream inputStream) throws CertificateException {
        try {
            inputStream.mark(inputStream.available());
            X509CertImpl x509CertImpl = new X509CertImpl(inputStream);
            return Arrays.asList(new X509Certificate[]{x509CertImpl});
        }
        catch (CertificateException certificateException) {
            try {
                inputStream.reset();
                PKCS7 pKCS7 = new PKCS7(inputStream);
                Object[] objectArray = pKCS7.getCertificates();
                if (objectArray != null) {
                    return Arrays.asList(objectArray);
                }
                return new ArrayList(0);
            }
            catch (IOException iOException) {
                throw new CertificateException(iOException.getMessage());
            }
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    private Collection parseX509orPKCS7CRL(InputStream inputStream) throws CRLException {
        try {
            inputStream.mark(inputStream.available());
            X509CRLImpl x509CRLImpl = new X509CRLImpl(inputStream);
            return Arrays.asList(new X509CRL[]{x509CRLImpl});
        }
        catch (CRLException cRLException) {
            try {
                inputStream.reset();
                PKCS7 pKCS7 = new PKCS7(inputStream);
                Object[] objectArray = pKCS7.getCRLs();
                if (objectArray != null) {
                    return Arrays.asList(objectArray);
                }
                return new ArrayList(0);
            }
            catch (IOException iOException) {
                throw new CRLException(iOException.getMessage());
            }
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    private byte[] base64_to_binary(InputStream inputStream) throws IOException {
        long l = 0L;
        inputStream.mark(inputStream.available());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
        String string = this.readLine(bufferedReader);
        if (string == null || !string.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        l += (long)string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(bufferedReader)) != null && !string.startsWith("-----END")) {
            stringBuffer.append(string);
        }
        if (string == null) {
            throw new IOException("Unsupported encoding");
        }
        l += (long)string.length();
        inputStream.reset();
        inputStream.skip(l += (long)stringBuffer.length());
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(stringBuffer.toString());
    }

    private byte[] getTotalBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isBase64(InputStream inputStream) throws IOException {
        if (inputStream.available() >= 10) {
            inputStream.mark(10);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            inputStream.reset();
            return n == 45 && n2 == 45 && n3 == 45 && n4 == 45 && n5 == 45 && n6 == 66 && n7 == 69 && n8 == 71 && n9 == 73 && n10 == 78;
        }
        throw new IOException("Cannot determine encoding format");
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        do {
            n = bufferedReader.read();
            stringBuffer.append((char)n);
        } while (n != -1 && n != 10 && n != 13);
        if (n == -1) {
            return null;
        }
        if (n == 13) {
            bufferedReader.mark(1);
            int n2 = bufferedReader.read();
            if (n2 == 10) {
                stringBuffer.append((char)n);
            } else {
                bufferedReader.reset();
            }
        }
        return stringBuffer.toString();
    }
}

