/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    protected int layoutSpan = Short.MAX_VALUE;
    protected View layoutPool;
    protected FlowStrategy strategy = new FlowStrategy();

    public FlowView(Element element, int n) {
        super(element, n);
    }

    public int getFlowAxis() {
        int n = this.getAxis();
        if (this.axis == 1) {
            return 0;
        }
        return 1;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected int getViewIndexAtPosition(int n) {
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            int n2 = this.getViewCount() - 1;
            while (n2 >= 0) {
                View view = this.getView(n2);
                if (n >= view.getStartOffset() && n < view.getEndOffset()) {
                    return n2;
                }
                --n2;
            }
        }
        return -1;
    }

    protected void layout(int n, int n2) {
        int n3;
        int n4 = this.getFlowAxis();
        int n5 = this.getAxis();
        int n6 = n3 = n4 == 0 ? n : n2;
        if (this.layoutSpan != n3) {
            this.layoutChanged(n4);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = n3;
        }
        if (!this.isAllocationValid()) {
            int n7 = n5 == 0 ? n : n2;
            this.strategy.layout(this);
            int n8 = (int)this.getPreferredSpan(n5);
            if (n7 != n8) {
                View view = this.getParent();
                view.preferenceChanged(this, n5 == 0, n5 == 1);
            }
        }
        super.layout(n, n2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        float f = this.layoutPool.getPreferredSpan(n);
        float f2 = this.layoutPool.getMinimumSpan(n);
        float f3 = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        sizeRequirements.minimum = (int)(f3 + f2);
        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)f);
        sizeRequirements.maximum = Short.MAX_VALUE;
        sizeRequirements.alignment = 0.5f;
        return sizeRequirements;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    static class LogicalView
    extends CompositeView {
        LogicalView(Element element) {
            super(element);
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        public float getPreferredSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                f2 += view.getPreferredSpan(n);
                if (view.getBreakWeight(n, 0.0f, 32767.0f) >= 3000) {
                    f = Math.max(f, f2);
                    f2 = 0.0f;
                }
                ++n3;
            }
            f = Math.max(f, f2);
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = false;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                if (view.getBreakWeight(n, 0.0f, 32767.0f) == 0) {
                    f2 += view.getPreferredSpan(n);
                    bl = true;
                } else if (bl) {
                    f = Math.max(f2, f);
                    bl = false;
                    f2 = 0.0f;
                }
                ++n3;
            }
            f = Math.max(f, f2);
            return f;
        }

        protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            view.setParent(this);
            super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        protected boolean isBefore(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected boolean isAfter(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
            return null;
        }

        protected void childAllocation(int n, Rectangle rectangle) {
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                flowView.setSize(rectangle.width, rectangle.height);
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                int n = flowView.getWidth();
                int n2 = flowView.getHeight();
                if (n > 0 && n2 > 0) {
                    flowView.setSize(n, n2);
                }
            }
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                flowView.setSize(rectangle.width, rectangle.height);
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                int n = flowView.getWidth();
                int n2 = flowView.getHeight();
                if (n > 0 && n2 > 0) {
                    flowView.setSize(n, n2);
                }
            }
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                flowView.setSize(rectangle.width, rectangle.height);
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                int n = flowView.getWidth();
                int n2 = flowView.getHeight();
                if (n > 0 && n2 > 0) {
                    flowView.setSize(n, n2);
                }
            }
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            int n = flowView.getStartOffset();
            int n2 = flowView.getEndOffset();
            flowView.removeAll();
            View view = this.getLogicalView(flowView);
            int n3 = view.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                View view2 = view.getView(n4);
                view2.setParent(view);
                ++n4;
            }
            int n5 = 0;
            while (n < n2) {
                View view3 = flowView.createRow();
                flowView.append(view3);
                int n6 = this.layoutRow(flowView, n5, n);
                if (view3.getViewCount() == 0) {
                    view3.append(this.createView(flowView, n, Integer.MAX_VALUE, n5));
                    n6 = view3.getEndOffset();
                }
                if (n6 <= n) {
                    throw new StateInvariantError("infinite loop in formatting");
                }
                n = n6;
                ++n5;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            View view;
            View view2 = flowView.getView(n);
            int n3 = flowView.getFlowStart(n);
            int n4 = flowView.getFlowSpan(n);
            int n5 = flowView.getEndOffset();
            TabExpander tabExpander = flowView instanceof TabExpander ? (TabExpander)((Object)flowView) : null;
            int n6 = n3;
            int n7 = n4;
            n6 = n3;
            boolean bl = false;
            while (n2 < n5 && n4 > 0) {
                view = this.createView(flowView, n2, n4, n);
                if (view == null) break;
                int n8 = view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n3, tabExpander) : (int)view.getPreferredSpan(0);
                if (view.getBreakWeight(0, n2, n4) >= 3000) {
                    int n9 = view2.getViewCount();
                    if (n9 > 0) {
                        n8 = (view = view.breakView(0, n2, n3, n4)) != null ? (view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n3, tabExpander) : (int)view.getPreferredSpan(0)) : 0;
                    }
                    bl = true;
                }
                n4 -= n8;
                n3 += n8;
                if (view != null) {
                    view2.append(view);
                    n2 = view.getEndOffset();
                }
                if (bl) break;
            }
            if (n4 < 0) {
                this.adjustRow(flowView, n, n7, n6);
            } else if (view2.getViewCount() == 0) {
                view = this.createView(flowView, n2, Integer.MAX_VALUE, n);
                view2.append(view);
            }
            return view2.getEndOffset();
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view;
            View view2 = flowView.getView(n);
            int n5 = view2.getViewCount();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = -1;
            boolean bl = false;
            int n10 = 0;
            while (n10 < n5) {
                view = view2.getView(n10);
                int n11 = view.getBreakWeight(0, n3 + n6, n4 = n2 - n6);
                if (n11 >= n7 && n11 > 0) {
                    n7 = n11;
                    n9 = n10;
                    n8 = n6;
                    if (n11 >= 3000) break;
                }
                n6 = (int)((float)n6 + view.getPreferredSpan(0));
                ++n10;
            }
            if (n9 < 0) {
                return;
            }
            n4 = n2 - n8;
            view = view2.getView(n9);
            view = view.breakView(0, view.getStartOffset(), n3 + n8, n4);
            View[] viewArray = new View[]{view};
            view2.replace(n9, n5 - n9, viewArray);
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view = this.getLogicalView(flowView);
            View view2 = view.getView(n4 = view.getViewIndex(n, Position.Bias.Forward));
            if (n == view2.getStartOffset()) {
                return view2;
            }
            view2 = view2.createFragment(n, view2.getEndOffset());
            return view2;
        }
    }
}

