/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.MidiOutDeviceProvider;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

class MidiOutDevice
extends AbstractMidiDevice {
    private Vector receivers = new Vector();

    MidiOutDevice(MidiOutDeviceProvider.MidiOutDeviceInfo midiOutDeviceInfo) {
        super(midiOutDeviceInfo);
        if (Printer.trace) {
            Printer.trace(">> MidiOutDevice CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MidiOutDevice CONSTRUCTOR completed");
        }
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiOutDeviceProvider.MidiOutDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    synchronized void implClose() {
        int n = 0;
        while (n < this.receivers.size()) {
            ((Receiver)this.receivers.elementAt(n)).close();
            ++n;
        }
        this.receivers.removeAllElements();
        int n2 = this.id;
        this.id = 0;
        this.nClose(n2);
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        MidiOutReceiver midiOutReceiver = new MidiOutReceiver();
        this.receivers.addElement(midiOutReceiver);
        return midiOutReceiver;
    }

    private native int nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(int var1);

    private native void nSendShortMessage(int var1, int var2, int var3, int var4, long var5);

    class MidiOutReceiver
    implements Receiver {
        private boolean open = true;

        MidiOutReceiver() {
        }

        public void send(ShortMessage shortMessage, long l) {
            if (this.open) {
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, shortMessage.getStatus(), shortMessage.getData1(), shortMessage.getData2(), l);
            }
        }

        public void send(SysexMessage sysexMessage, long l) {
        }

        public void send(MidiMessage midiMessage, long l) {
        }

        public void close() {
            MidiOutDevice.this.receivers.removeElement(this);
            this.open = false;
        }
    }
}

