/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DataPusher;
import com.sun.media.sound.Printer;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JavaSoundAudioClip
implements AudioClip,
MetaEventListener,
LineListener {
    private Clip clip = null;
    private Sequencer sequencer = null;
    private SourceDataLine sourceline = null;
    private DataPusher datapusher = null;
    private boolean sequencerloop = false;
    private boolean streamloop = false;
    private byte[] loadedAudio = null;
    private long clipthresh = 0x100000L;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public JavaSoundAudioClip(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        int n = 1024;
        AudioInputStream audioInputStream = null;
        AudioFormat audioFormat = null;
        if (Printer.debug) {
            Printer.debug("Instantiating com.sun.media.sound.JavaSoundAudioClip");
        }
        bufferedInputStream = new BufferedInputStream(inputStream, n);
        bufferedInputStream.mark(n);
        try {
            audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
            audioFormat = audioInputStream.getFormat();
            long l = audioInputStream.getFrameLength();
            if (l > 0L && l < this.clipthresh ? this.openAsClip(audioInputStream) < 0 : this.openAsStream(audioInputStream) < 0) {
                throw new IOException("Unable to create AudioClip from input stream");
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            try {
                MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(bufferedInputStream);
                if (this.openAsSequence(bufferedInputStream) < 0) {
                    throw new IOException("Unable to create AudioClip from input stream");
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                throw new IOException("Unable to create AudioClip from input stream");
            }
        }
    }

    public synchronized void play() {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->play()");
        }
        if (this.clip != null) {
            this.stop();
            this.clip.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        } else if (this.datapusher != null) {
            this.stop();
            this.streamloop = false;
            this.sourceline.start();
            this.datapusher.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        } else if (this.sequencer != null) {
            this.stop();
            this.sequencerloop = false;
            this.sequencer.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        }
    }

    public synchronized void loop() {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->loop()");
        }
        if (this.clip != null) {
            this.stop();
            this.clip.loop(-1);
            if (Printer.debug) {
                Printer.debug("Clip should be looping");
            }
        } else if (this.datapusher != null) {
            this.stop();
            this.streamloop = true;
            this.sourceline.start();
            this.datapusher.start();
            if (Printer.debug) {
                Printer.debug("Clip should be playing");
            }
        } else if (this.sequencer != null) {
            this.stop();
            this.sequencerloop = true;
            this.sequencer.start();
            if (Printer.debug) {
                Printer.debug("Clip should be looping");
            }
        }
    }

    public synchronized void stop() {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->stop()");
        }
        if (this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
            if (Printer.debug) {
                Printer.debug("Clip should be stopped");
            }
        } else if (this.datapusher != null) {
            this.streamloop = false;
            this.datapusher.stop();
        } else if (this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer.setMicrosecondPosition(0L);
            if (Printer.debug) {
                Printer.debug("Clip should be stopped");
            }
        }
    }

    public synchronized void update(LineEvent lineEvent) {
        if (Printer.debug) {
            Printer.debug("LINE EVENT RECEIVED!!!!!");
        }
        if (this.streamloop && this.datapusher != null && lineEvent.getType() == LineEvent.Type.STOP) {
            this.loop();
        }
    }

    public synchronized void meta(MetaMessage metaMessage) {
        if (Printer.debug) {
            Printer.debug("META EVENT RECEIVED!!!!! ");
        }
        if (metaMessage.getType() == 47) {
            if (this.sequencerloop) {
                this.sequencer.setMicrosecondPosition(0L);
                this.loop();
            } else {
                this.stop();
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected void finalize() {
        if (this.clip != null) {
            this.clip.close();
        }
    }

    private int openAsStream(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->openAsStream()");
        }
        DataLine.Info info = null;
        AudioFormat audioFormat = audioInputStream.getFormat();
        if ((audioInputStream = this.convertToPlayableStream(audioInputStream)) == null) {
            return -1;
        }
        if (this.loadStreamIntoMemory(audioInputStream) <= 0) {
            return -1;
        }
        try {
            info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JavaSoundAudioClip.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioInputStream.getFormat());
            if (!AudioSystem.isLineSupported(info)) {
                return -1;
            }
            this.sourceline = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceline.addLineListener(this);
            this.datapusher = new DataPusher(this.sourceline, this.loadedAudio);
            this.sourceline.open();
        }
        catch (LineUnavailableException lineUnavailableException) {
            return -1;
        }
        if (this.datapusher == null) {
            return -1;
        }
        if (Printer.debug) {
            Printer.debug("Loaded as stream.");
        }
        return 0;
    }

    private int loadStreamIntoMemory(AudioInputStream audioInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16834];
        int n = 0;
        int n2 = 0;
        while (true) {
            if ((n = audioInputStream.read(byArray, 0, byArray.length)) <= 0) break;
            n2 += n;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        audioInputStream.close();
        this.loadedAudio = byteArrayOutputStream.toByteArray();
        return n2;
    }

    private int openAsClip(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->openAsClip()");
        }
        DataLine.Info info = null;
        if ((audioInputStream = this.convertToPlayableStream(audioInputStream)) == null) {
            return -1;
        }
        try {
            info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = JavaSoundAudioClip.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength());
            if (!AudioSystem.isLineSupported(info)) {
                return -1;
            }
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
        }
        catch (LineUnavailableException lineUnavailableException) {
            return -1;
        }
        if (this.clip == null) {
            return -1;
        }
        if (Printer.debug) {
            Printer.debug("Loaded as clip.");
        }
        return 0;
    }

    private AudioInputStream convertToPlayableStream(AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().getEncoding() == AudioFormat.Encoding.ULAW || audioInputStream.getFormat().getEncoding() == AudioFormat.Encoding.ALAW) {
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioInputStream audioInputStream2 = audioInputStream;
            audioInputStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true), audioInputStream2);
        }
        return audioInputStream;
    }

    private int openAsSequence(BufferedInputStream bufferedInputStream) throws IOException {
        if (Printer.debug) {
            Printer.debug("JavaSoundAudioClip->openAsSequence()");
        }
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            return -1;
        }
        if (this.sequencer == null) {
            return -1;
        }
        this.sequencer.addMetaEventListener(this);
        try {
            this.sequencer.open();
            this.sequencer.setSequence(bufferedInputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return -1;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            return -1;
        }
        if (Printer.debug) {
            Printer.debug("Loaded as sequence.");
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

