/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.RequestHandler;
import com.sun.corba.se.internal.core.ServerRequest;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.IIOPInputStream;
import com.sun.corba.se.internal.iiop.IIOPOutputStream;
import com.sun.corba.se.internal.iiop.LocateReplyMessage;
import com.sun.corba.se.internal.iiop.LocateRequestMessage;
import com.sun.corba.se.internal.iiop.Message;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.iiop.Work;
import com.sun.corba.se.internal.iiop.WorkQueue;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

final class CachedWorkerThread
extends Thread {
    private static WorkQueue workQueue = new WorkQueue();
    private static Work currentWork;

    public void run() {
        while (true) {
            currentWork = workQueue.getWorkToDo(this);
            this.doWork(currentWork.getRequestHandler(), currentWork.getConnection(), currentWork.getIIOPInputStream());
        }
    }

    public static IIOPConnection getCurrentConnection() {
        return currentWork.getConnection();
    }

    static void addWorkToDo(RequestHandler requestHandler, IIOPConnection iIOPConnection, IIOPInputStream iIOPInputStream) {
        Work work = new Work(requestHandler, iIOPConnection, iIOPInputStream);
        workQueue.addWorkToDo(work);
    }

    void doWork(RequestHandler requestHandler, Connection connection, IIOPInputStream iIOPInputStream) {
        IIOPOutputStream iIOPOutputStream = null;
        Message message = iIOPInputStream.getMessage();
        ORB oRB = connection.getORB();
        connection.requestBegins();
        switch (message.getType()) {
            case 0: {
                ServerRequest serverRequest = (ServerRequest)((Object)iIOPInputStream);
                try {
                    iIOPOutputStream = (IIOPOutputStream)((Object)requestHandler.process(serverRequest));
                    if (!serverRequest.isOneWay()) break;
                    connection.requestEnds();
                    Thread.currentThread().stop();
                    break;
                }
                catch (SystemException systemException) {
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(systemException, null));
                        break;
                    }
                    catch (Exception exception) {
                        connection.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    UNKNOWN uNKNOWN = new UNKNOWN(1398079492, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(uNKNOWN, null));
                        break;
                    }
                    catch (Exception exception) {
                        connection.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                LocateReplyMessage locateReplyMessage;
                LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
                int n = message.getRequestId();
                IOR iOR = null;
                try {
                    iOR = requestHandler.locate(locateRequestMessage.getObjectKey());
                    locateReplyMessage = iOR == null ? new LocateReplyMessage(n, 1, oRB.transportDebugFlag) : new LocateReplyMessage(n, 2, oRB.transportDebugFlag);
                }
                catch (Exception exception) {
                    locateReplyMessage = new LocateReplyMessage(n, 0, oRB.transportDebugFlag);
                }
                iIOPOutputStream = new IIOPOutputStream(iIOPInputStream.getConnection().getORB(), iIOPInputStream.getConnection());
                locateReplyMessage.write(iIOPOutputStream);
                iIOPOutputStream.setMessage(locateReplyMessage);
                if (iOR == null) break;
                iOR.write(iIOPOutputStream);
                break;
            }
            case 2: {
                connection.requestEnds();
                return;
            }
            default: {
                connection.requestEnds();
                return;
            }
        }
        try {
            connection.sendReply(iIOPOutputStream);
            connection.requestEnds();
        }
        catch (Exception exception) {
            connection.requestEnds();
            return;
        }
    }
}

