/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.misc.HexDumpEncoder;
import sun.plugin.AppletViewer;
import sun.security.x509.SerialNumber;

class CertificateDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private Certificate[] certs = null;
    private int index = 0;
    JTextArea textArea = new JTextArea();

    CertificateDialog(JDialog jDialog, Certificate[] certificateArray, int n) {
        super(jDialog != null ? jDialog : new JDialog(), CertificateDialog.getMessage("cert_dialog.caption"), true);
        this.certs = certificateArray;
        this.index = n;
    }

    void DoModal() {
        if (this.certs.length > this.index && this.certs[this.index] instanceof X509Certificate) {
            ((Component)this).setBackground(SystemColor.control);
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, CertificateDialog.getMessage("cert_dialog.field"));
            TitledBorder titledBorder2 = BorderFactory.createTitledBorder(border, CertificateDialog.getMessage("cert_dialog.value"));
            Object[] objectArray = new Object[]{CertificateDialog.getMessage("cert_dialog.field.Version"), CertificateDialog.getMessage("cert_dialog.field.SerialNumber"), CertificateDialog.getMessage("cert_dialog.field.SignatureAlg"), CertificateDialog.getMessage("cert_dialog.field.Issuer"), CertificateDialog.getMessage("cert_dialog.field.EffectiveDate"), CertificateDialog.getMessage("cert_dialog.field.ExpirationDate"), CertificateDialog.getMessage("cert_dialog.field.Subject"), CertificateDialog.getMessage("cert_dialog.field.Signature")};
            JList<Object> jList = new JList<Object>(objectArray);
            jList.setSelectionMode(0);
            jList.addListSelectionListener(this);
            jList.setSelectedIndex(0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(titledBorder);
            jPanel.add((Component)new JScrollPane(jList), "Center");
            this.textArea.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(titledBorder2);
            jPanel2.add((Component)new JScrollPane(this.textArea), "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridLayout(1, 2));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            JPanel jPanel4 = new JPanel();
            JButton jButton = new JButton(CertificateDialog.getMessage("cert_dialog.okButton"));
            jPanel4.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CertificateDialog.this.dispose();
                }
            });
            JButton jButton2 = new JButton(CertificateDialog.getMessage("cert_dialog.issuerButton"));
            if (this.certs.length == this.index + 1) {
                jButton2.setEnabled(false);
            } else {
                jButton2.addActionListener(this);
            }
            jPanel4.add(jButton2);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel3, "Center");
            this.getContentPane().add((Component)jPanel4, "South");
            ((Component)this).setSize(500, 300);
            this.setResizable(false);
            this.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CertificateDialog certificateDialog = new CertificateDialog(this, this.certs, this.index + 1);
        certificateDialog.DoModal();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        int n = jList.getSelectedIndex();
        X509Certificate x509Certificate = (X509Certificate)this.certs[this.index];
        switch (n) {
            case 0: {
                this.textArea.setText(x509Certificate.getVersion() + "");
                break;
            }
            case 1: {
                this.textArea.setLineWrap(false);
                SerialNumber serialNumber = new SerialNumber(x509Certificate.getSerialNumber());
                this.textArea.setText(serialNumber.getNumber().toString());
                this.textArea.repaint();
                break;
            }
            case 2: {
                this.textArea.setLineWrap(false);
                this.textArea.setText(x509Certificate.getSigAlgName());
                this.textArea.repaint();
                break;
            }
            case 3: {
                this.textArea.setLineWrap(true);
                this.textArea.setText(x509Certificate.getIssuerDN().toString());
                this.textArea.repaint();
                break;
            }
            case 4: {
                this.textArea.setLineWrap(false);
                this.textArea.setText(x509Certificate.getNotBefore().toString());
                this.textArea.repaint();
                break;
            }
            case 5: {
                this.textArea.setLineWrap(false);
                this.textArea.setText(x509Certificate.getNotAfter().toString());
                this.textArea.repaint();
                break;
            }
            case 6: {
                this.textArea.setLineWrap(true);
                this.textArea.setText(x509Certificate.getSubjectDN().toString());
                this.textArea.repaint();
                break;
            }
            case 7: {
                this.textArea.setLineWrap(false);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                this.textArea.setText(hexDumpEncoder.encodeBuffer(x509Certificate.getSignature()));
                this.textArea.repaint();
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        super.setVisible(bl);
    }

    private static String getMessage(String string) {
        return AppletViewer.getMessage(string);
    }
}

