/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Stack;
import org.mozilla.javascript.Node;

public class StmtNodeIterator {
    private Stack itsStack = new Stack();
    private Node itsStart;
    private Node itsCurrentNode;

    public StmtNodeIterator(Node node) {
        this.itsStart = node;
    }

    private Node findFirstInterestingNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getType() == 132 || node.getType() == 137 || node.getType() == 109) {
            if (node.getFirst() == null) {
                return this.findFirstInterestingNode(node.getNext());
            }
            this.itsStack.push(node);
            return this.findFirstInterestingNode(node.getFirst());
        }
        return node;
    }

    public Node nextNode() {
        if (this.itsCurrentNode == null) {
            this.itsCurrentNode = this.findFirstInterestingNode(this.itsStart);
            return this.itsCurrentNode;
        }
        this.itsCurrentNode = this.itsCurrentNode.getNext();
        if (this.itsCurrentNode == null) {
            while (!this.itsStack.isEmpty()) {
                Node node = (Node)this.itsStack.pop();
                if (node.getNext() == null) continue;
                this.itsCurrentNode = this.findFirstInterestingNode(node.getNext());
                return this.itsCurrentNode;
            }
            return null;
        }
        this.itsCurrentNode = this.findFirstInterestingNode(this.itsCurrentNode);
        return this.itsCurrentNode;
    }
}

