/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GVolumeDialog
extends GOkCancelHelpDialog
implements ActionListener {
    private TextField number;
    private TextField varName;
    private GButton writeDown;
    private GSolid solid;
    private GNotepad notepad;
    private double volumeValue;

    public GVolumeDialog(GFrame gFrame, GNotepad gNotepad, GSolid gSolid) {
        super(gFrame, "Compute Volume of Solid " + gSolid.getLabel());
        this.helpTopic = "measure volume";
        this.notepad = gNotepad;
        this.solid = gSolid;
        this.number = new TextField(7);
        this.number.setFont(gFrame.numberFont);
        this.number.setEditable(false);
        this.varName = new TextField(5);
        this.varName.setFont(gFrame.labelFont);
        this.writeDown = new GButton("Write Down");
        this.writeDown.addActionListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.init();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        Label label = new Label("Volume:", 0);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.number, gridBagConstraints);
        this.dataPanel.add(this.number);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 10;
        Label label2 = new Label("Assign variable:", 0);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.varName, gridBagConstraints);
        this.dataPanel.add(this.varName);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 50;
        gridBagLayout.setConstraints(this.writeDown, gridBagConstraints);
        this.writeDown.setFont(GDialog.buttonFont);
        this.dataPanel.add(this.writeDown);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.ipadx = 0;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        return true;
    }

    public void init() {
        this.volumeValue = this.solid.computeVolume();
        ((TextComponent)this.number).setText(String.valueOf((float)this.volumeValue));
        this.number.select(0, GMath.leadingDigits(this.volumeValue));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.writeDown) {
            String string = this.varName.getText().trim();
            String string2 = GVariable.checkName(string);
            if (string2 != null) {
                new GAlertDialog(GDialog.frame, "warn.gif", "Invalid Variable", string2);
                return;
            }
            String[] stringArray = new String[]{this.solid.toString()};
            if (!this.notepad.add(new GVariable(string, this.volumeValue), stringArray, this.solid, 3)) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA Notepad", "Variable " + string + " in use");
                return;
            }
            ((Component)this).setVisible(false);
        }
    }
}

