/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;

public class GLayAngleDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "layangle.gif";
    public static final Dimension ICONDIM = new Dimension(95, 73);
    private TextField angle;
    private TextField p1;
    private TextField p2;
    private List facets;
    private Label facetPrompt;
    private Object angleObject;
    private GSolid solid;
    private GNotepad notepad;

    public GLayAngleDialog(GFrame gFrame, GNotepad gNotepad, GSolid gSolid, int n, Object[] objectArray) {
        super(gFrame, "Lay Angle");
        this.helpTopic = "lay angle";
        this.notepad = gNotepad;
        this.solid = gSolid;
        this.angle = new TextField(7);
        this.angle.setFont(gFrame.numberFont);
        this.p1 = new TextField(3);
        this.p1.setFont(gFrame.labelFont);
        this.p2 = new TextField(3);
        this.p2.setFont(gFrame.labelFont);
        this.facets = new List(2, false);
        this.facets.setFont(gFrame.labelFont);
        this.facetPrompt = new Label("In facet:");
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        Label label = new Label("Lay angle of");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.angle, gridBagConstraints);
        this.dataPanel.add(this.angle);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 0;
        Label label2 = new Label("degrees", 0);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 15;
        Label label3 = new Label("Off ray:");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(this.p1, gridBagConstraints);
        this.dataPanel.add(this.p1);
        gridBagConstraints.insets.top = 10;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p2, gridBagConstraints);
        this.dataPanel.add(this.p2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 2;
        this.facetPrompt.setForeground(this.dataPanel.getBackground().darker());
        gridBagLayout.setConstraints(this.facetPrompt, gridBagConstraints);
        this.dataPanel.add(this.facetPrompt);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.facets, gridBagConstraints);
        this.dataPanel.add(this.facets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase(), this.angleObject, null, null};
        if (this.facets.getSelectedIndex() == 0) {
            objectArray[3] = this.facets.getItem(0);
            objectArray[4] = this.facets.getItem(1);
        } else if (this.facets.getSelectedIndex() == 1) {
            objectArray[3] = this.facets.getItem(1);
            objectArray[4] = this.facets.getItem(0);
        }
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p1).setText((String)objectArray[0]);
        ((TextComponent)this.p2).setText((String)objectArray[1]);
        this.angleObject = objectArray[2];
        if (objectArray[3] != null) {
            this.facets.add((String)objectArray[3]);
            this.facets.add((String)objectArray[4]);
            this.facets.select(0);
        }
    }

    protected boolean onOk() {
        double d;
        String[] stringArray = new String[]{this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase()};
        if (this.angleObject != null) {
            double d2 = this.angleObject instanceof GVariable ? ((GVariable)this.angleObject).getValue() : ((Double)this.angleObject).doubleValue();
            this.solid.layAngle(stringArray, d2, this.facets.getSelectedItem());
            return true;
        }
        String string = this.angle.getText();
        if (stringArray[0].equals("") || stringArray[1].equals("") || string.equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Operation improperly referenced");
            return false;
        }
        if (stringArray[0].equals(stringArray[1])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[0]) + stringArray[1] + " is no line");
            return false;
        }
        this.angleObject = this.notepad.seekDoubleObject(string);
        if (this.angleObject == null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Wrong number format or incorrect variable reference: " + string);
            return false;
        }
        double d3 = d = this.angleObject instanceof GVariable ? ((GVariable)this.angleObject).getValue() : ((Double)this.angleObject).doubleValue();
        if (d <= 0.0 || d >= 180.0) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Angle must be between 0 and 180 degrees");
            this.angleObject = null;
            return false;
        }
        String string2 = this.solid.layAngle(stringArray, d, this.facets.getSelectedItem());
        if (string2 == null) {
            return true;
        }
        if (string2.equals("Facet Prompt")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Facet Prompt", "Select a facet in which to draw");
            this.set(0, null);
        } else {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string2);
        }
        this.angleObject = null;
        return false;
    }

    public void set(int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Lay Angle in Solid " + this.solid.getLabel());
            GVertexNode gVertexNode = this.solid.getSelectedVertices().getHead();
            if (gVertexNode != null) {
                GVertex gVertex = gVertexNode.getVertex();
                ((TextComponent)this.p1).setText(gVertex.getLabel());
                GEdgeNode gEdgeNode = this.solid.getSelectedEdges().getHead();
                if (gEdgeNode != null) {
                    GEdge gEdge = gEdgeNode.getEdge();
                    GVertex gVertex2 = gEdge.getHead();
                    GVertex gVertex3 = gEdge.getTail();
                    if (gVertex2 == gVertex) {
                        ((TextComponent)this.p2).setText(gVertex3.getLabel());
                    } else if (gVertex3 == gVertex) {
                        ((TextComponent)this.p2).setText(gVertex2.getLabel());
                    }
                    if (gEdge.twin != null) {
                        this.facetPrompt.setForeground(this.dataPanel.getForeground());
                        this.facets.add(gEdge.wing1.toString());
                        this.facets.add(gEdge.wing2.toString());
                        if (gEdge.wing1.isSelected()) {
                            this.facets.select(0);
                        } else if (gEdge.wing2.isSelected()) {
                            this.facets.select(1);
                        } else {
                            this.facets.select(0);
                        }
                    }
                }
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

