/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GFacetList
implements Serializable {
    private GFacetNode head;
    private GFacetNode tail;
    private int dim = 0;

    public void print() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            gFacetNode.getFacet().print();
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void addToHead(GFacet gFacet) {
        GFacetNode gFacetNode = new GFacetNode(gFacet);
        if (this.head == null) {
            this.head = this.tail = gFacetNode;
        } else {
            this.head.setPrev(gFacetNode);
            gFacetNode.setNext(this.head);
            this.head = gFacetNode;
        }
        ++this.dim;
    }

    public void addToTail(GFacet gFacet) {
        GFacetNode gFacetNode = new GFacetNode(gFacet);
        if (this.head == null) {
            this.head = this.tail = gFacetNode;
        } else {
            this.tail.setNext(gFacetNode);
            gFacetNode.setPrev(this.tail);
            this.tail = gFacetNode;
        }
        ++this.dim;
    }

    public GFacetNode getHead() {
        return this.head;
    }

    public GFacetNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public void flushTempEdges() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            gFacetNode.getFacet().tempEdges.flush();
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void unmarkAllVertices() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                GVertexNode gVertexNode = gEdgeNode.getEdge().vertexList.getHead();
                while (gVertexNode != null) {
                    gVertexNode.getVertex().setMarked(false);
                    gVertexNode = gVertexNode.getNext();
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void unmarkAllEdges() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                gEdgeNode.getEdge().setMarked(false);
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void unmarkAllFacets() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            gFacetNode.getFacet().setMarked(false);
            gFacetNode = gFacetNode.getNext();
        }
    }

    public GVertexList getVertexList() {
        this.unmarkAllVertices();
        GVertexList gVertexList = new GVertexList();
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                GVertexNode gVertexNode = gEdgeNode.getEdge().vertexList.getHead();
                while (gVertexNode != null) {
                    GVertex gVertex = gVertexNode.getVertex();
                    if (!gVertex.isMarked()) {
                        gVertexList.addToTail(gVertex);
                        gVertex.setMarked(true);
                    }
                    gVertexNode = gVertexNode.getNext();
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
        return gVertexList.sort();
    }

    public void buildEdgeWingsTwins() {
        this.unmarkAllEdges();
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (!gEdge.isMarked()) {
                    gEdge.wing1 = gFacet;
                    GFacetNode gFacetNode2 = this.head;
                    while (gFacetNode2 != null) {
                        if (gFacetNode2 != gFacetNode) {
                            GFacet gFacet2 = gFacetNode2.getFacet();
                            GEdge gEdge2 = gFacet2.edgeList.seek(gEdge);
                            if (gEdge2 != null) {
                                gEdge2.wing1 = gFacet2;
                                gEdge.wing2 = gFacet2;
                                gEdge2.wing2 = gFacet;
                                gEdge.twin = gEdge2;
                                gEdge2.twin = gEdge;
                                gEdge.setMarked(true);
                            }
                        }
                        gFacetNode2 = gFacetNode2.getNext();
                    }
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void initEdgeStars() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            gFacetNode.getFacet();
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                GVertexNode gVertexNode = gEdgeNode.getEdge().vertexList.getHead();
                while (gVertexNode != null) {
                    gVertexNode.getVertex().edgeStar = new GEdgeList();
                    gVertexNode = gVertexNode.getNext();
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void initTempEdges() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            gFacetNode.getFacet().tempEdges = new GEdgeList();
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void buildEdgeStars() {
        this.initEdgeStars();
        this.unmarkAllEdges();
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            gFacetNode.getFacet();
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (!gEdge.isMarked()) {
                    GVertex gVertex = gEdge.getHead();
                    gVertex.edgeStar.addToTail(gEdge);
                    GVertex gVertex2 = gEdge.getTail();
                    if (gEdge.twin != null) {
                        gVertex2.edgeStar.addToTail(gEdge.twin);
                    } else {
                        gVertex2.edgeStar.addToTail(new GEdge(gVertex2, gVertex));
                    }
                    GVertexNode gVertexNode = gEdge.vertexList.getHead().getNext();
                    while (gVertexNode != gEdge.vertexList.getTail()) {
                        GVertex gVertex3 = gVertexNode.getVertex();
                        gVertex3.edgeStar.addToTail(new GEdge(gVertex3, gVertex));
                        gVertex3.edgeStar.addToTail(new GEdge(gVertex3, gVertex2));
                        gVertexNode = gVertexNode.getNext();
                    }
                    gEdge.setMarked(true);
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void clearSelection(boolean bl, boolean bl2) {
        if (this.dim == 0) {
            return;
        }
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            if (bl2) {
                gFacet.setSelected(false);
            }
            if (bl) {
                gFacet.edgeList.clearSelection();
                gFacet.tempEdges.flush();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public boolean seek(GFacet gFacet) {
        if (this.head == null) {
            return false;
        }
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet2 = gFacetNode.getFacet();
            if (gFacet2 == gFacet) {
                return true;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return false;
    }

    public GEdge seek(GVertex gVertex) {
        if (this.head == null) {
            return null;
        }
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GEdgeNode gEdgeNode = gFacetNode.getFacet().edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (gEdge.vertexList.seek(gVertex) != null) {
                    return gEdge;
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
        return null;
    }

    public GFacet seek(GVertex gVertex, GVertex gVertex2, GVertex gVertex3) {
        if (this.head == null) {
            return null;
        }
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (!bl3 && gEdge.vertexList.seek(gVertex) != null) {
                    bl3 = true;
                }
                if (!bl2 && gEdge.vertexList.seek(gVertex2) != null) {
                    bl2 = true;
                }
                if (!bl && gEdge.vertexList.seek(gVertex3) != null) {
                    bl = true;
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            if (bl3 && bl2 && bl) {
                return gFacet;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return null;
    }

    public int getNrEdges() {
        int n = 0;
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (gEdge.wing1 == gFacet) {
                    ++n;
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
        return n;
    }

    public void removeParaEdgesVerts() {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            GEdgeList gEdgeList = new GEdgeList();
            GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (gEdge.twin == null) {
                    gFacet.edgeList = gEdgeList;
                    break;
                }
                gEdge.vertexList = new GVertexList(gEdge.getHead(), gEdge.getTail());
                gEdgeList.addToTail(gEdge);
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public GFacet seek(String string) {
        GFacetNode gFacetNode = this.head;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            if (string.equals(gFacet.toString())) {
                return gFacet;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return null;
    }
}

