/*
 * Decompiled with CFR 0.152.
 */
package ishitai.oopad;

import ishitai.bots.BotFactory;
import ishitai.bots.ExcepBot;
import ishitai.oopad.Adapter;
import ishitai.oopad.AppCloser;
import ishitai.oopad.Module;
import ishitai.oopad.TXTdata;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TXTmodule
implements Module,
TextListener,
ActionListener {
    public AppCloser appcloser = new AppCloser(this);
    private final String dirtyQuery = "Current file dirty -- save? (y or n): ";
    private TextArea textarea = null;
    private TextField status = null;
    private TXTdata data = null;
    private Adapter adapter = null;
    private String query = null;
    private boolean dirty = false;
    private boolean start = true;
    private int state = -1;
    private ExcepBot ebot = BotFactory.getExcepBot();

    TXTmodule(Adapter adapter) {
        this.adapter = adapter;
        Component[] componentArray = this.adapter.setTarget(this, this.appcloser);
        this.textarea = (TextArea)componentArray[0];
        this.status = (TextField)componentArray[1];
        this.registerCalls();
        if (this.start) {
            this.setData();
            this.textarea.setText(this.data.showLicense());
            if (this.data.readOnly()) {
                this.textarea.setEditable(false);
            }
            this.start = false;
        }
    }

    private void _exit() {
        System.exit(0);
    }

    private void _new() {
        this.setData();
        this.status.setEditable(false);
        this.textarea.setEditable(true);
        this.textarea.setText("");
        this.status.setText("New file loaded.");
        if (this.status.hasFocus()) {
            this.status.setText(String.valueOf(this.status.getText()) + "  TAB to edit.");
            this.dirty = false;
        }
    }

    private void _open() {
        this.setData();
        this.status.setEditable(false);
        this.textarea.setEditable(true);
        String string = this.data.open();
        if (string.compareTo("") == 0) {
            this.status.setText("Current file retained.");
        } else {
            this.textarea.setText(string);
            this.status.setText(String.valueOf(this.data.getFilename()) + " loaded.");
            if (this.data.readOnly()) {
                this.textarea.setEditable(false);
                this.status.setText(String.valueOf(this.status.getText()) + " READ ONLY.");
            }
        }
        if (this.status.hasFocus() & (this.data.readOnly() ^ true)) {
            this.status.setText(String.valueOf(this.status.getText()) + "  TAB to edit.");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.status.getText();
        this.status.setText("");
        string = this.getReply(string);
        if (this.query.compareTo("Current file dirty -- save? (y or n): ") == 0) {
            if (string.compareTo("y") == 0) {
                this.saveFile();
            }
            this.setState();
        }
    }

    private void clean() {
        this.query = "Current file dirty -- save? (y or n): ";
        this.textarea.setEditable(false);
        this.status.setEditable(true);
        this.status.requestFocus();
        this.status.setText("Current file dirty -- save? (y or n): ");
        this.status.setCaretPosition(this.status.getText().length());
    }

    public void exitFile() {
        this.state = 2;
        if (this.dirty) {
            this.clean();
        } else {
            this._exit();
        }
    }

    private String getReply(String string) {
        string.trim();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.reverse();
        byte[] byArray = stringBuffer.toString().getBytes();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        char c = (char)byArray[n];
        while (!Character.isWhitespace(c)) {
            stringBuffer2.append(c);
            c = (char)byArray[++n];
        }
        stringBuffer2.reverse();
        string = new String(stringBuffer2);
        return string;
    }

    public void newFile() {
        this.state = 0;
        if (this.dirty) {
            this.clean();
        } else {
            this._new();
        }
    }

    public void openFile() {
        this.state = 1;
        if (this.dirty) {
            this.clean();
        } else {
            this._open();
        }
    }

    private void registerCalls() {
        this.adapter.registerCall("New", "newFile");
        this.adapter.registerCall("Open", "openFile");
        this.adapter.registerCall("Save", "saveFile");
        this.adapter.registerCall("Exit", "exitFile");
    }

    public void saveFile() {
        if (!this.data.readOnly()) {
            String string = this.textarea.getText();
            if (string.compareTo("") != 0) {
                if (this.data == null) {
                    this.data = new TXTdata();
                }
                this.data.write(string);
                this.dirty = false;
                this.status.setText(String.valueOf(this.data.getFilename()) + " saved.");
            }
            if (this.status.hasFocus()) {
                this.status.setText(String.valueOf(this.status.getText()) + "  TAB to edit.");
            }
        } else {
            this.status.setText("Current file is READ ONLY.");
        }
    }

    private void setData() {
        if (this.data != null) {
            this.data.close();
        }
        this.data = new TXTdata();
    }

    private void setState() {
        switch (this.state) {
            case 0: {
                this._new();
                break;
            }
            case 1: {
                this._open();
                break;
            }
            case 2: {
                this._exit();
                break;
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.dirty) {
            this.dirty = true;
        }
    }
}

