/*======================================================================*/
/* genfun.h: general functions											*/
/*======================================================================*/
/* COPYRIGHT 1992-2002 Jean-Pierre MENICUCCI - All rights reserved		*/
/*======================================================================*/

#define GET_WM_COMMAND_ID(a,b) LOWORD(a)
#define GET_WM_COMMAND_CMD(a,b) HIWORD(a)
#define GET_WM_COMMAND_THUMB(a,b) HIWORD(a)
#define PUT_WM_COMMAND_CMD(a,b,c) a=MAKEWPARAM(LOWORD(a),c)

#define CharToByte(a,b,c) {int n; for(n=0;n<c;n++) a[n]=LOBYTE(*(b+n)); }
#define ByteToChar(a,b,c) {int n; for(n=0;n<c;n++) a[n]=b[n]; }
#define CharSize(a) sizeof(a)/sizeof(TCHAR)
#define Zero(a) ZeroMemory(&a,sizeof(a))

#define GEN_ERRALLOC -1					// could not allocate memory
#define GEN_ERRLOCK	-2 					// could not lock memory
#define GEN_ERROPEN	-3					// could not open file
#define GEN_ERRREAD	-4					// could not read file
#define GEN_ERRSEC -5					// section does not exist

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* string handling functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* Upper: set a character to uppercase									*/
/* return:																*/
/*		uppercase character												*/
/*======================================================================*/

unsigned char Upper (
	unsigned char c						// character to set as uppercase
	);

/*======================================================================*/
/* Lower: set a character to lowercase									*/
/* return:																*/
/*		lowercase character												*/
/*======================================================================*/

unsigned char Lower (
	unsigned char c						// charater to set as lowercase
	);

/*======================================================================*/
/* mCpy: copying a string to another									*/
/* return:																*/
/*		offset															*/
/*======================================================================*/

int __inline mCpy (
	LPTSTR lpOut,						// output string
	int mOut,							// output string size
	LPCTSTR lpIn						// input string
	)
{
	int nOff;							// offset in output string

	mOut -= 1;							// end-of-string character

	if (mOut <= 0)						// negative or null sized string
		return 0;

	for (nOff = 0; *lpIn && nOff < mOut; nOff++, lpIn++)
		*(lpOut + nOff) = *lpIn;

	*(lpOut + nOff) = '\0';				// end-of-string character

	return nOff;						// offset
}

/*======================================================================*/
/* mCat: concatenating two strings										*/
/* return:																*/
/*		new offset														*/
/*======================================================================*/

int __inline mCat (
	LPTSTR lpOut,						// output string
	int mOut,							// output string size
	int nOff,							// offset in output string
	LPCTSTR lpIn						// input string
	)
{
	mOut -= 1;							// end-of-string character

	if (mOut <= 0)						// negative or null sized string
		return 0;

	for (; *lpIn && nOff < mOut; nOff++, lpIn++)
		*(lpOut + nOff) = *lpIn;

	*(lpOut + nOff) = '\0';				// end-of-string character

	return nOff;						// new offset
}

/*======================================================================*/
/* nCpy: copying a string to another									*/
/* return:																*/
/*		string length													*/
/*======================================================================*/

int __inline nCpy (
	LPTSTR lpOut,						// output string
	LPCTSTR lpIn,						// input string
	int nIn								// copy length
	)
{
	for (int n = 0; n < nIn; n++)		// copy
		*(lpOut++) = *(lpIn++);

	return nIn;							// length
}

/*======================================================================*/
/* nCat: concatenating two strings										*/
/* return:																*/
/*		string length after concatenation								*/
/*======================================================================*/

int __inline nCat (
	LPTSTR lpOut,						// output string
	int nOffset,						// initial length
	LPCTSTR lpIn,						// input string
	int nIn								// length to copy
	)
{
	lpOut += nOffset;					// initial length

	for (int n = 0; n < nIn; n++)
		*(lpOut++) = *(lpIn++);			// copy

	return (nOffset + nIn);				// new length
}

/*======================================================================*/
/* nmCpy: copying a string to another									*/
/* return:																*/
/*		string length													*/
/*======================================================================*/

int __inline nmCpy (
	LPTSTR lpOut,						// output string
	int mOut,							// output string size
	LPCTSTR lpIn,						// input string
	int nIn								// length to copy
	)
{
	mOut--;								// end-of-string character
	if (mOut < 0)						// negative or null sized string
		return 0;

	for (int n = 0; n < nIn && n < mOut; n++)
		*(lpOut++) = *(lpIn++);			// copy

	*lpOut = '\0';						// end-of-string character

	return n;							// length
}

/*======================================================================*/
/* nmCat: concatenating two strings										*/
/* return:																*/
/*		string length after concatenation								*/
/*======================================================================*/

int __inline nmCat (
	LPTSTR lpOut,						// output string
	int mOut,							// output string size
	int nOffset,						// initial length
	LPCTSTR lpIn,						// input string
	int nIn								// length to copy
	)
{
	mOut -= nOffset - 1;				// length - offset
	if (mOut < 0)						// negative or null sized string
		return nOffset;

	lpOut += nOffset;					// pointer + offset

	for (int n = 0; n < nIn && n < mOut; n++)
		*(lpOut++) = *(lpIn++);			// copy

	*lpOut = '\0';						// end-of-string character

	return (nOffset + n);				// new length
}

/*======================================================================*/
/* nCmp: comparing two strings											*/
/* return:																*/
/*		-1		string 1 < string 2										*/
/*		0		string 1 == string 2									*/
/*		1		string 1 > string 2										*/
/*======================================================================*/

int __inline nCmp (
	LPCTSTR lpIn1,						// string 1
	LPCTSTR lpIn2,						// string 2
	int nIn								// length to compare
	)
{
	for (int n = 0; n < nIn; lpIn1++, lpIn2++, n++) {
		if (*lpIn1 < *lpIn2)
			return -1;					// lower
		if (*lpIn1 > *lpIn2)
			return 1;					// higher
		}
	return 0;							// equal
}

/*======================================================================*/
/* niCmp: comparing two strings ignoring case							*/
/* return:																*/
/*		-1		string 1 < string 2										*/
/*		0		string 1 == string 2									*/
/*		1		string 1 > string 2										*/
/*======================================================================*/

int __inline niCmp (
	LPCTSTR lpIn1,						// string 1
	LPCTSTR lpIn2,						// string 2
	int nIn								// length to compare
	)
{
	for (int n = 0; n < nIn; lpIn1++, lpIn2++, n++) {
		if (Upper (*lpIn1) < Upper (*lpIn2))
			return -1;					// lower
		if (Upper (*lpIn1) > Upper (*lpIn2))
			return 1;					// higher
		}
	return 0;							// equal
}

/*======================================================================*/
/* Chr: search for a character											*/
/* return:																*/
/*		character address in string										*/
/*======================================================================*/

LPTSTR __inline Chr (
	LPCTSTR lp,							// string
	TCHAR c								// character
	)
{
	LPTSTR lq;
	for (; lp && *lp; lp++)
		if (*lp == c) {
			lq = (LPTSTR) lp;
			return lq;
			}
	return 0;
}

/*======================================================================*/
/* rChr: reverse search for a character									*/
/* return:																*/
/*		character address in string										*/
/*======================================================================*/

LPTSTR __inline rChr (
	LPCTSTR lp,							// string
	TCHAR c								// character
	)
{
	LPTSTR lq = 0;
	for (; lp && *lp; lp++)
		if (*lp == c)
			lq = (LPTSTR) lp;
	return lq;
}

/*======================================================================*/
/* Upper: set a string to uppercase										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Upper (
	LPTSTR lp,							// string to uppercase
	int n								// string length
	);

/*======================================================================*/
/* Lower: set a string to lowercase										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Lower (
	LPTSTR lp,							// string to lowercase
	int n								// string length
	);

/*======================================================================*/
/* Invert: invert case in a string										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Invert (
	LPTSTR lp,							// string to lowercase
	int n								// string length
	);

/*======================================================================*/
/* Capitalize: capitalize words											*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Capitalize (
	LPTSTR lp,							// string to uppercase
	int n								// string length
	);

/*======================================================================*/
/* Lengthen: adding spaces to a string									*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Lengthen (
	LPTSTR lpOut,						// string to lengthen
	long nOut,							// initial length
	long mOut							// size
	);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* string transcoding functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* hexbin: hexadecimal to binary										*/
/* return:																*/
/*		output string length											*/
/*======================================================================*/

int hexbin (
	unsigned char *pIn,					// hexadecimal input
	int nIn,							// input length
	unsigned char *pOut					// binary output
	);

/*======================================================================*/
/* binhex: binary to hexadecimal										*/
/* return:																*/
/*		output string length											*/
/*======================================================================*/

int binhex (
	unsigned char *pIn,					// binary input
	int lIn,							// input length
	LPTSTR lpOut						// hexadecimal output
	);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*///////////////////////////////////////////////////////////////////////*/
/* string delimiting functions											 */
/*///////////////////////////////////////////////////////////////////////*/
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* These functions help in reading parameter files containing delimiters */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* Point: pointing the character after a delimiter						*/
/* return:														 		*/
/*		length skipped											 		*/
/*======================================================================*/
/* Point takes on input a pointer to a string pointer and a delimiter.	*/
/* On output, the string pointer will point to the character after		*/
/* the delimiter. The number of characters skipped is returned			*/
/*======================================================================*/

int Point (
	LPTSTR *lpIn,						// input string
	TCHAR cDel							// delimiter
	);

/*======================================================================*/
/* Pull: extracting a delimited substring								*/
/* return:																*/
/*		extracted length												*/
/*======================================================================*/
/* Pull extracts the characters contained between the initial position	*/
/* of the pointer and the delimiter. The excess characters are not		*/
/* taken into account													*/
/*======================================================================*/

int Pull (
	LPTSTR *lpIn,						// input string
	LPTSTR lpOut,						// output string
	int mOut,							// output size
	TCHAR cDel							// delimiter
	);

/*======================================================================*/
/* Pulls: extracting a delimited substring								*/
/* return:																*/
/*		extracted length												*/
/*======================================================================*/
/* Pull extracts the characters contained between the initial position	*/
/* of the pointer and one of the possible delimiters. The excess		*/
/* characters are not taken into account								*/
/*======================================================================*/

int Pulls (
	LPTSTR *lpIn,						// input string
	LPTSTR lpOut,						// output string
	int mOut,							// output size
	LPTSTR lpDel						// delimiters
	);

/*======================================================================*/
/* Special: introduce special characters in strings						*/
/* return:																*/
/*		resulting length												*/
/*======================================================================*/

int Special (
	LPTSTR lpOut,						// string out
	LPTSTR lpIn							// string in
	);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* registry functions													*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* GetDword: get dword value from registry								*/
/* return:																*/
/*		DWORD															*/
/*======================================================================*/

DWORD GetDword (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	DWORD		dwDef = 0				// default
	);

/*======================================================================*/
/* GetLpstr: get Lpstr value from registry								*/
/* return:																*/
/*		Lpstr															*/
/*======================================================================*/

void GetLpstr (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	LPTSTR		lpszValue,				// value
	ULONG		uValue,					// value size
	LPCTSTR		lpszDef = NULL			// default
	);

/*======================================================================*/
/* GetCstring: get Cstring value from registry							*/
/* return:																*/
/*		Cstring															*/
/*======================================================================*/

CString GetCstring (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	LPCTSTR		lpszDef = NULL			// default
	);

/*======================================================================*/
/* SetDword: set dword value into registry								*/
/* return:																*/
/*		TRUE							// success						*/
/*		FALSE							// failure						*/
/*======================================================================*/

BOOL SetDword (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	DWORD		dwDword					// DWORD value
	);

/*======================================================================*/
/* SetLpstr: set Lpstr value into registry								*/
/* return:																*/
/*		TRUE							// success						*/
/*		FALSE							// failure						*/
/*======================================================================*/

BOOL SetLpstr (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	LPCTSTR		lpszData				// value
	);

/*======================================================================*/
/* CloseKeys: close a key list											*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void CloseKeys (
	void								// no argument
	);

/*======================================================================*/
/* ReadValue: get a subkey value										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long ReadValue (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPTSTR		lpszValueName,			// address of name of value to query
	DWORD		dwType,					// value type
	LPBYTE		lpbData,				// address of data buffer
	DWORD		cbData					// data buffer size
	);

/*======================================================================*/
/* WriteValue: set a subkey value										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long WriteValue (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPTSTR		lpszValueName,			// address of name of value to query
	DWORD		dwType,					// value type
	LPBYTE		lpbData,				// address of data buffer
	DWORD		cbData					// data buffer size
	);

/*======================================================================*/
/* DeleteKey: 															*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long DeleteKey (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPCTSTR		lpszSubKey				// key to delete
	);

/*======================================================================*/
/* DeleteSubtree:														*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long DeleteSubtree (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPCTSTR		lpszSubKey				// key to delete
	);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* dialogs centering functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* These functions are called during the WM_INITDIALOG processing, that	*/
/* is to say, before the actual dialog displaying. They afford a		*/
/* correct dialog centering whatever the resolution						*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* DownDialog: displaying a dialog on the window bottom					*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void DownDialog (
	HWND hwApp,							// application window handle
	HWND hwDia,							// dialog window handle
	int cyStatus						// status bar height
	);

/*======================================================================*/
/* CenterDialog: displaying a dialog at the center of the window		*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void CenterDialog (
	HWND hwApp,							// application window handle
	HWND hwDia							// dialog window handle
	);

/*======================================================================*/
/* CenterDialog: displaying a dialog at the center of the screen		*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void CenterDialog (
	HWND hw								// dialog window handle
	);

/*======================================================================*/
/* DDX_CBList: handle a combo box list									*/
/* return:																*/
/*		TRUE							// success						*/
/*		FALSE							// failure						*/
/*======================================================================*/

void AFXAPI DDX_CBList (
	CDataExchange* pDX,					// data exchange pointer
	int nIDC,							// control Id
	CString& csList						// data
	);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* file handling functions												*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* FileLength: getting the size of a file								*/
/* return:																*/
/*		file size														*/
/*======================================================================*/

long FileLength (
	HFILE hFile							// file handle
	);

/*======================================================================*/
/* Relative: relative path of a file from the current directory			*/
/* return:																*/
/*		pointer to the relative path									*/
/*======================================================================*/

LPTSTR Relative (
	LPTSTR lpszFilePath					// file path
	);

/*======================================================================*/
/* SplitPath: splitting a file name into items							*/
/* return:																*/
/*		void															*/
/*======================================================================*/
/* SplitPath takes a complete file path on input and returns pointers	*/
/* to directory, file name and extension								*/
/*======================================================================*/

void SplitPath (
	LPTSTR lpszPath,					// complete file path
	LPTSTR *lpszDir,					// directory
	LPTSTR *lpszName,					// file name
	LPTSTR *lpszExt						// extension
	);

/*======================================================================*/
/* SplitPath: splitting a file name into items							*/
/* return:																*/
/*		void															*/
/*======================================================================*/
/* SplitPath takes a complete file path on input and returns offsets	*/
/* to the directory chain string, file name and suffix					*/
/*======================================================================*/

void SplitPath (
	LPCTSTR lpszPath,					// complete file path
	int *iPath,							// directory chain offset
	int *iRadical,						// file name offset
	int *iSuffix						// file suffix offset
	);

/*======================================================================*/
/* SetFilePath: set full file path from directory path and file name	*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void SetFilePath (
	LPTSTR lpszFilePath,				// full file path
	LPCTSTR lpszPathName,				// directory path
	LPCTSTR lpszFileName				// file name
	);

/*======================================================================*/
/* FileRead: reading a file into a buffer								*/
/* return:																*/
/*		0				buffer allocated and file read					*/
/*		GEN_ERROPEN		could not open file								*/
/*		GEN_ERRALLOC	could not allocate memory						*/
/*		GEN_ERRLOCK		could not lock memory							*/
/*		GEN_ERRREAD		could not read file								*/
/*======================================================================*/
/* FileRead allocates memory and stores the file into it				*/
/*======================================================================*/

int FileRead (
	LPCTSTR lpszFilePath,				// file path
	HGLOBAL *hBuf,						// allocated memory handle
	LPTSTR *lpBuf						// accessed memory pointer
	);

/*======================================================================*/
/* CreatePath: creating a directory path								*/
/* return:																*/
/*		0		ok														*/
/*		#0		GetLastError()											*/
/*======================================================================*/

DWORD CreatePath (
	LPTSTR lpszDirPath			// file path
	);

/*======================================================================*/
/* CreateShortcut: creating a shortcut to a file						*/
/* return:																*/
/*				0				shortcut created						*/
/*				# 0				ko										*/
/*======================================================================*/

HRESULT CreateShortcut (
	LPTSTR		lpszFile,		// pointer to original file name
	LPTSTR		lpszLink,		// pointer to new link name
	LPTSTR		lpszDesc,		// pointer to description
	LPTSTR		lpszArgs,		// pointer to arguments
	LPTSTR		lpszIcon,		// pointer to icon file
	int			nIcon			// icon index
	);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* profile file handling functions										*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* FindProfileSection: finding the beginning of a section				*/
/* return:																*/
/*		0			ok													*/
/*		GEN_ERRSEC	ko - section not found								*/
/*======================================================================*/
/* FindProfileSection finds the section's first line's first character	*/
/*======================================================================*/

int FindProfileSection (
	LPTSTR lpszSecName,					// section name
	BOOL bRequired,						// section required
	LPTSTR lpBuf,						// pointer to profile buffer
	int *nOffBeg						// offset to section beginning
	);

/*======================================================================*/
/* GetProfileLine: reading a profile line								*/
/* return:																*/
/*		0		end-of-profile											*/
/*		#0		offset to the next line									*/
/*======================================================================*/
/* GetProfileLine gets the current profile line. If this line contains	*/
/* an = delimiter, it is split into a left part and a right part. Else, */
/* the left part contains the whole line								*/
/*======================================================================*/

int GetProfileLine (
	LPTSTR lpBuf,						// pointer to the current line
	int *lLef,							// left part length
	LPTSTR *lpRig,						// pointer to right part
	int *lRig							// right part length
	);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* message handling functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* StrMesBox: displaying a message box with a string parameter			*/
/* return:																*/
/*		identifier of the button pressed on quiting the message box		*/
/*======================================================================*/
/* The message is generated after a formatting string contained in		*/
/* nMessage and a string parameter contained in lpszString				*/
/*======================================================================*/

int StrMesBox (
	int nMessage,				// formatting message number
	LPCTSTR lpszString,			// string parameter
	UINT fuStyle				// dialog buttons
	);

/*======================================================================*/
/* SysMesBox: displaying a message box with a system error message		*/
/* return:																*/
/*		identifier of the button pressed on quiting the message box		*/
/*======================================================================*/
/* The message is generated after a formatting string contained in		*/
/* nMessage and a string parameter contained in lpszString				*/
/*======================================================================*/

int SysMesBox (
	int nMessage,				// formatting message number
	LPCTSTR lpszString,			// string parameter
	UINT fuStyle				// dialog buttons
	);
