{******************************************************}
{ which v1.0.1                                         }
{ Copyright (c) 1998-1999 Magnus Bck                  }
{ baeck@swipnet.se                                     }
{ http://www.jpl.nu/~magnus/misc.html                  }
{******************************************************}
{ This software may be distributed and modified freely }
{ as long as the original copyright is not removed and }
{ no profit is made from it.                           }
{******************************************************}

program which;

uses
  Windows,
  SysUtils;

{$R *.RES}

const
	AppName        = 'which';
	Version        = 'v1.0.1';
	Copyright      = 'Copyright (c) 1998-1999 Magnus Bck';
	OptsEnvName    = 'WHICH_OPTS';

var
	Found, CurrDir, LookFor: string;
	Env, Opts: PChar;
	Verbose: Boolean;
	I: Integer;

begin
	if ParamStr(1) = '/?' then
	begin
		Writeln(Format('%s %s %s', [AppName, Version, Copyright]));
		Writeln;
		Writeln('Syntax: which [/V] <filename>');
		Writeln;
		Writeln('where <filename> is the file you want to find.');
		Writeln('If no extension is given, .exe is assumed.');
		Writeln;
		Writeln('/V causes verbose output with the complete search path');
		Writeln('   if the <filename> is not found.');
		Halt(0);
	end;
	Verbose := False;
	LookFor := '';
	for I := 1 to ParamCount do
	begin
		if AnsiUpperCase(ParamStr(I)) = '/V' then
			Verbose := True
		else if Copy(AnsiUpperCase(ParamStr(I)), 1, 1) = '/' then
		begin
			Writeln('which: Syntax incorrect, use /? for help.');
			Halt(1);
		end
		else
			LookFor := ParamStr(I);
	end;
	SetFileApisToOEM;
	if (ExtractFileExt(LookFor) = '') and (LookFor[Length(LookFor)] <> '.') then
		LookFor := LookFor + '.exe';
	GetMem(Env, 4096);
	try
		GetEnvironmentVariable('PATH', Env, 4096);
		Found := FileSearch(LookFor, StrPas(Env));
		if Found = '' then
		begin
			GetMem(Opts, 1024);
			try
				GetEnvironmentVariable(OptsEnvName, Opts, 1024);
				Verbose := Verbose or (Pos('VERBOSE', AnsiUpperCase(StrPas(Opts))) > 0);
				if Verbose then
					Writeln(Format('%s: No %s in (%s)', [AppName, LookFor, Env]))
				else
					Writeln(Format('%s not found', [LookFor]));
			finally
				FreeMem(Opts);
			end;
			Halt(1);
		end
		else if Found = LookFor then
		begin
			GetDir(0, CurrDir);
			if CurrDir[Length(CurrDir)] = '\' then
				Found := CurrDir + Found
			else
				Found := CurrDir + '\' + Found;
		end;
		Writeln(Found);
	finally
		FreeMem(Env);
	end;
end.
