#include <windows.h>
#include <ddeml.h>
#include <dde.h>
#include <stdio.h>
#include <string.h>

#include "filefuncs.h"
#include "ddemlfuncs.h"
#include "sticky.h"

// GLobal DDE server
DWORD DDEHandle = NULL;
HSZ   HDDEService;
HSZ   HDDETopic;
HSZ   HDDEItem;

// ----------------------------------------------------------------------------

BOOL DDE_InitServer (void)
{        
    UINT errCode = DdeInitialize (&DDEHandle, (PFNCALLBACK)DDECallback, APPCLASS_STANDARD, 0L);
    if (errCode != 0)
    {
        char errTxt[32];

        sprintf (errTxt, "DDE Server Failed, error code = %d", errCode);

        MessageBox (NULL, "ERROR Initialising DDE Server.\r\n"
                          "Server communication is through e-mail is not available.",
                          errTxt, MB_ICONSTOP | MB_OK);
        return FALSE;
    }
    else
    {
        HDDEService = DdeCreateStringHandle (DDEHandle, DDE_SERVICE, CP_WINANSI);
        HDDETopic   = DdeCreateStringHandle (DDEHandle, DDE_TOPIC,   CP_WINANSI);
        HDDEItem    = DdeCreateStringHandle (DDEHandle, DDE_ITEM,    CP_WINANSI);

        DdeNameService (DDEHandle, HDDEService, (HSZ) NULL, DNS_REGISTER);
    }

    return TRUE;
}

// ----------------------------------------------------------------------------

void DDE_UninitServer (void)
{
    if (DDEHandle != NULL)
    {
        DdeFreeStringHandle (DDEHandle, HDDEService);
        DdeFreeStringHandle (DDEHandle, HDDETopic);
        DdeFreeStringHandle (DDEHandle, HDDEItem);
        DdeUninitialize     (DDEHandle);
    }
}

// ----------------------------------------------------------------------------

void MakeNewEMAILSticky (char* pData, int dataLen)
{    
    int   wndIdx = GetNextStickyFree ();  

    if (wndIdx < 0)
    {
        MessageBox (NULL, "Can't Create Any More Stickies", 
                    "Out Of Array Space", MB_ICONSTOP | MB_OK);
        return;
    }

    // Check the ID Size    
    if (dataLen < (int)strlen(EXPORTVERSION15))
        goto TextFormat;

    // TODO : Conversion function required ....
    if ((memcmp (pData, EXPORTVERSION15, strlen(EXPORTVERSION15)) == 0) ||
        (memcmp (pData, EXPORTVERSION16, strlen(EXPORTVERSION16)) == 0))
    {        
        if (memcmp (pData, EXPORTVERSION15, strlen(EXPORTVERSION15)) == 0)
        {
            StickyRecFMT15 oldFmt;

            pData += strlen(EXPORTVERSION15);
            memcpy (&oldFmt, pData, sizeof (oldFmt));
            Convert15to16 (&StickyRecords[wndIdx], &oldFmt);
            pData += sizeof (oldFmt);
        }
        else        
        {
            pData += strlen(EXPORTVERSION16);        
            memcpy (&StickyRecords[wndIdx], pData, sizeof (StickyRecords[wndIdx]));
            pData += sizeof (StickyRecords[wndIdx]);
        }

        // Load sticky window info from memory        
        StickyRecords[wndIdx].editControl = NULL;
        StickyRecords[wndIdx].stickyWnd   = NULL;
        StickyRecords[wndIdx].hFont       = NULL;
        StickyRecords[wndIdx].backGH      = NULL;

        // Load string 
        if (StickyRecords[wndIdx].userMemo.strLen > 0)
        {
            // Allocate the required memory.
            StickyRecords[wndIdx].userMemo.pString = new char[StickyRecords[wndIdx].userMemo.strLen+1];

            if (StickyRecords[wndIdx].userMemo.pString != NULL)
            {
                // Load string data from memory.                          
                strcpy (StickyRecords[wndIdx].userMemo.pString, pData);
                StickyRecords[wndIdx].userMemo.strLen = strlen (StickyRecords[wndIdx].userMemo.pString);
            }
        }
        else
           StickyRecords[wndIdx].userMemo.pString = NULL;

        goto LoadTheSticky;
    }

TextFormat:
    if (dataLen < (int)strlen(EXPORTDDE))
        goto UnkownFormat;
        
    if (memcmp (pData, EXPORTDDE, strlen(EXPORTDDE)) == 0) 
    {   
        char* pNextHunk;
        char* pLimit = pData + dataLen;

        // Initialise the new sticky.
        StickyRecords[wndIdx] = StickyRecords[STICKRECNUM];

        pData += strlen(EXPORTDDE);
        pNextHunk = pData;
        while ((*pNextHunk != '\n') && (pNextHunk < pLimit))
            pNextHunk++;

        // Copy title
        if (pNextHunk < pLimit)
        {
            int captionSize = (pNextHunk - pData);

            if (captionSize > CAPTIONSIZE)
                captionSize = 50;

            // Copy and terminate string.
            memcpy (StickyRecords[wndIdx].winCaption, pData, captionSize);
            StickyRecords[wndIdx].winCaption[captionSize] = '\0';

            // Remove any control characters
            for (int idx = 0; idx < captionSize; idx++)
            {
                if ((StickyRecords[wndIdx].winCaption[idx] < ' ') ||
                    (StickyRecords[wndIdx].winCaption[idx] > '~'))
                    StickyRecords[wndIdx].winCaption[idx] = ' ';
            }

            // And add rest of the buffer to as the sticky text body
            pData = pNextHunk+1;
            
            // Allocate the required memory.
            StickyRecords[wndIdx].userMemo.strLen  = (pLimit-pData)+1;
            StickyRecords[wndIdx].userMemo.pString = new char[StickyRecords[wndIdx].userMemo.strLen];
            if (StickyRecords[wndIdx].userMemo.pString != NULL)
            {
                memcpy (StickyRecords[wndIdx].userMemo.pString,
                        pData,
                        StickyRecords[wndIdx].userMemo.strLen);

                StickyRecords[wndIdx].userMemo.pString[StickyRecords[wndIdx].userMemo.strLen] = '\0';
            }
        }                
        goto LoadTheSticky;
    }        

UnkownFormat:
    // Initialise the new sticky.
    StickyRecords[wndIdx] = StickyRecords[STICKRECNUM];

    strcpy (StickyRecords[wndIdx].winCaption, "Unknown sticky format");
               
    // Allocate the required memory.
    StickyRecords[wndIdx].userMemo.pString = new char[dataLen+1];

    // Load string data from file.
    if (StickyRecords[wndIdx].userMemo.pString != NULL)
        strcpy (StickyRecords[wndIdx].userMemo.pString, pData);
        
    StickyRecords[wndIdx].userMemo.strLen = strlen (StickyRecords[wndIdx].userMemo.pString);

LoadTheSticky:
    // Create the sticky !    
    LoadSticky (ParentStarter, wndIdx, TRUE);
}

// ----------------------------------------------------------------------------

HDDEDATA CALLBACK DDECallback (WORD wType, WORD wFmt,      HCONV hConv,   HSZ   hsz1,
                               HSZ  hsz2,  HDDEDATA hData, DWORD dwData1, DWORD dwData2)
{
    char* pData;
    DWORD dataLen;
    
    switch (wType)
    {
        case XTYP_CONNECT:
            if (hsz2 == HDDEService)
               return (HDDEDATA) TRUE;

            return (HDDEDATA) FALSE;

            // A call from explorer to import a sticky file.
        case XTYP_EXECUTE:
            // Access the explorer data.
            if ((pData = (char*)DdeAccessData (hData, &dataLen)) != NULL)
            {
                ImportStickyFile  (pData);
                DdeFreeDataHandle (hData);
            }            
            return (HDDEDATA) DDE_FACK;

        case XTYP_POKE:
            if (hsz1 == HDDETopic)
            {                
                // Access the sticky data.
                if ((pData = (char*)DdeAccessData (hData, &dataLen)) != NULL)
                {
                    MakeNewEMAILSticky (pData, dataLen);
                    DdeFreeDataHandle (hData);
                    return (HDDEDATA) DDE_FACK;    
                }
                else
                {
                    MessageBox (NULL, "Unable to access E-MAIL sticky data.",
                                      "ERROR: Unable to access E-Mail data", 
                                      MB_ICONINFORMATION | MB_OK);
                }              
            }
            return (HDDEDATA) NULL;
    }

    return (HDDEDATA) NULL;
}