unit Unit2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, GraphLnk, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    GL1: TGraphLink;
    Sh: TShape;
    GL2: TGraphLink;
    Image1: TImage;
    Shape1: TShape;
    Timer1: TTimer;
    Label1: TLabel;
    Memo1: TMemo;
    ListBox1: TListBox;
    Label2: TLabel;
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure GL2ControlShape(Sender: TObject; Place: TControlPlace;
      Target: TControl; var Shape: TShapeType);
    procedure ListBox1Click(Sender: TObject);
    procedure GL1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetControlShape;
  end;

var
  Form1: TForm1;
  ImShape: TShapeType;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
GL1.StartPoint:=Point(60,60);
GL1.EndPoint:=Point(60,120);
GL1.Points.AddPoint(120,120);
GL1.Points.AddPoint(170,170);

GL2.StartControl:=Image1;
GL2.EndControl:=Shape1;
GL2.BringToFront;
ImShape:=stRectangle;
ListBox1.ItemIndex:=0;

Timer1.Enabled:=True;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var P: TPoint;
begin
P:=GL1.GetNearestEdgePoint(Point(X-Panel1.Left,Y-Panel1.Top));
{
ShowMessage(IntToStr(X)+' '+IntToStr(Y)+' '+
            IntToStr(P.X)+' '+IntToStr(P.Y));
}
with Sh do begin
  Top:=P.Y - Height div 2;
  Left:=P.X - Width div 2;
  end;
end;

procedure TForm1.Panel1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var P: TPoint;
begin
P:=GL1.GetNearestEdgePoint(Point(X,Y));
{
ShowMessage(IntToStr(X)+' '+IntToStr(Y)+' '+
            IntToStr(P.X)+' '+IntToStr(P.Y));
}
with Sh do begin
  Top:=P.Y - Height div 2;
  Left:=P.X - Width div 2;
  end;
end;

procedure TForm1.GL1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var P: TPoint;
begin
P:=GL1.GetNearestEdgePoint(Point(X+GL1.Left,Y+GL1.Top));
with Sh do begin
  Top:=P.Y - Height div 2;
  Left:=P.X - Width div 2;
  end;
end;

procedure TForm1.SetControlShape;
begin
with ListBox1 do begin
  if Items[ItemIndex] = 'stRectangle' then
    ImShape:=stRectangle
  else if Items[ItemIndex] = 'stEllipse' then
    ImShape:=stEllipse
  else if Items[ItemIndex] = 'stCircle' then
    ImShape:=stCircle;
  end;
GL2.UpdateLink;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
with ListBox1 do begin
  if ItemIndex < (Items.Count - 1) then
    ItemIndex:=ItemIndex + 1
  else
    ItemIndex:=0;
  end;
SetControlShape;
end;

procedure TForm1.GL2ControlShape(Sender: TObject; Place: TControlPlace;
  Target: TControl; var Shape: TShapeType);
begin
if Place=cpStart then begin
  Shape:=ImShape;
  end;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
begin
Timer1.Enabled:=False;
SetControlShape;
end;

end.
 