
{******************************************}
{                                          }
{       "Handle of HTML Form Upload"       }
{                                          }
{       Copyright (c) 2000 AriseSoft       }
{                                          }
{******************************************}

(*
  TAS_FormUpload version 1.0
  --------------------------

  e-mail:     combocontrol@iname.com
  home page:  http://www.combocontrol.cjb.net/

  This unit is a "promotionware": you are free to use it
  as you wish in any projects, however we ask you to visit our website
  and read about our other nice products. Chances are, you'll get
  an extra bonus - right from our home page :-)

  It is example of HTML Form Upload ("multipart/form-data" MIME type - RFC 1867)
  for Delphi developers who create isapi-dll. Now you can
  uploading files from the web and store it in a custom database.
  (~60 KB limit of upload size).

  HTML-code:
---
<html><head><title>File upload</title></head><body>
  <form action="demo.dll/upload" method="post" enctype="multipart/form-data">
    <input type="file" name="file">
    <input type="submit" value="Upload">
  </form>
</body></html>
---

  Demo of Web Server:
---
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, HTTPApp, AS_FormUpload;

type
  TWeb = class(TWebModule)
    procedure WebItemUploadAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebItemDownloadAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
  private
    FStoredContentData: string;
    FStoredContentType: string;
  public
    { Public declarations }
  end;

var
  Web: TWeb;

implementation

{$R *.DFM}

procedure TWeb.WebItemUploadAction(Sender: TObject; Request: TWebRequest;
  Response: TWebResponse; var Handled: Boolean);
var
  FormUpload: TAS_FormUpload;
begin
  FormUpload := TAS_FormUpload.Create(Request.ContentType, Request.Content);
  try
    FStoredContentData := FormUpload.ContentData;
    FStoredContentType := FormUpload.ContentType;
    Response.Content := Format('File: %s has been uploaded.', [FormUpload.FileName]);
  finally
    FormUpload.Free;
  end;
end;

procedure TWeb.WebItemDownloadAction(Sender: TObject; Request: TWebRequest;
  Response: TWebResponse; var Handled: Boolean);
var
  ContentStream: TStringStream;
begin
  Response.ContentType := FStoredContentType;
  ContentStream := TStringStream.Create(FStoredContentData);
  ContentStream.Position := 0;
  Response.ContentStream := ContentStream;
  { ^ note: do not free the stream because the response object
    will handle that task }
end;

end.
---
*)

unit AS_FormUpload;

{$I AS_Ver.inc}

interface

uses
  Classes, SysUtils;

type
  TAS_FormUpload = class(TObject)
    FFileName: string;
    FContentType: string;
    FContentData: string;
  public
    constructor Create(const ContentType, Content: string); virtual;
    property FileName: string read FFileName;
    property ContentType: string read FContentType;
    property ContentData: string read FContentData;
  end;

implementation

{ TAS_FormUpload }

function FindSubString(Strings: TStrings; SubStr: PChar; var Index: Integer): Boolean;
{ ^ note: copied from AS_VCLUtils }
var
  I: Integer;
begin
  Result := False;
  for I := Index to Pred(Strings.Count) do
    if AnsiPos(SubStr, PChar(Strings[I])) > 0 then
    begin
      Index := I;
      Result := True;
      Exit;
    end;
end;

constructor TAS_FormUpload.Create(const ContentType, Content: string);
const
  SBoundary = 'boundary=';
  SFileName = 'filename=';
var
  StringList: TStringList;
  S: string;
  I: Integer;
  Boundary: string;
begin
  inherited Create;
  //if Pos('multipart/form-data', ContentType) = 0 then
  //  raise Exception.Create('ContentType header must be "multipart/form-data"');
  I := Pos(SBoundary, ContentType) + Length(SBoundary);
  Boundary := Copy(ContentType, I, Length(ContentType) - Pred(I));
  //if Boundary = '' or Length(Content) = 0 then 
  //  raise Exception.Create('Invalid information about upload');
  I := Pos(#13#10#13#10, Content) + 4;
  Boundary := #13#10 + '--' + Boundary + '--';
  FContentData := Copy(Content, I, Pos(Boundary, Content) - I);
  StringList := TStringList.Create;
  try
    StringList.Text := Copy(Content, 1, I);;
    { note: set FileName }
    I := 1;
    if FindSubString(StringList, 'Content-Disposition:', I) then
    begin
      S := StringList[I];
      I := Pos(SFileName, S);
      if I > 0 then
      begin
        Inc(I, Length(SFileName) + 1);
        while S[I] <> '"' do
        begin
          FFileName := FFileName + S[I];
          Inc(I);
        end;
      end;
    end;
    { note: set ContentType }
    I := 1;
    if FindSubString(StringList, 'Content-Type:', I) then
    begin
      S := StringList[I];
      I := Pos(' ', S);
      Delete(S, 1, I);
      FContentType := S;
    end;
  finally
    StringList.Free;
  end;
end;

end.
