// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to test gxsHTML classes. 
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include "gxshtml.h"
#include "gxs_ver.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Version number and program name
const double ProgramVersionNumber = gxSocketVersion;
const char *ProgramName = "gxsHTML test program";

// Program globals
int parsing_tags = 0;
int listing_doc_tags = 0;
int listing_supported_tags = 0;

int CopyToMemory(const char *fname, MemoryBuffer &membuf)
{
  membuf.Clear();
  const unsigned buf_size = 32767;
  unsigned i, len;
  char sbuf[buf_size];
  DiskFileB f;
  int rv = f.df_Open(fname , DiskFileB::df_READONLY, DiskFileB::df_NO_CREATE);
  if(rv) return rv;

  while(!f.df_EOF()) {
    for(i = 0; i < buf_size; i++) sbuf[i] = '\0';
    rv = f.df_Read((char *)sbuf, buf_size);
    if(rv) return rv;
    len = strlen(sbuf);
    membuf.Cat((char *)sbuf, len);
  }

  return 0;
}

void ParseTags(const char *fname)
{
  gxsHTML html;
  cout << endl;
  cout << "Parsing " << fname << endl;
  if(html.LoadHTMLFile(fname) != 0) {
    html.DiskFileExceptionMessage();
    return;
  }
  
  cout << "Found " << html.NumTags() << " tags" << endl;

  cout << endl;
  cout << "Parsing in-memory copy of " << fname << endl;
  MemoryBuffer membuf;
  if(CopyToMemory(fname, membuf) != 0) {
    html.DiskFileExceptionMessage();
    return;
  }

  if(html.LoadMemoryBuffer(membuf) != 0) {
    cout << "A memory error occurred" << endl;
    return;
  }
  cout << "Found " << html.NumTags() << " tags" << endl;
  cout << endl;
}

void PrintTagInfo(const gxsHTMLTagInfo &t)
{
  cout << "----- Tag's file information-----" << endl;
  cout << "Tag file position (start): " << (df_StreamPos)t.start_tag << endl;
  cout << "Tag file position (end):   " << (df_StreamPos)t.end_tag << endl;
  cout << "Tag's total length <---->: " << t.tag_length << endl;
  cout << "----- Tag Infomation ------" << endl;
  cout << "Tag ID----: " << t.tag_id << endl;
  cout << "Tag ------: " << t.tag.c_str() << endl;
  cout << "Attributes: " << t.attr.c_str() << endl;
  cout << "Original tag: " << t.tag_info.c_str() << endl;

  cout << "----- Tag instructions -----" << endl;
  if(t.start_instruction) cout << "Start of tag instruction" << endl;
  if(t.end_instruction) cout << "End of tag instruction" << endl;
  if(t.has_attributes) cout << "This tag has attibutes associated with it"
			  << endl;
  cout << endl;
}

void ListSupportedTags()
{
  gxsHTML html;
  for(unsigned i = 0; i < gxsMAX_SUPPORTED_TAGS; i++) {
    cout << "<" << html.GetTag(i) << ">" << endl;
  }
}

void ListDocTags(const char *fname)
{
  gxsHTML html;
  html.LoadHTMLFile(fname);
  if(!html) {
    cout << "Could not open the " << fname << " file!" << endl;
    return;
  }

  gxList<gxsHTMLTagInfo> *tag_list = html.GetTagList();
  gxListNode<gxsHTMLTagInfo> *list_ptr = tag_list->GetHead();
  while(list_ptr) {
    PrintTagInfo(list_ptr->data);
    list_ptr = list_ptr->next; 
  }
}

void HelpMessage(const char *program_name, const double version_number)
{
  cout << endl;
  cout.setf(ios::showpoint | ios::fixed);
  cout.precision(3);
  cout << endl;
  cout << program_name << " version " << version_number  << endl;
  cout << "Usage: " << program_name << " [switches] infile.html" << endl;
  cout << "Example: " << program_name << " -l index.html" << endl;
  cout << "Switches: " << endl;
  cout << "          -l = List all the tags found in an HTML document." 
       << endl;
  cout << "          -L = List all the tags supported by this program." 
       << endl;
  cout << "          -p = Parse all the supported tags in an HTML document."
       << endl;
  cout << endl;
  return;
}

int ProcessArgs(char *arg)
{
  switch(arg[1]) {
    case 'l' :
      parsing_tags = 0;
      listing_doc_tags = 1;
      break;
      
    case 'L' :
      ListSupportedTags();
      return 0;

    case 'p' :
      parsing_tags = 1;
      listing_doc_tags = 0;
      break;

    default:
      cerr << endl;
      cerr << "Unknown switch " << arg << endl;
      cerr << "Exiting..." << endl;
      cerr << endl;
      return 0;
  }
  arg[0] = '\0';
  return 1; // All command line arguments were valid
}

// Program's main thread of execution.
// ----------------------------------------------------------- 
int main(int argc, char **argv)
// NOTE: None of the MSVC compilers will expand wildcard characters
// used in command-line arguments unless linked with the setargv.obj
// library. All the UNIX compliers will expand wildcard characters
// by default.
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  if(argc < 2) { 
    HelpMessage(ProgramName, ProgramVersionNumber);
    return 0;
  }
  
  // Process command ling arguments and files 
  int narg;
  char *arg = argv[narg = 1];

  while (narg < argc) {
    if(arg[0] != '\0') {
      if(arg[0] == '-') { // Look for command line arguments
	if(!ProcessArgs(arg)) return 0; // Exit if argument is not valid
      }
      else { 
	if(parsing_tags) {
	  ParseTags((const char *)arg);
	}
	else if(listing_doc_tags) {
	  ListDocTags((const char *)arg);
	}
	else {
	  cout << "No operation specified!" << endl;
	  cout << "Exiting..." << endl;
	}
      }
      arg = argv[++narg];
    }
  }

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
