# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

# Build dependency rules
# ===============================================================
PROJECT_DEP = $(INCLUDE_PATH)gxlistb.h

GXLISTB_DEP = $(INCLUDE_PATH)gxlistb.h

USTRING_DEP = $(INCLUDE_PATH)ustring.h

GXCONFIG_DEP = $(INCLUDE_PATH)ustring.h $(INCLUDE_PATH)gxconfig.h \
	$(INCLUDE_PATH)gxlistb.h $(INCLUDE_PATH)gxstring.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

ustring$(OBJ_EXT):	$(SRC_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)ustring.cpp

gxconfig$(OBJ_EXT):	$(SRC_PATH)gxconfig.cpp $(GXCONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxconfig.cpp

gxlistb$(OBJ_EXT):    $(SRC_PATH)gxlistb.cpp $(GXLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)gxlistb.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) gxlistb$(OBJ_EXT) leaktest$(OBJ_EXT) \
	ustring$(OBJ_EXT) gxconfig$(OBJ_EXT)
# ===============================================================
