# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

# Build dependency rules
# ===============================================================
GXUINT16_DEP = $(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxuint16.h

EDS201_DEP = $(INCLUDE_PATH)eds201.h \
	$(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxuint16.h

PROJECT_DEP = $(INCLUDE_PATH)eds201.h \
	$(INCLUDE_PATH)gxdtypes.h \
	$(INCLUDE_PATH)gxuint16.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

eds201$(OBJ_EXT):	$(SRC_PATH)eds201.cpp $(EDS201_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)eds201.cpp

gxuint16$(OBJ_EXT):	$(SRC_PATH)gxuint16.cpp $(GXUINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxuint16.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) leaktest$(OBJ_EXT) \
	eds201$(OBJ_EXT) gxuint16$(OBJ_EXT)
# ===============================================================
