// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: dbobject.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/18/1997  
// Date Last Modified: 06/12/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Database object class used with the client/server example.
*/
// ----------------------------------------------------------- // 
#include "dbobject.h"

#include <iostream.h>

DatabaseObjectData::DatabaseObjectData()
{
  oid = (OID)0;
  cid = (CID)0;
  for(unsigned i = 0; i < gxMaxNameLength; i++) name[i] = 0;
}

FAU DatabaseObject::WriteObject()
{
  FAU addr = Alloc(sizeof(DatabaseObjectData));
  if(!addr) return 0;
  
  Write(p, sizeof(DatabaseObjectData));

  // Write a 32-bit CRC checksum for the object
  WriteObjectChecksum(addr);
			     
  return addr;
}

void DatabaseObject::ReadObject(FAU Address)
{
  // Optimize seeks during intervening reads
  SeekTo(Address);
  Read((char *)this->p, sizeof(DatabaseObjectData));
  
  // Test the objects checksum
  int rv = ReadObjectChecksum(Address);
  if(!rv)
#ifdef __CPP_EXCEPTIONS__
    throw CChecksumError();
#else
  cout << DatabaseExceptionMessage() << endl;
#endif
}

FAU DatabaseObject::FindObject()
{
  int rv; // Return value

  // If not using index file or entry not found, search the data file
  DatabaseObjectData dbobject;
  FAU oa;           // Object Address
  gxBlockHeader blk; // Block Header
  
  FAU gxdfileEOF = GetEOF();
  FAU addr = 0;
  addr = FindFirstBlock(addr); // Search the entire file

  if(addr == (FAU)0) return 0; // No database blocks found in file

  dbobject.oid = p->oid;
  dbobject.cid = p->cid;
  strcpy(dbobject.name, p->name);

  while(1) { 
    if(addr >= gxdfileEOF) break;
    Read(&blk, sizeof(gxBlockHeader), addr);
    if(blk.block_check_word == gxCheckWord) {
      if((__SBYTE__)blk.block_status == gxNormalBlock) {
	oa = addr + BlockHeaderSize();
	ReadObject(oa);
	if(strcmp(p->name, dbobject.name) == 0) {
	  return oa; // Found unique data member
	}
      }
      addr = addr + blk.block_length; // Goto the next database block
    }
    else {
      addr = FindFirstBlock(addr); 
      if(!addr) break;
    }
  }

  // Reset the objects data
  p->oid = dbobject.oid;
  p->cid = dbobject.cid;
  strcpy(p->name, dbobject.name);
  
  return 0; // Could not find 
}

FAU DatabaseObject::ChangeObject(const DatabaseObjectData &new_dbobject_info)
{
  FAU addr = FindObject();
  if(!addr) return 0; // Object does not exist
  Write(&new_dbobject_info, sizeof(new_dbobject_info), addr);

  // Write a 32-bit CRC checksum for the object
  WriteObjectChecksum(addr);

  strcpy(p->name, new_dbobject_info.name);
  p->oid = new_dbobject_info.oid;
  p->cid = new_dbobject_info.cid;
  return addr;
}

FAU DatabaseObject::DeleteObject()
{
  FAU addr = FindObject();
  if(!addr) return 0; // Object does not exist
  Delete(addr);
  return addr;
}

FAU DatabaseObject::RemoveObject()
{
  FAU addr = FindObject();
  if(!addr) return 0; // Object does not exist
  Remove(addr);
  return addr;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
