/*

	Copyright (c) 1990-2000 Lodestar Database Technologies
				  P. O. Box 175
				  Freeman Spur, IL  62841
	All rights reserved.

	Source file = fs.h

	Data base header file.

	Written:  July 1990.
*/

#define NUMBUFFS 16
#define BLKSIZE 1024
#define U_LONG_MAX 0xffffffff
#define MAX_XLATE_SLOT 0x0fffffff
#define MAXOPENFILES 20
#include <time.h>

#ifndef VCHAR

enum { VCHAR = 1,
       VUCHAR,
       CHARSHORT,
       UCHARSHORT,
       VINT,
       VSHORT,
       VLLONG,
       VLUINT,
       VLUSHORT,
       VULONG,
       DOUBLE,
       VFLOAT,
       LONGDOUBLE,
       REPEAT,
       DOSDATE,
       DOSTIME,
       NUMASCII,
       VISTADATE,
       DELPHISTR };


typedef unsigned char  uchar;
typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned long  ulong;

#endif

#if defined(__WIN32__)
# define WINDOWSEXPORT __export __stdcall
#else
# ifdef VISTAWIN
#   define WINDOWSEXPORT _export FAR PASCAL
# else
#   define WINDOWSEXPORT
# endif
#endif


#define SUCCESSFUL 0
#define END_OF_FILE -1
#define FOUNDIT 0
#define DIDNOTFIND -1
#define TRUE 1
#define FALSE 0

typedef struct FS {
  short  fsdatanum;
  uchar  isnetwork;
  ushort socket;
  char   errororigin;            // Lodestar or Netware
  long   error;
  short  len;
  uchar  fid;
  ulong  rid;
  uchar  sequence,
	 totalpackets;
} FS;

    short
initfsvariables(void);
#ifdef __cplusplus
extern "C" {
#endif

    char WINDOWSEXPORT
fsinit(char *name);
    char * WINDOWSEXPORT
getnwloginname(char instance);
    short  WINDOWSEXPORT
closefs(char instance);
    short WINDOWSEXPORT
checkforshare(char *fname);
    FS *  WINDOWSEXPORT
fsopen(char instance,
       char *name,
       short checkintegrity,
       short readonly);
    FS *  WINDOWSEXPORT
fsopentemp(char instance);
    short WINDOWSEXPORT
fscreatedatabase(char *filename,
                 short freq);
    void  WINDOWSEXPORT
fsclose(char instance,
        FS *fsinfo);
    short   WINDOWSEXPORT
fsforceclose(char instance,
             char *name);
    void  WINDOWSEXPORT
fsclosetemp(char instance,
            FS *fsinfo);
    short WINDOWSEXPORT
fslock(char instance,
       FS *fsinfo,
       ulong *ridary);
    short WINDOWSEXPORT
fsunlock(char instance,
         FS *fsinfo);
    short WINDOWSEXPORT
fsunlockrid(char instance,
            FS *fsinfo,
            ulong rid);
    short WINDOWSEXPORT
fsexclusivelock(char instance,
                FS *fsinfo,
                short allowreads);
    short WINDOWSEXPORT
fsexclusiveunlock(char instance,
                  FS *fsinfo);
    ulong WINDOWSEXPORT
fsgetbusinessdate(char instance,
                  FS *fsinfo);
    short WINDOWSEXPORT
fsstorebusinessdate(char instance,
                    FS *fsinfo,
                    ulong rid);
    short WINDOWSEXPORT
fsgetlocaltime(char instance,
               struct tm *data);
    ulong WINDOWSEXPORT
fsadd(char  instance,
      FS    *fsinfo,
      void  *rec,
      short len,
      uchar fid);
    ulong WINDOWSEXPORT
fsfirst(char  instance,
        FS    *fsinfo,
        uchar fid);
    ulong WINDOWSEXPORT
fslast(char  instance,
       FS    *fsinfo,
       uchar fid);
    short WINDOWSEXPORT
fswrite(char  instance,
        FS    *fsinfo,
        void  *rec,
        short len,
        ulong rid);
    short WINDOWSEXPORT
fsdelete(char  instance,
         FS    *fsinfo,
         ulong rid);
    short WINDOWSEXPORT
fsread(char  instance,
       FS    *fsinfo,
       ulong rid,
       void  *rec);
    ulong WINDOWSEXPORT
fsnext(char  instance,
       FS    *fsinfo,
       ulong rid);
    ulong WINDOWSEXPORT
fsprev(char  instance,
       FS    *fsinfo,
       ulong rid);
    short WINDOWSEXPORT
fsaddkey(char  instance,
         FS    *fsinfo,
         uchar fid,
         ulong rid,
         short len,
         void  *key);
    short WINDOWSEXPORT
fsdeletekey(char  instance,
            FS    *fsinfo,
            uchar fid,
            ulong rid,
            short len,
            void  *key);
    ulong WINDOWSEXPORT
fsfirstkey(char  instance,
           FS    *fsinfo,
           uchar fid,
           void  *key);
    ulong WINDOWSEXPORT
fslastkey(char  instance,
          FS    *fsinfo,
          uchar fid,
          short len,
          void  *key);
    ulong WINDOWSEXPORT
fsfindkey(char  instance,
          FS    *fsinfo,
          uchar fid,
          short len,
          void  *key);
    ulong WINDOWSEXPORT
fsnextkey(char  instance,
          FS    *fsinfo,
          uchar fid,
          ulong rid,
          short len,
          void  *key);
    ulong WINDOWSEXPORT
fsprevkey(char  instance,
          FS    *fsinfo,
          uchar fid,
          ulong rid,
          short len,
          void  *key);
    short WINDOWSEXPORT
fsflush(char instance,
        FS   *fsinfo);

#ifdef __cplusplus
}
#endif

typedef struct DOSTM
{
  short tm_sec;
  short tm_min;
  short tm_hour;
  short tm_mday;
  short tm_mon;
  short tm_year;
  short tm_wday;
  short tm_yday;
  short tm_isdst;
} DOSTM;

