// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: ustring.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 11/29/1996
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The UString class is a user-defined string class used to create
and manipulate null-terminated resizable character strings.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_USER_DEFINED_STRING_HPP__
#define __GX_USER_DEFINED_STRING_HPP__

#include <iostream.h>
#include <iomanip.h>
#include <string.h>

class UString 
{ 
public:
  UString() { sptr = 0; d_length = s_length = 0; }
  UString(const char *s, unsigned bytes = 0) {
    sptr = 0; d_length = s_length = 0; SetString(s, bytes);
  }
  UString(unsigned bytes);
  ~UString() { if(sptr) delete sptr; }    
  UString(const UString &s) {
    sptr = 0; d_length = s_length = 0; SetString(s.sptr, s.s_length);
  }
  UString &operator=(const char *s) { SetString(s); return *this; }
  UString &operator=(const UString &s);

public: // Append, Insert, delete, and remove functions
  void Cat(const char *s, unsigned bytes) { InsertAt(s_length, s, bytes); }
  void Cat(const char *s) { Cat(s, strlen(s)); }
  int SetString(const char *s, unsigned bytes = 0);
  void Clear();
  unsigned DeleteAt(unsigned position, unsigned bytes);

  unsigned ReplaceAt(unsigned position, const char *s, unsigned bytes);

  unsigned ReplaceAt(unsigned position, const char *s) {
    return ReplaceAt(position, s, strlen(s));
  }
  unsigned ReplaceAt(unsigned position, const UString &s) {
    return ReplaceAt(position, s.sptr, s.s_length);
  }
  unsigned InsertAt(unsigned position, const char *s, unsigned bytes);
  unsigned InsertAt(unsigned position, const char *s) {
    return InsertAt(position, s, strlen(s));
  }
  unsigned InsertAt(unsigned position, const UString &s) {
    return InsertAt(position, s.sptr, s.s_length);
  }
  
public: // C String, pointer, and length functions
  unsigned length() { return s_length; }
  unsigned length() const { return s_length; }
  int is_null() { return ((sptr == 0) || (s_length == 0)); }
  int is_null() const { return ((sptr == 0) || (s_length == 0)); }
  char *c_str() { return sptr; } // Returns a NULL terminated C string 
  const char *c_str() const { return (const char *)sptr; } 
  UString *strdup();
  UString *strdup() const;
  int resize(unsigned bytes , int keep = 1);

public: // String search function
  unsigned Find(char *s, unsigned offset = 0); 
  unsigned Find(char *s, unsigned bytes, unsigned offset) const;
  unsigned Find(const UString &s, unsigned offset = 0) {
    return Find(s.sptr, s.s_length, offset);
  }
  unsigned Find(const UString &s, unsigned bytes, unsigned offset) const {
    return Find(s.sptr, bytes, offset);
  }

  // Case insensitive pattern searches
  unsigned IFind(char *s, unsigned offset = 0); 
  unsigned IFind(char *s, unsigned bytes, unsigned offset) const;
  unsigned IFind(const UString &s, unsigned offset = 0) {
    return IFind(s.sptr, s.s_length, offset);
  }
  unsigned IFind(const UString &s, unsigned bytes, unsigned offset) const {
    return IFind(s.sptr, bytes, offset);
  }

public: // Formatting and filtering functions
  int ToUpper();
  int ToLower();
  unsigned FindLast(const char *s);
  unsigned FindLast(char *s);
  unsigned ReplaceChar(const char c, const char replacement,
                       unsigned offset = 0);
  unsigned ReplaceString(const char *s, const char *replacement,
                         unsigned offset = 0);
  unsigned ReplaceString(char *s, char *replacement, unsigned offset = 0);
  unsigned FilterString(const char *s, unsigned offset = 0);
  unsigned FilterString(char *s, unsigned offset = 0);
  unsigned FilterChar(const char c, unsigned offset = 0);
  unsigned TrimLeadingSpaces();
  unsigned TrimTrailingSpaces();
  int DeleteAfter(const char *s);
  int DeleteBefore(const char *s);
  int DeleteAfterIncluding(const char *s);
  int DeleteBeforeIncluding(const char *s);
  int DeleteAfterLast(const char *s);
  int DeleteAfterLastIncluding(const char *s);
  int DeleteBeforeLast(const char *s);
  int DeleteBeforeLastIncluding(const char *s);

public: // Class type to ostream type conversions
  friend ostream &operator<<(ostream &os, const UString &s);
  friend istream &operator>>(istream &os, UString &s);

public: // Overloaded operators
  int operator!() { return ((sptr == 0) || (s_length == 0)); } 
  int operator!() const { return ((sptr == 0) || (s_length == 0)); }
  operator const int () const { return ((sptr != 0) && (s_length != 0)); }
  operator int () { return ((sptr != 0) && (s_length != 0)); }
  char &operator[](unsigned i);
  char &operator[](unsigned i) const;
  void operator+=(const UString &s) { Cat(s.sptr, strlen(s.sptr)); }
  void operator+=(const char *s) { Cat(s, strlen(s)); }
  void operator+=(const char c);
  friend UString operator+(const UString &a, const UString &b);
  friend UString operator+(const char *s, const UString &b);
  friend UString operator+(const UString &a, const char *s);
  friend int operator==(const UString &a, const UString &b);
  friend int operator==(const char *s, const UString &b);
  friend int operator==(const UString &a, const char *s);
  friend int operator!=(const UString &a, const UString &b);
  friend int operator!=(const char *s, const UString &b);
  friend int operator!=(const UString &a, const char *s);
  friend int operator>(const UString &a, const UString &b);
  friend int operator>(const char *s , const UString &b);
  friend int operator>(const UString &a, const char *s);
  friend int operator>=(const UString &a, const UString &b);
  friend int operator>=(const char *s, const UString &b);
  friend int operator>=(const UString &a, const char *s);
  friend int operator<(const UString &a, const UString &b);
  friend int operator<(const char *s, const UString &b);
  friend int operator<(const UString &a, const char *s);
  friend int operator<=(const UString &a, const UString &b);
  friend int operator<=(const char *s, const UString &b);
  friend int operator<=(const UString &a, const char *s);

public: // Friend functions
  // Returns -1 if a < b, 0 if a == b, and 1 if a > b
  friend int StringCompare(const UString &a, const UString &b);  
  friend int StringCompare(const char *s, const UString &b) {
    UString a(s); return StringCompare(a, b);
  }
  friend int StringCompare(const UString &a, const char *s) {
    UString b(s); return StringCompare(a, b);
  }
	       
private:
  char *sptr;        // Pointer to this object's null-terminated string
  unsigned d_length; // Total number of bytes allocated for this object
  unsigned s_length; // String length of this object's null-terminated string
};

// General-purpose string routines that need to be ported from UNIX to DOS
int CaseICmp(const UString &s1, const UString &s2);
int CaseICmp(UString &s1, UString &s2);
int CaseICmp(const UString &s1, const char *s);
int CaseICmp(const char *s, const UString &s2);

#endif  // __GX_USER_DEFINED_STRING_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

