//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl\registry.hpp>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
#include "Unit3.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TMainForm *MainForm;
TStringList *StrList = new TStringList;
//---------------------------------------------------------------------------
#define NameLen 40
#define DateLen 12
#define PhoneLen 21
#define AddressLen 40
#define DayLen 2
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
   formColor = Color;
   editColor = NameEdit->Color;
   edittextColor = NameEdit->Font->Color;
   label1Color = Label1->Font->Color;
   label2Color = Label2->Font->Color;
   labelsColor = Label3->Font->Color;

   // Loading colors from registry
   TColor dummyColor = RGB(254,50,233),
          defColor = RGB(0,0,255),
          testColor;

   TRegIniFile *RegFile = new TRegIniFile("SOFTWARE\\Birthday Scanner");
   testColor = RegFile->ReadInteger("Colors","Form",dummyColor);
   if (testColor != dummyColor)
   {
      MainForm->Color = RegFile->ReadInteger("Colors","Form",defColor);
      ColorForm->SetEdit(RegFile->ReadInteger("Colors","Edit",defColor));
      ColorForm->SetEditText(RegFile->ReadInteger("Colors","EditText",defColor));
      MainForm->Label1->Font->Color = RegFile->ReadInteger("Colors","Label1",defColor);
      MainForm->Label2->Font->Color = RegFile->ReadInteger("Colors","Label2",defColor);
      ColorForm->SetLabels(RegFile->ReadInteger("Colors","Labels",defColor));
   }
   RegFile->Free();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
   SmthChanged = FALSE;

   try
   {
      StrList->LoadFromFile("Birthday.txt");
   }
   catch (EFOpenError &E)
   {
      StrList->Add("");
   }
}
//---------------------------------------------------------------------------
void TMainForm::UpdateStrList()
{
   // stores any changes in EditBoxes in String
   // (this is a must, because MainForm->Refresh() can be issued by system
   // when windows are switched, thus refilling EditBoxes with String's data)
   if ((NameEdit->Modified)||(DateEdit->Modified)||
       (PhoneEdit->Modified)||(AddressEdit->Modified))
   {
      AnsiString Str;
      Str = NameEdit->Text;
      while (Str.Length() < NameLen)  Str += " ";
      Str += DateEdit->Text;
      while (Str.Length() < (NameLen+DateLen))  Str += " ";
      Str += PhoneEdit->Text;
      while (Str.Length() < (NameLen+DateLen+PhoneLen))  Str += " ";
      Str += AddressEdit->Text;
      while (Str.Length() < (NameLen+DateLen+PhoneLen+AddressLen))  Str += " ";
      Str += Day->Items->Strings[Day->ItemIndex];
      while (Str.Length() < (NameLen+DateLen+PhoneLen+AddressLen+DayLen))  Str += " ";

      StrList->Strings[Counter->Tag] = Str;

      NameEdit->Modified = FALSE;
      DateEdit->Modified = FALSE;
      PhoneEdit->Modified = FALSE;
      AddressEdit->Modified = FALSE;

      SmthChanged = TRUE;
   }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::NextButtonClick(TObject *Sender)
{
   UpdateStrList();
   StrList->Sort();
   if (Counter->Tag < (StrList->Count-1))  (Counter->Tag)++;
   MainForm->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PrevButtonClick(TObject *Sender)
{
   UpdateStrList();
   StrList->Sort();
   if (Counter->Tag > 0)  (Counter->Tag)--;
   MainForm->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormPaint(TObject *Sender)
{
   // cutting String into parts and filling EditBoxes
   AnsiString PosStr((int)Counter->Tag + 1),
              NumStr((int)StrList->Count),
              Str,
              DayStr;
   Counter->Text = PosStr + " of " + NumStr;
   Str = StrList->Strings[Counter->Tag];
   NameEdit->Text  = TrimRight(Str.SubString(1,NameLen));
   DateEdit->Text  = TrimRight(Str.SubString(NameLen+1,DateLen));
   PhoneEdit->Text = TrimRight(Str.SubString(NameLen+DateLen+1,PhoneLen));
   AddressEdit->Text = TrimRight(Str.SubString(NameLen+DateLen+PhoneLen+1,AddressLen));

   DayStr = TrimRight(Str.SubString(NameLen+DateLen+PhoneLen+AddressLen+1,DayLen));
   if (DayStr.Length() == 0)
   {
      Day->ItemIndex = 0;
      return;
   }

   try
   {
      Day->ItemIndex = DayStr.ToInt()-1;
   }
   catch (EConvertError &E)
   {
      Day->ItemIndex = 0;
   }

}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DayChange(TObject *Sender)
{
   NameEdit->Modified = TRUE;  // we're fooling UpdateStrLit, since Day has no Modified property
   UpdateStrList();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AddButtonClick(TObject *Sender)
{
   StrList->Add("");
   Counter->Tag = StrList->Count-1;
   MainForm->Refresh();
   Day->ItemIndex = 2;
   DayChange(Sender);
   NameEdit->SetFocus();

   SmthChanged = TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ExitButtonClick(TObject *Sender)
{
   // storing changes in file
   UpdateStrList();
   StrList->SaveToFile("Birthday.txt");
   MainForm->Close();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DelButtonClick(TObject *Sender)
{
   if (MessageBox(Handle,"Do you really wish to delete this reminder?","Confimation",MB_YESNOCANCEL | MB_ICONQUESTION) == ID_YES)
   {
      StrList->Delete(Counter->Tag);
      if (Counter->Tag >= StrList->Count)   Counter->Tag = StrList->Count-1;
      MainForm->Refresh();

      SmthChanged = TRUE;
   }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DateEditChange(TObject *Sender)
{
   UpdateStrList();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FindClick(TObject *Sender)
{
   // Tag contains the first String to be searched
   FindDialog->Tag = 0;
   FindDialog->Execute();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::QuitClick(TObject *Sender)
{
   if (SmthChanged)
   {
      switch (MessageBox(Handle," Some reminders were modified!\n\nDo you wish to save the changes?","Confimation",MB_YESNOCANCEL | MB_ICONQUESTION))
      {
         case ID_YES:  ExitButtonClick(this); break;
         case ID_NO:   MainForm->Close(); break;
      }
   }
   else
   {
      MainForm->Close();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FindDialogFind(TObject *Sender)
{
   int i=FindDialog->Tag, pos;
   AnsiString FindStr, Str;

   // if FindText wasn't modified - we continue search from previous position
   if (FindDialog->FindText != OldFindText)  i=0;
   OldFindText = FindDialog->FindText;
   // the same - if MatchCase wasn't modified
   if ((FindDialog->Options.Contains(frMatchCase)) != OldMatchCase)  i=0;
   OldMatchCase = (FindDialog->Options.Contains(frMatchCase));

   // if  MatchCase == FALSE  convert the FindText to lowercase
   // (later each line will be also converted to lowercase)
   if (FindDialog->Options.Contains(frMatchCase))
      FindStr = FindDialog->FindText;
   else
      FindStr = (FindDialog->FindText).LowerCase();

   do
   {
      // if  MatchCase == FALSE  convert the String to lowercase
      if (FindDialog->Options.Contains(frMatchCase))
         Str = StrList->Strings[i];
      else
         Str = (StrList->Strings[i]).LowerCase();

      // searching the String
      pos = Str.Pos(FindStr);
      if (pos!=0)
      {
         // the String was found
         Counter->Tag = i;
         if (i < (StrList->Count-1))  FindDialog->Tag = i+1;
         else   FindDialog->Tag = i;
      }
      i++;
   }
   while ((i < StrList->Count) && (pos==0));
   MainForm->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::EnterClick(TObject *Sender)
{
   AnsiString Str = StrList->Strings[Counter->Tag];
   StrList->Sort();
   Counter->Tag = StrList->IndexOf(Str);
   MainForm->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AboutClick(TObject *Sender)
{
   AboutBox->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SetupButtonClick(TObject *Sender)
{
   ColorForm->ShowModal();
}
//---------------------------------------------------------------------------
