<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Pay Rep</TITLE>
</HEAD>

<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>

<!-- End of Include section -->



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function printReport() {
   
   window.print();
}
]]>
</xsl:comment>
</SCRIPT>


<TABLE>

<TR>
<TD>Check Number:</TD>
<TD><xsl:value-of select="MSI/CHECKNUM"/></TD>
</TR>

<TR>
<TD>Date:</TD>
<TD><xsl:value-of select="MSI/DATE"/></TD>
</TR>

<TR>
<TD>Rep:</TD>
<TD><xsl:value-of select="MSI/UserInfo/UserTable/i1"/> <xsl:value-of select="MSI/UserInfo/UserTable/i2"/></TD>
</TR>

<TR>
<TD>Amount:</TD>
<TD>
<xsl:choose>
<xsl:when test="MSI/COMINFO/POComTable/i7[.!='']">
$<xsl:value-of select="format-number(sum(MSI/COMINFO/POComTable/i7), '###,##0.00')"/>
</xsl:when>
</xsl:choose>

</TD>

</TR>

</TABLE>


<P></P>


<TABLE>
		<TR>
			<TD><b>PO #</b></TD>
			<TD><b>Recevied on</b></TD>
			<TD><b>Commission</b></TD>
			<TD><b>Notes</b></TD>
		</TR>
		
		<xsl:for-each select="MSI/COMINFO/POComTable">
		<xsl:sort select="i2" data-type="text" order="ascending"/>
	
			<TR>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i2"/></TD>
				<TD>$<xsl:value-of select="i7"/></TD>
				<TD><xsl:value-of select="i10"/></TD>
				
			</TR>
		</xsl:for-each>
</TABLE>

<P></P>
<BUTTON NAME="PRINT" VALUE="PRINT" onClick="printReport();">Print Report</BUTTON>


</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

