<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
     <TITLE>Edit Suppliers</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function deleteConfirm() {
      var result = confirm("Are you sure you want to DELETE the selected purchase orders?");
		
		if(result)
		{	
			FORM1.DELETE.value='true';
			FORM1.submit();
			return true;
		}	
      else
		{
			return false;
		}
}

function setTab(focusItem) {
    focusItem.focus();
}

]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="setTab(FORM1.REPNAME)">

<CENTER><H1>Manage Sales Reps</H1></CENTER><P></P>
<P></P>
<xsl:choose>
<xsl:when test="MSI/REPMAIN/MESSAGE[.!='']">
<TR><CENTER><H2 CLASS="STATUS"><xsl:value-of select="MSI/REPMAIN/MESSAGE"/></H2></CENTER></TR> 
</xsl:when>
</xsl:choose>
<P></P>

<FORM METHOD="POST" NAME="FORM1">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<INPUT TYPE="HIDDEN" NAME="recipient" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="subject" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="redirect" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="1026"></INPUT>


<A> 
<xsl:attribute name="HREF"><xsl:value-of select="/MSI/LAYOUT/SERVLET"/>?disValue=1030</xsl:attribute>
Add New Rep</A>

<P/>
<H3>Add Existing Rep</H3>
<TABLE CELLPADDING="2">
<TR><TD WIDTH="30%" VALIGN="TOP">Rep Name</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="REPNAME" VALUE="" SIZE="10"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Public Password</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="PUB_PASSWORD" VALUE="" SIZE="10" TYPE="password"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Commission Percentage</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="COMMISSION" VALUE="" SIZE="10"></INPUT></TD></TR>

<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" NAME="ADDREP" VALUE="Add Existing Rep"></INPUT></TD></TR>
</TABLE>

<P/>

<H3>Current Reps</H3>
<TABLE CELLPADDING="2">
<xsl:choose>
<xsl:when test="MSI/REPMAIN/REPLIST/REP[.!='']">
	
		<TR>
		<xsl:attribute name="BGCOLOR"><xsl:value-of select="/MSI/LAYOUT/EVANROW"/></xsl:attribute>
			<TH></TH>
			<TH></TH>
			<TH>ID</TH>
			<TH>Name</TH>
			<TH>Areas</TH>
		</TR>
</xsl:when>
</xsl:choose>
		
		<xsl:for-each select="MSI/REPMAIN/REPLIST/REP">
		   <TR>
			<xsl:choose>
			<xsl:when test="position() mod 2 = 1">
		   	<xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>			
				
				
				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="USERID"/></xsl:attribute>
				     </INPUT></TD>
				<TD><INPUT TYPE="SUBMIT" VALUE="Edit Rep">
					 <xsl:attribute name="NAME">edit<xsl:value-of select="c1"/></xsl:attribute>
					 </INPUT></TD>
				<TD><xsl:value-of select="USERID"/></TD>
				<TD><xsl:value-of select="FIRSTNAME"/><xsl:text> </xsl:text><xsl:value-of select="LASTNAME"/></TD>
				<TD>
					<xsl:for-each select="AREAINFO/AREA">
					<xsl:value-of select="AREANAME"/>
					</xsl:for-each>
			  </TD>
				
				<TD><INPUT TYPE="HIDDEN">
					 <xsl:attribute name="NAME">rep<xsl:value-of select="c1"/></xsl:attribute>
					 <xsl:attribute name="VALUE"><xsl:value-of select="USERID"/></xsl:attribute>
					 </INPUT>
				</TD>
	
			</TR>
		</xsl:for-each>

<INPUT TYPE="HIDDEN" NAME="TOTALREPS">
	 <xsl:attribute name="VALUE"><xsl:value-of select="MSI/REPMAIN/REPLIST/FOOTER/TOTALCOUNT"/></xsl:attribute>
	 </INPUT>

</TABLE>

<INPUT TYPE="BUTTON" NAME="DELETEBUTTON" VALUE="Delete Reps" onClick="deleteConfirm()"></INPUT>
<INPUT TYPE="HIDDEN" NAME="DELETE" VALUE="FALSE"></INPUT>

</FORM><P></P>

</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
