/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;

public class SimpleMapper
extends BaseInterceptor {
    int debug = 0;
    ContextManager cm;
    Hashtable contextPaths = new Hashtable();
    Hashtable securityConstraints = new Hashtable();

    public void addContainer(Container ct) throws TomcatException {
        Mappings m;
        Context ctx = ct.getContext();
        String path = ct.getPath();
        String ctxP = ctx.getPath();
        Hashtable mtable = this.securityConstraints;
        if (ct.getHandler() != null) {
            mtable = this.contextPaths;
        }
        if ((m = (Mappings)mtable.get(ctxP)) == null) {
            m = new Mappings();
            m.ctx = ctx;
            m.prefixMappedServlets = new Hashtable();
            m.extensionMappedServlets = new Hashtable();
            m.pathMappedServlets = new Hashtable();
            mtable.put(ctxP, m);
            Container def = new Container();
            def.setContext(ctx);
            m.defaultContainer = def;
        }
        if (this.debug > 0) {
            ctx.log("Add mapping " + path + " " + ct + " " + m);
        }
        if ((path = path.trim()).length() == 0) {
            return;
        }
        if (path.startsWith("/") && path.endsWith("/*")) {
            m.prefixMappedServlets.put(path, ct);
        } else if (path.startsWith("*.")) {
            m.extensionMappedServlets.put(path, ct);
        } else if (!path.equals("/")) {
            m.pathMappedServlets.put(path, ct);
        }
    }

    public int contextMap(Request rrequest) {
        int qindex;
        if (rrequest.getContext() != null) {
            return 0;
        }
        String path = rrequest.getRequestURI();
        String sig = ";jsessionid=";
        int foundAt = -1;
        foundAt = path.indexOf(sig);
        if (foundAt != -1) {
            path = path.substring(0, foundAt);
        }
        Context ctx = this.getContextByPath(path);
        rrequest.setContext(ctx);
        String ctxPath = ctx.getPath();
        String lookupPath = rrequest.getLookupPath();
        if (path != null && lookupPath == null) {
            lookupPath = path.substring(ctxPath.length(), path.length());
        }
        if ((qindex = lookupPath.indexOf("?")) > -1) {
            lookupPath = lookupPath.substring(0, qindex);
        }
        if (lookupPath.length() < 1) {
            lookupPath = "/";
        }
        rrequest.setLookupPath(lookupPath);
        return 0;
    }

    private Container findContainer(Mappings m, String path, Context context, Request req) {
        Container container = this.getPathMatch(m, context, path, req);
        if (container == null) {
            container = this.getPrefixMatch(m, context, path, req);
        }
        if (container == null) {
            container = this.getExtensionMatch(m, context, path, req);
        }
        return container;
    }

    Context getContextByPath(String path) {
        String realPath = path;
        Context ctx = null;
        do {
            if ((ctx = this.cm.getContext(path)) != null) continue;
            int i = path.lastIndexOf(47);
            if (i <= -1 || path.length() <= 1) break;
            if ((path = path.substring(0, i)).length() != 0) continue;
            path = "/";
        } while (ctx == null);
        if (ctx == null) {
            ctx = this.cm.getContext("");
        }
        return ctx;
    }

    private String getExtension(String path) {
        int i = path.lastIndexOf(".");
        int j = path.lastIndexOf("/");
        if (i > 0 && i > j) {
            return path.substring(i);
        }
        return null;
    }

    private Container getExtensionMatch(Mappings m, Context context, String path, Request req) {
        String extension = this.getExtension(path);
        if (extension == null) {
            return null;
        }
        Container wrapper = (Container)m.extensionMappedServlets.get("*" + extension);
        if (wrapper == null) {
            return null;
        }
        if (this.debug > 0) {
            context.log("extension match " + path);
        }
        if (wrapper.getHandler() == null) {
            return wrapper;
        }
        int i = path.lastIndexOf(".");
        int j = path.lastIndexOf("/");
        if (j > i) {
            int k = i + path.substring(i).indexOf("/");
            String s = path.substring(0, k);
            req.setServletPath(s);
            s = path.substring(k);
            req.setPathInfo(s);
        } else {
            req.setServletPath(path);
        }
        return wrapper;
    }

    String getFirst(String path) {
        int i;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((i = path.indexOf("/")) > -1) {
            path = path.substring(0, i);
        }
        return "/" + path;
    }

    private Container getPathMatch(Mappings m, Context context, String path, Request req) {
        Container wrapper = null;
        wrapper = (Container)m.pathMappedServlets.get(path);
        if (wrapper != null && wrapper.getHandler() != null) {
            req.setServletPath(path);
            if (this.debug > 1) {
                context.log("path match " + path);
            }
        }
        return wrapper;
    }

    private Container getPrefixMatch(Mappings m, Context context, String path, Request req) {
        Container wrapper = null;
        String s = path;
        if (s.endsWith("/")) {
            s = this.removeLast(s);
        }
        while (s.length() > 0) {
            wrapper = (Container)m.prefixMappedServlets.get(String.valueOf(s) + "/*");
            if (wrapper != null) break;
            s = this.removeLast(s);
        }
        if (wrapper != null && wrapper.getHandler() != null) {
            req.setServletPath(s);
            String pathI = path.substring(s.length(), path.length());
            if (!"".equals(pathI)) {
                req.setPathInfo(pathI);
            }
        }
        if (wrapper != null && this.debug > 0) {
            context.log("prefix match " + path + " " + wrapper);
        }
        return wrapper;
    }

    void log(String msg) {
        if (this.cm == null) {
            System.out.println("SimpleMapper: " + msg);
        } else {
            this.cm.getContext("").log(msg);
        }
    }

    public void removeContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        String mapping = ct.getPath();
        String ctxP = ctx.getPath();
        mapping = mapping.trim();
        if (this.debug > 0) {
            ctx.log("Remove mapping " + mapping);
        }
        Mappings m = (Mappings)this.contextPaths.get(ctxP);
        m.prefixMappedServlets.remove(mapping);
        m.extensionMappedServlets.remove(mapping);
        m.pathMappedServlets.remove(mapping);
        m = (Mappings)this.securityConstraints.get(ctxP);
        m.prefixMappedServlets.remove(mapping);
        m.extensionMappedServlets.remove(mapping);
        m.pathMappedServlets.remove(mapping);
    }

    public void removeContext(ContextManager cm, Context ctx) throws TomcatException {
        String ctxP = ctx.getPath();
        Mappings m = (Mappings)this.contextPaths.get(ctxP);
        if (this.debug > 0) {
            ctx.log("Removed from maps ");
        }
        this.contextPaths.remove(ctxP);
    }

    private String removeLast(String s) {
        int i = s.lastIndexOf("/");
        s = i > 0 ? s.substring(0, i) : (i == 0 && !s.equals("/") ? "/" : "");
        return s;
    }

    public int requestMap(Request req) {
        Context context = req.getContext();
        String path = req.getLookupPath();
        Container container = null;
        String ctxP = context.getPath();
        Mappings m = (Mappings)this.contextPaths.get(ctxP);
        container = this.findContainer(m, path, context, req);
        if (container == null) {
            container = m.defaultContainer;
            req.setWrapper(m.defaultContainer.getHandler());
            req.setServletPath("");
            req.setPathInfo(path);
        } else {
            req.setWrapper(container.getHandler());
        }
        if (this.debug > 0) {
            context.log("SM: Handler " + req + " " + container);
        }
        req.setContainer(container);
        if (container.getRoles() != null) {
            if (this.debug > 0) {
                context.log("Existing security constraint " + container.toString());
            }
            return 0;
        }
        m = (Mappings)this.securityConstraints.get(ctxP);
        if (m == null) {
            return 0;
        }
        Container scontainer = this.findContainer(m, path, context, req);
        if (scontainer == null) {
            return 0;
        }
        Container ct = container.getClone();
        ct.setRoles(scontainer.getRoles());
        ct.setTransport(scontainer.getTransport());
        req.setContainer(ct);
        if (this.debug > 0) {
            context.log("Set security constraings " + req + " " + container);
        }
        return 0;
    }

    public void setContextManager(ContextManager cm) {
        this.cm = cm;
        Enumeration enumeration = cm.getContextNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            try {
                Context ctx = cm.getContext(name);
                if (this.debug > 0) {
                    ctx.log("Adding existing context " + name);
                }
                this.addContext(cm, ctx);
            }
            catch (TomcatException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setDebug(int level) {
        if (level != 0) {
            System.out.println("SimpleMapper - set debug " + level);
        }
        this.debug = level;
    }

    class Mappings {
        Context ctx;
        Container defaultContainer;
        Hashtable prefixMappedServlets;
        Hashtable extensionMappedServlets;
        Hashtable pathMappedServlets;

        Mappings() {
        }
    }
}

