/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class URLResourceReader {
    private Hashtable resourceCache = new Hashtable();
    private boolean iszip = true;
    private URL url = null;
    private boolean cache = true;

    public URLResourceReader(InputStream is) throws IOException {
        this.init(is);
    }

    public URLResourceReader(URL baseurl) throws IOException {
        this(baseurl, false);
    }

    public URLResourceReader(URL baseurl, boolean cache) throws IOException {
        this.url = baseurl;
        this.cache = cache;
        this.iszip = this.url.getFile().endsWith("/") ^ true;
        if (this.iszip) {
            this.cache = true;
        }
        this.initialize();
    }

    public void close() {
        this.resourceCache.clear();
        this.resourceCache = null;
    }

    public byte[] getResource(String resource) {
        byte[] data = (byte[])this.resourceCache.get(resource);
        if (data != null) {
            return data;
        }
        if (this.iszip) {
            return null;
        }
        try {
            URL realURL = new URL(this.url.getProtocol(), this.url.getHost(), String.valueOf(this.url.getFile()) + resource);
            data = this.readFully(realURL.openStream());
            if (this.cache) {
                this.resourceCache.put(resource, data);
            }
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Enumeration getResourceNames() {
        return this.resourceCache.keys();
    }

    private void init(InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zstream = new ZipInputStream(is);
        while ((entry = zstream.getNextEntry()) != null) {
            byte[] entryData = this.readFully(zstream);
            if (this.cache) {
                this.resourceCache.put(entry.getName(), entryData);
            }
            zstream.closeEntry();
        }
        zstream.close();
    }

    private void initialize() throws IOException {
        if (this.iszip) {
            InputStream is = this.url.openStream();
            this.init(is);
            is.close();
        }
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] buf = new byte[1024];
        int num = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((num = is.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    public String toString() {
        return this.url.toString();
    }
}

