<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
    <TITLE>Print Purchase Order</TITLE>
    <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function printReport() {
   
   window.print();
}

function printMessage()
{
var page = "http://www.mysalesinfo.com/printMsg.html";
windowprops = "height=50,width=300,location=no,"
+ "scrollbars=no,menubars=no,toolbars=no,resizable=yes,dependent=yes"; //,screenX=" + top.pageXOffset + ",screenY=" + window.pageYOffset;
//alert(windowprops);
var msgWindow = window.open(page, "Popup", windowprops);
}
]]>
</xsl:comment>
</SCRIPT>


<BODY CLASS="PRINT">

<H1 CLASS="PRINT"><CENTER>Purchase Order</CENTER></H1>

<TABLE WIDTH="675" MARGIN-LEFT="20">

<TR>

   <TD ALIGN="LEFT">
      <TABLE>
         <TH CLASS="PRINT">Ship To:</TH>
         <TR><TD>
            <TABLE BORDER="1">
               <TR><TD><TABLE BORDER="0">
                  <TR><TH CLASS="PRINT"><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/company_name"/></TH></TR>
                  <TR><TD CLASS="PRINT"><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/ship_address1"/></TD></TR>

                  <xsl:choose>
                  <xsl:when test="MSI/CUSTOMERINFO/CompanyTable/ship_address2[.!='']">
                  <TR><TD CLASS="PRINT">
                     <xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/ship_address2"/>
                  </TD></TR>
                  </xsl:when>
                  </xsl:choose>

                  <TR><TD CLASS="PRINT">
                     <xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/ship_city"/>, <xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/ship_state"/>
                     <xsl:text>  </xsl:text><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/ship_zip"/>
                  </TD></TR>
               </TABLE></TD></TR>
            </TABLE>
         </TD></TR>
         
         <TR><TD><BR/></TD></TR>
         
         <TR><TH CLASS="PRINT">Bill To:</TH></TR>
         <TR><TD>
            <TABLE BORDER="1">
               <TR><TD><TABLE BORDER="0">
                  <TR><TD CLASS="PRINT"><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/bill_address1"/></TD></TR>

                  <xsl:choose>
                  <xsl:when test="MSI/CUSTOMERINFO/CompanyTable/bill_address2[.!='']">
                  <TR><TD CLASS="PRINT">
                  <xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/bill_address2"/>
                  </TD></TR>
                  </xsl:when>
                  </xsl:choose>

                  <TR><TD CLASS="PRINT">
                     <xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/bill_city"/>, <xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/bill_state"/>
                     <xsl:text>  </xsl:text><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/bill_zip"/></TD></TR>
               </TABLE></TD></TR>
            </TABLE>
         </TD></TR>
      </TABLE>
   </TD>					



   <TD align="right">
      <TABLE WIDTH="250">
         <TR><TD WIDTH="75"/><TD WIDTH="175"/></TR>
         <TR><TH align="LEFT" CLASS="PRINTBIG" COLSPAN="2">
            <xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i3"/>
         </TH></TR>

         <TR><TH align="LEFT" CLASS="PRINT" COLSPAN="2">
            <xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i7"/>
         </TH></TR>

         <TR><TH align="LEFT" CLASS="PRINT" COLSPAN="2">
            <xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i8"/>
         </TH></TR>


         <TR><TH align="LEFT" CLASS="PRINT" COLSPAN="2">
            <xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i9"/>, <xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i10"/>
            <xsl:text>  </xsl:text><xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i11"/>
         </TH></TR>


         <TR>
            <TH align="LEFT" CLASS="PRINT" WIDTH="75">PHONE </TH>
            <TH ALIGN="LEFT" CLASS="PRINT" WIDTH="175"><xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i13"/></TH>
         </TR>

         <TR>
            <TH align="LEFT" CLASS="PRINT" WIDTH="75">FAX </TH>
            <TH ALIGN="LEFT" CLASS="PRINT" WIDTH="175"><xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i16"/></TH>
         </TR>

         <TR>
            <TH align="LEFT" CLASS="PRINT" WIDTH="75">EMAIL </TH>
            <TH ALIGN="LEFT" CLASS="PRINT" WIDTH="175"><xsl:value-of select="MSI/OWNER/UserInfo/UserTable/i17"/></TH>
         </TR>
         
         <TR><TD><BR/></TD></TR>
      </TABLE>

      <TABLE BORDER="1">
         <TR><TD>
            <TABLE>
               <TR>
               <TH CLASS="PRINT" WIDTH="100">Manufacturer</TH>
               <TH CLASS="PRINT"><xsl:value-of select="MSI/SUPPLIERINFO/SupplierTable/supplier_name"/></TH>
               </TR>
               <TR>
               <TD CLASS="PRINT" WIDTH="100">Fax</TD>
               <TD CLASS="PRINT"><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/fax"/></TD>
               </TR>
               <TR>
               <TD CLASS="PRINT" WIDTH="100">Phone</TD>
               <TD CLASS="PRINT"><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/phone"/></TD>
               </TR>
               <TR>
               <TD CLASS="PRINT" WIDTH="100">Buyer</TD>
               <TD CLASS="PRINT"><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/buyer"/></TD>
               </TR>
               <TR>
               <TD CLASS="PRINT" WIDTH="100">Salesperson</TD>
               <TD CLASS="PRINT"><xsl:value-of select="MSI/REP/UserInfo/UserTable/i4"/><xsl:text> </xsl:text><xsl:value-of select="MSI/REP/UserInfo/UserTable/i6"/></TD>
               </TR>
            </TABLE>
         </TD></TR>
      </TABLE>

</TD>
		  
</TR>

<TABLE BORDER="1">
      <TR>
         <TH CLASS="PRINT" WIDTH="80" ALIGN="CENTER">Ship Date</TH>
         <TH CLASS="PRINT" WIDTH="100" ALIGN="CENTER">Cancel Date</TH>
         <TH CLASS="PRINT" WIDTH="80" ALIGN="CENTER">Terms</TH>
         <TH CLASS="PRINT" WIDTH="70" ALIGN="CENTER">PO #</TH>
         <TH CLASS="PRINT" WIDTH="100" ALIGN="CENTER">Order Date</TH>
      </TR>

      <TR>
         <TD CLASS="PRINT" ALIGN="CENTER">
            <xsl:choose>
               <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/shipdate[.!='']">
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/shipdate"/>
               </xsl:when>
               <xsl:otherwise><xsl:text>&#xA0;</xsl:text></xsl:otherwise>
            </xsl:choose>
         </TD>
         <TD CLASS="PRINT" ALIGN="CENTER">
            <xsl:choose>
               <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/canceldate[.!='']">
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/canceldate"/>
               </xsl:when>
               <xsl:otherwise><xsl:text>&#xA0;</xsl:text></xsl:otherwise>
            </xsl:choose>
         </TD>
         <TD CLASS="PRINT" ALIGN="CENTER">
            <xsl:choose>
               <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/terms[.!='']">
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/terms"/>
               </xsl:when>
               <xsl:otherwise><xsl:text>&#xA0;</xsl:text></xsl:otherwise>
            </xsl:choose>
         </TD>
         <TD CLASS="PRINT" ALIGN="CENTER">
            <xsl:choose>
               <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/otherpoidnum[.!='']">
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/otherpoidnum"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/poidnum"/>
               </xsl:otherwise>
            </xsl:choose>
         </TD>

         <TD CLASS="PRINT" ALIGN="CENTER">
            <xsl:choose>
               <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/dateordered[.!='']">
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/dateordered"/>
               </xsl:when>
               <xsl:otherwise><xsl:text>&#xA0;</xsl:text></xsl:otherwise>
            </xsl:choose>
         </TD>
         <!--TD CLASS="PRINT" ALIGN="CENTER">
            <xsl:choose>
               <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/instruct[.!='']">
                  <xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/instruct"/>
               </xsl:when>
               <xsl:otherwise><xsl:text>&#xA0;</xsl:text></xsl:otherwise>
            </xsl:choose>
         </TD -->
      </TR>

</TABLE>

<xsl:choose>
   <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/instruct[.!='']">
      <P CLASS="PRINT"><B>Special Instructions: </B><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/instruct"/></P>
   </xsl:when>
</xsl:choose>
</TABLE>

<P></P>


<TABLE CELLPADDING="3" WIDTH="675">
   <TR>
      <TH ALIGN="CENTER" CLASS="PRINT" WIDTH="50">QTY.</TH>
      <TH WIDTH="20"></TH>
      <TH ALIGN="CENTER" CLASS="PRINT" WIDTH="150">SKU</TH>
      <TH ALIGN="CENTER" CLASS="PRINT" WIDTH="300">DESCRIPTION</TH>
      <TH ALIGN="RIGHT" CLASS="PRINT" WIDTH="120">PRICE</TH>
      <TH ALIGN="RIGHT" CLASS="PRINT" WIDTH="180">TOTAL</TH>
   </TR>

	<xsl:for-each select="MSI/POINFOXML/POITEMS/POItemTable">
		<TR>
			<xsl:choose>
			<xsl:when test="position() mod 2 = 1">
		   	<xsl:attribute name="CLASS">ODDROWPRINT</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="CLASS">EVENROWPRINT</xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
			
			<TD align="right" CLASS="PRINT"><xsl:value-of select="orderquanity"/></TD>
			<TD WIDTH="20"></TD>
			<TD align="left" CLASS="PRINT"><xsl:value-of select="sku"/></TD>
			<TD align="left" CLASS="PRINT"><xsl:value-of select="description"/></TD>
			<TD align="right" CLASS="PRINT">$<xsl:value-of select="orderprice"/></TD>
			<TD align="right" CLASS="PRINT">$<xsl:value-of select="ordertotal"/></TD>
		</TR>
	</xsl:for-each>

   <TR><TD>&#xA0;</TD></TR>
   <TR>
      <TD/>
      <TD/>
      <TD/>
      <TD/>
      <!--TD>

         <TABLE BORDER="1">
            <TR-->
               <TH CLASS="PRINT" ALIGN="RIGHT">PO Total</TH>
            <!--/TR>
         </TABLE>
      </TD>

      <TD align="right" CLASS="PRINT">	
         <TABLE BORDER="1">
            <TR-->
               <TH CLASS="PRINT" ALIGN="RIGHT"> $<xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/originalprice"/></TH>
            <!--/TR>
         </TABLE>
      </TD-->
   </TR>
</TABLE>
<P/>

<TABLE WIDTH="675">
<!-- BUTTON NAME="PRINT" VALUE="PRINT" onClick="printReport();">Print Report</BUTTON-->
<TR ALIGN="BOTTOM">
<TD><IMG src="http://www.mysalesinfo.com/bitmaps/POReportLogo.jpg"/></TD>
</TR>
</TABLE>



</BODY></HTML>


</xsl:template>
</xsl:stylesheet>
