<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Edit Suppliers</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>



<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function setTab(focusItem) {
    focusItem.focus();
}

function validate(form) {

		if(EDITSUPPLIER.disValue[2].checked)
		{
			
			var result = confirm("Are you sure you want to DELETE the selected supplier?");
			
			if(result)
			{
				EDITSUPPLIER.submit();
				return true;
			}
			else
			{
				return false;
			}
		}	
      else
		{
			EDITSUPPLIER.submit();
		}
}

]]>
</xsl:comment>
</SCRIPT>




<BODY onLoad="setTab(EDITSUPPLIER.SUPPLIER)">


<CENTER><H1>Suppliers</H1></CENTER>
<BR></BR>

<xsl:choose>
<xsl:when test="MSI/EDITSUPPLIER/DELETE[.!='']">
<CENTER><H2>Successfully Deleted Supplier!</H2></CENTER><P></P>
<BR></BR>
</xsl:when>
</xsl:choose>

<FORM METHOD="POST" NAME="EDITSUPPLIER">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<xsl:for-each select="MSI/EDITSUPPLIER/SUPPLIERLIST/SupplierTable">
<INPUT TYPE="HIDDEN">
	<xsl:attribute name="NAME"><xsl:value-of select="supplier_id"/></xsl:attribute>
	<xsl:attribute name="VALUE"><xsl:value-of select="supplier_name"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
	<xsl:attribute name="NAME"><xsl:value-of select="supplier_id"/>~<xsl:value-of select="c"/></xsl:attribute>
	<xsl:attribute name="VALUE"><xsl:value-of select="supplier_name"/></xsl:attribute>
</INPUT>


</xsl:for-each>

<TABLE CELLPADDING="2" WIDTH="100%">

<xsl:choose>
<xsl:when test="/MSI/EDITSUPPLIER/ADDSUPPLIER[.!='']">

<TR><A> 
<xsl:attribute name="HREF"><xsl:value-of select="/MSI/LAYOUT/SERVLET"/>?disValue=257</xsl:attribute>
Add New Supplier</A> 
</TR>

<TR>
<TD HEIGHT="15">
<xsl:text> </xsl:text>
</TD>
</TR>

</xsl:when>
</xsl:choose>

<TR><TD WIDTH="30%" VALIGN="TOP">Please Select Supplier to Edit</TD><TD WIDTH="70%" VALIGN="TOP"><SELECT NAME="SUPPLIER">

<xsl:for-each select="MSI/EDITSUPPLIER/SUPPLIERLIST/SupplierTable">
<xsl:sort select="supplier_name" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="supplier_id"/>~<xsl:value-of select="c"/></xsl:attribute><xsl:value-of select="supplier_name"/>
</OPTION>
</xsl:for-each>



</SELECT></TD></TR>
<TR><TD><P></P></TD></TR>
<TR><TD><P></P></TD></TR>
<TR><TD><P></P></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP"><P/>Choose Action to Perform</TD><TD WIDTH="70%" VALIGN="TOP">
<INPUT TYPE="Radio" NAME="disValue" VALUE="265" CHECKED="true"> Edit Item Info<BR></BR></INPUT>
<INPUT TYPE="Radio" NAME="disValue" VALUE="266"> Edit Supplier Info<BR></BR></INPUT>
<INPUT TYPE="Radio" NAME="disValue" VALUE="271"> Delete Selected Supplier<BR></BR></INPUT>
</TD></TR>

<TR><TD COLSPAN="2"><INPUT TYPE="BUTTON" VALUE="Perform Action" onClick="validate(this);"></INPUT></TD>
</TR>

</TABLE></FORM>


</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
