<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
     <TITLE>Pay Rep</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function reCalc() {
   form = document.COMMISSIONS;
   var field = form.CHECKTOTAL;  
   var items = form.elements;
   var sum = form.ADJUST.value*1;	

   	
   var i = 0;	
   for(i=0;i<items.length;i++)
   {
		var item = items[i];
		
		if(item != null)
		{
			if(item.type == "checkbox")
			{
			  			  if(item.checked)
			  {
					sum += item.value*1; 
			  }
			   			 
			}
		}
	}	   
   
	//
	// Change this to a dollar value
	//
	//	var sumString = '$' + ((Math.floor(sum)) ? 'test' + '.00' : (  (sum*10 == Math.floor(sum*10)) ? sum + '0' : sum)); 
	var sumString = '$' + ((Math.round(sum*100))/100);
     
	
 
	form.CHECKTOTAL.value=sumString;
}

function setTab(focusItem) {
    focusItem.focus();
}

]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="setTab(COMMISSIONS.ADJUST)">

<CENTER><H1>Current commissions received that have not been paid.</H1></CENTER><P></P>
<P></P>
<TABLE>

<TR>
<TD>Sales Rep:</TD>
<TD><xsl:value-of select="MSI/REPNAME"/></TD>
</TR>

<TR>
<TD>Check Number:</TD>
<TD><xsl:value-of select="MSI/CHECKNUM"/></TD>
</TR>

<TR>
</TR>

</TABLE>


<FORM METHOD="POST" NAME="COMMISSIONS">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<TABLE>
<TR>
<TD>Total Check:</TD>
<TD>
<INPUT TYPE="TEXT" NAME="CHECKTOTAL" readonly="yes" size="10">
<xsl:attribute name="VALUE">

<xsl:choose>			
<xsl:when test="MSI/COMINFO/POComTable/i5[.!='']">
$<xsl:value-of select="format-number(sum(MSI/COMINFO/POComTable/i5) * MSI/COMM * .01, '###,##0.00')"/>
</xsl:when>
</xsl:choose>			

</xsl:attribute>
</INPUT>
</TD>
</TR>

<TR>
<TD>Adjustments:</TD>
<TD><INPUT TYPE="TEXT" NAME="ADJUST" onBlur="reCalc();"></INPUT></TD>
</TR>

<TR>
<TD>Notes:</TD>
<TD><INPUT TYPE="TEXT" NAME="NOTES"></INPUT></TD>
</TR>
<P></P>

</TABLE>

Uncheck the payments that will not be paid at this time.
<TABLE>
		<TR>
			<TH/>
			<TH>PO Number</TH>
			<TH>Date Recevied</TH>
			<TH>Commission</TH>
			<TH>Rep Commission</TH>
			<TH>Notes</TH>
		</TR>
		
		<xsl:for-each select="MSI/COMINFO/POComTable">
		<xsl:sort select="i2" data-type="number" order="ascending"/>
	
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			
				
				<TD><INPUT TYPE="CheckBox" checked="yes" onClick="reCalc();">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="format-number(i5 * /MSI/COMM * .01, '###,##0.00')"/></xsl:attribute>
					</INPUT></TD>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i2"/></TD>
				<TD>$<xsl:value-of select="i5"/></TD>
				<TD>
					$<xsl:value-of select="format-number(i5 * /MSI/COMM * .01, '###,##0.00')"/>
				</TD>
				<TD><xsl:value-of select="i10"/></TD>
				
				<INPUT type="hidden">
					<xsl:attribute name="NAME">PO<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i3"/></xsl:attribute>
				     </INPUT>
                        
				<INPUT type="hidden">
					<xsl:attribute name="NAME">CHECK<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i0"/></xsl:attribute>
				     </INPUT>

				<INPUT type="hidden">
					<xsl:attribute name="NAME">SUPPLIER<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i1"/></xsl:attribute>
				     </INPUT>
			
				<INPUT type="hidden">
					<xsl:attribute name="NAME">AMOUNT<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i5"/></xsl:attribute>
   	     </INPUT>
	
			</TR>
		</xsl:for-each>
</TABLE>



<INPUT type="hidden" name="disValue" value="806"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/COMINFO/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT TYPE="SUBMIT" NAME="Check" VALUE="Enter Check"></INPUT>
</FORM>


</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

