/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.loader.AdaptiveServletLoader;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.session.StandardSessionManager;

public class DefaultCMSetter
extends BaseInterceptor {
    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
    }

    public void contextInit(Context ctx) throws TomcatException {
        this.setEngineHeader(ctx);
        if (ctx.getWorkDir() == null) {
            this.setWorkDir(ctx);
        }
        if (!ctx.getWorkDir().exists()) {
            ctx.getWorkDir().mkdirs();
        }
        ctx.setAttribute("sun.servlet.workdir", ctx.getWorkDir());
        ctx.setAttribute("javax.servlet.context.tempdir", ctx.getWorkDir());
        if (ctx.getSessionManager() == null) {
            ctx.setSessionManager(new StandardSessionManager());
        }
        ServletWrapper authWrapper = new ServletWrapper();
        authWrapper.setContext(ctx);
        authWrapper.setServletClass("org.apache.tomcat.servlets.AuthServlet");
        authWrapper.setServletName("tomcat.authServlet");
        ctx.addServlet(authWrapper);
        ServletWrapper errorWrapper = new ServletWrapper();
        errorWrapper.setContext(ctx);
        errorWrapper.setServletClass("org.apache.tomcat.servlets.DefaultErrorPage");
        errorWrapper.setServletName("tomcat.errorPage");
        ctx.addServlet(errorWrapper);
        ctx.setServletLoader(new AdaptiveServletLoader());
        this.initURLs(ctx);
        try {
            ServletWrapper errorWrapper1 = ctx.getServletByName("tomcat.errorPage");
            errorWrapper1.loadServlet();
        }
        catch (Exception ex) {
            System.out.println("Error loading default servlet ");
            ex.printStackTrace();
            throw new TomcatException("Error loading default error servlet ", ex);
        }
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        File homeF = new File(cm.getHome());
        Enumeration enumeration = Logger.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            File f;
            String loggerN = (String)enumeration.nextElement();
            Logger l = Logger.getLogger(loggerN);
            String path = l.getPath();
            if (path != null && !(f = new File(path)).isAbsolute()) {
                File wd = new File(homeF, path);
                l.setPath(wd.getAbsolutePath());
            }
            l.open();
        }
        File f = new File(String.valueOf(cm.getTomcatHome()) + "/conf/web.xml");
        if (!f.exists()) {
            throw new TomcatException("Wrong tomcat home " + cm.getTomcatHome());
        }
        String workDir = cm.getWorkDir();
        f = new File(workDir);
        if (!f.isAbsolute()) {
            File wd = new File(homeF, workDir);
            cm.setWorkDir(wd.getAbsolutePath());
        }
    }

    private File getAbsolute(File f, Context c) {
        if (!f.isAbsolute()) {
            ContextManager cm = c.getContextManager();
            return new File(cm.getHome(), f.getPath());
        }
        return f;
    }

    private void getJars(Vector v, File f) {
        FilenameFilter jarfilter = new FilenameFilter(){

            public boolean accept(File dir, String fname) {
                return fname.endsWith(".jar");
            }
        };
        FilenameFilter dirfilter = new FilenameFilter(){

            public boolean accept(File dir, String fname) {
                File f1 = new File(dir, fname);
                return f1.isDirectory();
            }
        };
        if (f.exists() && f.isDirectory() && f.isAbsolute()) {
            String[] jarlist = f.list(jarfilter);
            int i = 0;
            while (jarlist != null && i < jarlist.length) {
                v.addElement(jarlist[i]);
                ++i;
            }
            String[] dirlist = f.list(dirfilter);
            int i2 = 0;
            while (dirlist != null && i2 < dirlist.length) {
                File dir = new File(f, dirlist[i2]);
                this.getJars(v, dir);
                ++i2;
            }
        }
    }

    private void initURLs(Context context) {
        ServletLoader loader = context.getServletLoader();
        if (loader == null) {
            return;
        }
        String base = context.getDocBase();
        File dir = new File(String.valueOf(base) + "/WEB-INF/classes");
        if ((dir = this.getAbsolute(dir, context)).exists()) {
            loader.addRepository(dir);
        }
        File f = new File(String.valueOf(base) + "/WEB-INF/lib");
        f = this.getAbsolute(f, context);
        Vector jars = new Vector();
        this.getJars(jars, f);
        int i = 0;
        while (i < jars.size()) {
            String jarfile = (String)jars.elementAt(i);
            File jarF = new File(f, jarfile);
            loader.addRepository(this.getAbsolute(jarF, context));
            ++i;
        }
    }

    private void setEngineHeader(Context ctx) {
        String engineHeader = ctx.getEngineHeader();
        if (engineHeader == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Tomcat Web Server").append("/").append("3.1");
            sb.append(" (").append("JSP").append(" ").append("1.1");
            sb.append("; ").append("Servlet").append(" ");
            sb.append(2).append(".").append(2);
            sb.append("; Java ");
            sb.append(System.getProperty("java.version")).append("; ");
            sb.append(String.valueOf(System.getProperty("os.name")) + " ");
            sb.append(String.valueOf(System.getProperty("os.version")) + " ");
            sb.append(String.valueOf(System.getProperty("os.arch")) + "; java.vendor=");
            sb.append(System.getProperty("java.vendor")).append(")");
            engineHeader = sb.toString();
        }
        ctx.setEngineHeader(engineHeader);
    }

    private void setWorkDir(Context ctx) {
        ContextManager cm = ctx.getContextManager();
        StringBuffer sb = new StringBuffer();
        sb.append(cm.getWorkDir());
        sb.append(File.separator);
        sb.append(cm.getHostName());
        sb.append("_").append(cm.getPort());
        sb.append(URLEncoder.encode(ctx.getPath()));
        ctx.setWorkDir(new File(sb.toString()));
    }
}

