/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.distribution.ServerRequestException;
import org.nakedobjects.object.reflect.Association;

public class AssociateRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;
    private String name;
    private Object value;

    public AssociateRequest(NakedObject nakedObject, Association association, NakedObject nakedObject2) {
        super(nakedObject);
        this.name = association.getName();
        this.value = nakedObject2 == null ? null : nakedObject2.getOid();
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            Association association = (Association)nakedObject.getNakedClass().getField(this.name);
            if (association == null) {
                throw new ServerRequestException("ObjectAttributeMessage has invalid Field: " + this.name);
            }
            if (this.value == null) {
                association.set(nakedObject, null);
            } else {
                association.set(nakedObject, nakedObjectStore.getObject(this.value));
            }
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "ObjectAttribute [" + this.name + "/" + this.value + "]";
    }
}

