/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.control.About;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.reflect.Action;

public class AboutActionRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;
    private String actionName;
    private Object[] parameterOids;

    public AboutActionRequest(NakedObject nakedObject, Action action, NakedObject[] nakedObjectArray) {
        super(nakedObject);
        this.actionName = action.getName();
        this.parameterOids = new Object[nakedObjectArray.length];
        int n = 0;
        while (n < nakedObjectArray.length) {
            if (nakedObjectArray[n].getOid() == null) {
                throw new IllegalArgumentException("All parameters must have an OID to used in a message");
            }
            this.parameterOids[n] = nakedObjectArray[n].getOid();
            ++n;
        }
    }

    public About about() throws ObjectStoreException {
        this.sendRequest();
        return (About)this.response;
    }

    void generateResponse(Server server) {
        NakedObjectStore nakedObjectStore = server.getObjectStore();
        try {
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            NakedObject[] nakedObjectArray = new NakedObject[this.parameterOids.length];
            int n = 0;
            while (n < this.parameterOids.length) {
                nakedObjectArray[n] = nakedObjectStore.getObject(this.parameterOids[n]);
                ++n;
            }
            Action action = nakedObject.getNakedClass().get0ParamAction(this.actionName);
            this.response = action == null ? null : action.getAbout(nakedObject, nakedObjectArray);
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "About [" + this.actionName + "]";
    }
}

