/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.nakedobjects.basicgui.event.action.ObjectActionEvent;
import org.nakedobjects.basicgui.event.dnd.DragDropEvent;
import org.nakedobjects.basicgui.event.popup.MenuOption;
import org.nakedobjects.basicgui.event.popup.MenuOptionSet;
import org.nakedobjects.basicgui.event.popup.MenuOptionTarget;
import org.nakedobjects.basicgui.view.DebugOption;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.DisplayState;
import org.nakedobjects.basicgui.view.View;
import org.nakedobjects.basicgui.view.ViewActionEvent;
import org.nakedobjects.basicgui.view.ViewActionListener;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;

public abstract class ObjectViewer
implements Observer {
    private static int nextNo = 1;
    private final int no = nextNo++;
    private Vector listeners = new Vector();
    private Vector options = new Vector();
    private Display display;
    private View view;
    private View defaultView;
    private View alternativeView;
    private Vector optionalViews = new Vector();
    private int viewState;
    private DisplayState displayState = new DisplayState();
    public static final MenuOption debug = new DebugOption();
    private boolean isResizable = false;
    int status = 0;

    public ObjectViewer(View view) {
        this(view, null);
    }

    public ObjectViewer(View view, View view2) {
        if (view == null) {
            throw new IllegalArgumentException("Default view must be specified");
        }
        this.defaultView = view;
        this.alternativeView = view2;
        this.viewState = 0;
        this.view = view;
    }

    public ObjectViewer(View view, View view2, boolean bl) {
        this(view, view2);
        if (bl) {
            this.useView(1);
        }
    }

    public void addOption(MenuOption menuOption) {
        this.options.addElement(menuOption);
    }

    public void addView(View view) {
        this.optionalViews.addElement(view);
    }

    public synchronized void addViewActionListener(ViewActionListener viewActionListener) {
        this.listeners.addElement(viewActionListener);
    }

    public abstract boolean canDrag();

    public abstract boolean canDrop(DragDropEvent var1);

    protected boolean checkClass(NakedObject nakedObject, Class clazz) {
        NakedClass nakedClass = (NakedClass)nakedObject;
        Class clazz2 = nakedClass.getJavaType();
        return clazz.isAssignableFrom(clazz2);
    }

    public void copy(DragDropEvent dragDropEvent) {
    }

    protected abstract void debugData(StringBuffer var1);

    public String debugDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ObjectViewer: " + this + "\n");
        this.debugData(stringBuffer);
        stringBuffer.append("  For:        " + this.display + "\n");
        stringBuffer.append("  Views\n");
        stringBuffer.append("    Current:  " + this.view + "\n");
        stringBuffer.append("    Default:  " + this.defaultView + "\n");
        stringBuffer.append("    Alt:      " + this.alternativeView + "\n");
        int n = 0;
        while (n < this.optionalViews.size()) {
            stringBuffer.append("    Other:    " + this.optionalViews.elementAt(n) + "\n");
            ++n;
        }
        stringBuffer.append("    State:    " + this.viewState + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void developerPopup(ObjectActionEvent objectActionEvent) {
        this.display.showPopup(objectActionEvent.getLocation(), true);
    }

    public abstract void dispose();

    public abstract void drop(DragDropEvent var1);

    protected NakedObject createDropObject(NakedClass nakedClass) {
        NakedClass nakedClass2 = nakedClass;
        NakedObject nakedObject = nakedClass2.acquireInstance();
        nakedObject.created();
        try {
            nakedObject.makePersistent();
        }
        catch (ObjectStoreException objectStoreException) {
            return null;
        }
        return nakedObject;
    }

    public void flipView() {
        if (this.viewState == 0) {
            this.useView(1);
        } else {
            this.useView(0);
        }
    }

    public Insets getBorderInsets() {
        return this.getView().getBorderInsets(this);
    }

    public Dimension getBorderSize() {
        return this.view.getMiminumBorderSize(this);
    }

    public final Display getDisplay() {
        return this.display;
    }

    public DisplayState getDisplayState() {
        return this.displayState;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public abstract NakedObject getObject();

    public View getView() {
        return this.view;
    }

    public String idString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1) + this.no;
    }

    public void init() {
        this.getDisplay().setLayout(this.view.getLayout());
        this.getDisplay().refresh();
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void menuOptions(MenuOptionSet menuOptionSet) {
        int n = 0;
        while (n < this.options.size()) {
            menuOptionSet.add((MenuOption)this.options.elementAt(n));
            ++n;
        }
        if (this.viewState != 0) {
            menuOptionSet.add(new MenuOption("Minimize", 1){

                public void action(MenuOptionTarget menuOptionTarget, Point point) {
                    ObjectViewer.this.useView(0);
                }
            });
        }
        if (this.viewState != 1 && this.alternativeView != null) {
            String string = "As " + this.alternativeView.getName();
            menuOptionSet.add(new MenuOption(string, 1){

                public void action(MenuOptionTarget menuOptionTarget, Point point) {
                    ObjectViewer.this.useView(1);
                }
            });
        }
        int n2 = 0;
        while (n2 < this.optionalViews.size()) {
            final int n3 = n2 + 2;
            String string = "As " + ((View)this.optionalViews.elementAt(n2)).getName();
            if (this.viewState != n3) {
                menuOptionSet.add(new MenuOption(string, 1){

                    public void action(MenuOptionTarget menuOptionTarget, Point point) {
                        ObjectViewer.this.useView(n3);
                    }
                });
            }
            ++n2;
        }
        this.view.menuOptions(menuOptionSet);
    }

    public void minimize(ObjectActionEvent objectActionEvent) {
    }

    public abstract void move(DragDropEvent var1);

    public void notifyActionView(int n, int n2, NakedObject nakedObject, Point point) {
        Vector vector;
        if (nakedObject == null) {
            return;
        }
        ViewActionEvent viewActionEvent = new ViewActionEvent(n, n2, this, point, nakedObject);
        ObjectViewer objectViewer = this;
        synchronized (objectViewer) {
            vector = (Vector)this.listeners.clone();
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            ViewActionListener viewActionListener = (ViewActionListener)vector.elementAt(n3);
            switch (n) {
                case 1: {
                    viewActionListener.showResults(viewActionEvent);
                    break;
                }
                case 2: {
                    viewActionListener.open(viewActionEvent);
                    break;
                }
                case 3: {
                    viewActionListener.vacantDrop(viewActionEvent);
                }
            }
            ++n3;
        }
    }

    public void open(ObjectActionEvent objectActionEvent) {
        this.notifyActionView(2, objectActionEvent.getModifiers(), this.getObject(), objectActionEvent.getLocationOnScreen());
    }

    public void popup(ObjectActionEvent objectActionEvent) {
        this.display.showPopup(objectActionEvent.getLocation(), false);
    }

    public synchronized void removeViewActionListener(ViewActionListener viewActionListener) {
        this.listeners.removeElement(viewActionListener);
    }

    public void results(NakedObject nakedObject, Point point) {
        this.notifyActionView(1, 0, nakedObject, point);
    }

    public void setActive(boolean bl) {
        this.displayState.setActive(bl);
        this.display.repaint();
    }

    public final void setDisplay(Display display) {
        this.display = display;
    }

    public void setObject(NakedObject nakedObject) {
    }

    public void setResizable(boolean bl) {
        this.isResizable = bl;
    }

    public String toString() {
        return "Viewer" + this.no;
    }

    public String typeName() {
        return "";
    }

    public void updateDisplayState(int n) {
        this.displayState.setViewStatus(n);
        this.display.repaint();
    }

    public void useView(int n) {
        if (n < 0 || n > 2 + this.optionalViews.size()) {
            throw new IllegalArgumentException("Index must be between 0 and 2" + this.optionalViews.size());
        }
        if (n == 0) {
            this.view = this.defaultView;
        } else if (n == 1) {
            if (this.alternativeView == null) {
                throw new IllegalArgumentException("can't use 1 when no alternative view is specified");
            }
            this.view = this.alternativeView;
        } else {
            this.view = (View)this.optionalViews.elementAt(n - 2);
        }
        this.viewState = n;
        if (this.getDisplay() != null) {
            this.getDisplay().removeAll();
            this.init();
        }
    }

    public void vacantDrop(DragDropEvent dragDropEvent) {
        this.notifyActionView(3, dragDropEvent.getModifiers(), this.getObject(), dragDropEvent.getLocationOnScreen());
    }

    public abstract void update(Observable var1, Object var2);
}

