NAME    = winoem
SRCS	= $(NAME).c
OBJS	=

LIBS    = libw slibcew commdlg
MOD     = -AS

##### Include Macro #####
INCLS	= $(NAME).h

##### Resource Macro #####
RCFILES = $(NAME).rc

DDEF	=
CLOPT	= -Os
LOPT	=

##### General Macros #####
DEF	=

##### Tool Macros #####
ASM	= masm -Mx $(MOPT) $(DDEF) $(DEF)
CC      = cl -AS -Os -Gsw -c -Zpe $(MOD)
LINK    = link /NOD /NOE $(LOPT)
RC	= rc $(DDEF) $(DEF)
HC	= hc

##### Inference Rules #####
.c.obj:
    $(CC) $*.c

.asm.obj:
    $(ASM) $*.asm;

.rc.res:
    $(RC) -r $*.rc

##### Main (default) Target #####
goal: $(NAME).exe

##### Dependents For Goal and Command Line #####
$(NAME).exe: $(SRCS:.c=.obj) $(NAME).def $(NAME).res
    $(LINK) @<<
    $(SRCS:.c=.obj) $(OBJS),
    $(NAME).exe,
    $(NAME).map,
    $(LIBS),
    $(NAME).def
<<
    $(RC) -T $(NAME).res

    del $(NAME).res
    del $(NAME).obj
    del $(NAME).map
    copy $(NAME).exe ..\$(NAME).exe
    del $(NAME).exe

##### Dependents #####
$(SRCS:.c=.obj):  $(INCLS)
$(NAME).res: $(RCFILES)

##### Clean Directory #####
clean:
    -del *.obj
    -del *.res
    -del *.exe
    -del *.sym
    -del *.map
