/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : vgapal.c                                                  */
/* Description  : low level vga palette set-up routines                     */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include "stdkeys.h"

static unsigned char rgbinfo[256][3];

int clearpalette()
{
  int idx;

  for (idx = 0; idx < 256; idx++) {
   rgbinfo[idx][0] = ASCIIZ;
   rgbinfo[idx][1] = ASCIIZ;
   rgbinfo[idx][2] = ASCIIZ;
  }
  return 0;
}

/* set a 6 bit register value in our array using an 8 bit gun value */
int setpalettereg(unsigned char r, unsigned char g, unsigned char b, int idx)
{
   rgbinfo[idx][0] = (r>>2)&63;
   rgbinfo[idx][1] = (g>>2)&63;
   rgbinfo[idx][2] = (b>>2)&63;
   return 0;
}


int loadpalette(int starthere, int howmany)
{
    union REGS regs;
    struct SREGS segregs;

    regs.h.ah = 0x10;  /* fuction 10h */
    regs.h.al = 0x12;  /* subfunction 12h - set block of color registers */
    regs.x.bx = starthere;     /* start with this reg */
    regs.x.cx = howmany;       /* do this many */
    regs.x.dx = (unsigned int)rgbinfo;   /* offset to array */
    segregs.es = (unsigned int)((long)rgbinfo>>16);   /* segment of array */
    int86x(0x10,&regs,&regs,&segregs);    /* dump data to color registers */
    return 0;
}
