/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : sound.c                                                   */
/* Description  : Sound Functions                                           */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/*                                                                          */
/*  a sound function in Microsoft C                                         */
/*                                                                          */
/* ------------------------------------------------------------------------ */
#include <dos.h>

#define TIMEOUT 0x2c00

/* freq of sound in Hertz                  */
/* duration of sound 18.2 ticks per second */

void sound(int freq, int tlen)
{
  union REGS inregs, outregs;
  unsigned frdiv;
  long lDiv;
  int seed, hiseed, hold=0, setting;

  if (tlen < 1)
    return;

  if (freq != 32767) {
    lDiv = 1331000L/freq;        /* timer divisor */
    frdiv = (unsigned)lDiv;
    outp(0x43, 0xB6) ;           /* write timer mode register */
    outp(0x42, frdiv & 0x00FF);  /* write divisor LSB */
    outp(0x42, frdiv >> 8);      /* write divisor MSB */
    setting = inp(0x61);         /* get current port B setting */
    outp(0x61,setting | 0x03);   /* turn speaker on */
  }

  if(tlen > 0) {
    tlen = ((tlen*1000) /182); /* convert from 18.2 ticks to 100ths */
    inregs.x.ax = TIMEOUT;
    int86(0x21, &inregs, &outregs);
    seed = (outregs.x.dx)&0xff;

    while(hold<tlen) {
      inregs.x.ax = TIMEOUT;
      int86(0x21,&inregs,&outregs);
      if(seed!=(outregs.x.dx&0xff)) {
        hiseed= (outregs.x.dx)&0xff;
        if (hiseed < seed)
          hiseed+=100;
        hold+=(hiseed-seed);
        seed =(outregs.x.dx)&0xff;
      }
    }
  }

  /* restore port B setting */
  if (freq != 32767)
    outp(0x61,setting);
  return;
}


void beep()
{
  sound(500,1);
  sound(1000,1);
  sound(500, 1);

}

void bronx()
{
  sound(60, 5);
  sound(40, 10);
}
