/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : bread.c                                                   */
/* Description  : header file for bread.c                                   */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */
#define _BREAD_C_

#include "std.h"
#include "stdkeys.h"
#include "cgaload.h"
#include "bread.h"

int bread(char *name)
{
  int fh, fh2, idx, y;
  unsigned char headbuf[sizeof(ucBsavedHeader)];

  /* open the file twice, eliminate the interleaf, read contiguous */

  /* open first handle */
  if (INVALID_HANDLE == (fh = open(name,O_RDONLY|O_BINARY)))
    return INVALID_HANDLE;

  /* check header... */
  read(fh, headbuf, sizeof(ucBsavedHeader));
  for (idx = 0; idx < 4; idx++)
    if (headbuf[idx] != ucBsavedHeader[idx]) {
      close(fh);
      return INVALID_HEADER;
    }

  /* open second handle */
  if (INVALID_HANDLE == (fh2 = open(name,O_RDONLY|O_BINARY))) {
    close(fh);
    return INVALID_HANDLE;
  }
  /* seek to the interleaf */
  lseek(fh2,(long)(sizeof(ucBsavedHeader) + CGA_INTERLEAF), SEEK_SET);

 /* read into the buffer in memory */
  y  = 0;
  for (idx = 0; idx < 100; idx++) {

    read(fh, &cgascreenbuffer[y], CGA_LINE_SIZE);
    y += CGA_LINE_SIZE;

    read(fh2, &cgascreenbuffer[y], CGA_LINE_SIZE);
    y += CGA_LINE_SIZE;
  }

  close(fh);
  close(fh2);

  return (SUCCESS);

}
